/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.AmnesiaBoneItem;
import doggytalents.common.network.packet.DogPacket;
import doggytalents.common.network.packet.data.DogMigrateOwnerData;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DogMigrateOwnerPacket
extends DogPacket<DogMigrateOwnerData> {
    @Override
    public void encode(DogMigrateOwnerData data, class_2540 buf) {
        buf.writeInt(data.entityId);
        buf.writeBoolean(data.confirmed);
    }

    @Override
    public DogMigrateOwnerData decode(class_2540 buf) {
        int id = buf.readInt();
        boolean confirmed = buf.readBoolean();
        return new DogMigrateOwnerData(id, confirmed);
    }

    @Override
    public void handleDog(Dog dog, DogMigrateOwnerData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
        class_3222 sender = ctx.get().getSender();
        class_1799 stack = sender.method_6047();
        if (stack.method_7909() != DoggyItems.AMNESIA_BONE.get()) {
            return;
        }
        if (sender.method_7357().method_7904(DoggyItems.AMNESIA_BONE.get())) {
            return;
        }
        UUID ownerUUID = dog.method_6139();
        if (ownerUUID == null) {
            return;
        }
        if (!ownerUUID.equals(sender.method_5667())) {
            return;
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return;
        }
        if (!tag.method_25928("request_uuid")) {
            tag.method_10551("request_str");
            return;
        }
        UUID uuid = tag.method_25926("request_uuid");
        tag.method_10551("request_uuid");
        tag.method_10551("request_str");
        if (ownerUUID.equals(uuid)) {
            return;
        }
        class_1657 requester = dog.method_37908().method_18470(uuid);
        if (requester == null) {
            return;
        }
        if (!data.confirmed) {
            requester.method_43496((class_2561)class_2561.method_43469((String)"item.doggytalents.amnesia_bone.migrate_owner.reject", (Object[])new Object[]{dog.method_5477().getString()}).method_27692(class_124.field_1061));
            return;
        }
        if (sender.field_7520 < AmnesiaBoneItem.getMigrateOwnerXPCost()) {
            return;
        }
        dog.migrateOwner(uuid);
        sender.method_7316(-AmnesiaBoneItem.getMigrateOwnerXPCost());
        sender.method_7357().method_7906(DoggyItems.AMNESIA_BONE.get(), 60);
        int usedTime = tag.method_10550("amnesia_bone_used_time");
        if (++usedTime >= AmnesiaBoneItem.getUseCap()) {
            stack.method_7934(1);
            sender.method_20235(class_1304.field_6173);
        }
        tag.method_10569("amnesia_bone_used_time", usedTime);
        requester.method_43496((class_2561)class_2561.method_43469((String)"item.doggytalents.amnesia_bone.migrate_owner.confirmed", (Object[])new Object[]{dog.method_5477().getString(), dog.getGenderPronoun()}));
    }
}

