/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.Accessory;
import doggytalents.api.registry.AccessoryInstance;
import doggytalents.api.registry.TalentInstance;
import doggytalents.client.event.ClientEventHandler;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.packet.data.DogSyncData;
import doggytalents.common.util.NetworkUtil;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2359;
import net.minecraft.class_2540;

public class DogSyncDataPacket
implements IPacket<DogSyncData> {
    @Override
    public void encode(DogSyncData data, class_2540 buf) {
        Optional<ArrayList<TalentInstance>> refreshOptionOptional;
        Optional<ArrayList<AccessoryInstance>> accessoriesOptional;
        buf.writeInt(data.dogId);
        Optional<ArrayList<TalentInstance>> talentsOptional = data.talents();
        if (talentsOptional.isPresent()) {
            buf.writeInt(ReadState.TALENTS.getId());
            this.writeTalents(talentsOptional.get(), buf);
        }
        if ((accessoriesOptional = data.accessories()).isPresent()) {
            buf.writeInt(ReadState.ACCESSORIES.getId());
            this.writeAccessories(accessoriesOptional.get(), buf);
        }
        if ((refreshOptionOptional = data.refreshOptions()).isPresent()) {
            buf.writeInt(ReadState.TALENTS_REFRESH_OPTIONS.getId());
            this.writeTalents(refreshOptionOptional.get(), buf);
        }
        buf.writeInt(ReadState.FINISH.getId());
    }

    private void writeTalents(ArrayList<TalentInstance> talents, class_2540 buf) {
        buf.writeInt(talents.size());
        for (TalentInstance inst : talents) {
            NetworkUtil.writeTalentToBuf(buf, inst.getTalent());
            inst.writeToBuf(buf, NetworkUtil::writeTalentOptionToBuf);
        }
    }

    private void writeAccessories(ArrayList<AccessoryInstance> value, class_2540 buf) {
        buf.writeInt(value.size());
        for (AccessoryInstance inst : value) {
            buf.method_42065((class_2359)DoggyTalentsAPI.ACCESSORIES.get(), (Object)inst.getAccessory());
            inst.getAccessory().write(inst, buf);
        }
    }

    @Override
    public DogSyncData decode(class_2540 buf) {
        int dogId = buf.readInt();
        ReadState readState = ReadState.fromId(buf.readInt());
        ArrayList<TalentInstance> talents = null;
        ArrayList<AccessoryInstance> accessories = null;
        ArrayList<TalentInstance> refreshOptions = null;
        while (readState != ReadState.FINISH) {
            if (readState == ReadState.TALENTS) {
                talents = this.readTalents(buf);
            } else if (readState == ReadState.ACCESSORIES) {
                accessories = this.readAccessories(buf);
            } else if (readState == ReadState.TALENTS_REFRESH_OPTIONS) {
                refreshOptions = this.readTalents(buf);
            }
            readState = ReadState.fromId(buf.readInt());
        }
        return new DogSyncData(dogId, talents, accessories, refreshOptions);
    }

    private ArrayList<TalentInstance> readTalents(class_2540 buf) {
        int size = buf.readInt();
        ArrayList<TalentInstance> newInst = new ArrayList<TalentInstance>(size);
        for (int i = 0; i < size; ++i) {
            TalentInstance inst = NetworkUtil.readTalentFromBuf(buf).getDefault();
            inst.readFromBuf(buf, NetworkUtil::readTalentOptionFromBuf);
            newInst.add(inst);
        }
        return newInst;
    }

    private ArrayList<AccessoryInstance> readAccessories(class_2540 buf) {
        int size = buf.readInt();
        ArrayList<AccessoryInstance> newInst = new ArrayList<AccessoryInstance>(size);
        for (int i = 0; i < size; ++i) {
            Accessory type = (Accessory)buf.method_42064((class_2359)DoggyTalentsAPI.ACCESSORIES.get());
            newInst.add(type.createInstance(buf));
        }
        return newInst;
    }

    @Override
    public void handle(DogSyncData data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                return;
            }
            ClientEventHandler.onDogSyncedDataUpdated(data);
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum ReadState {
        FINISH(0),
        TALENTS(1),
        ACCESSORIES(2),
        TALENTS_REFRESH_OPTIONS(3);

        private int id;

        private ReadState(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static ReadState fromId(int id) {
            ReadState[] values = ReadState.values();
            return values[id];
        }
    }
}

