/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.network.packet;

import doggytalents.DoggyItems;
import doggytalents.DoggySounds;
import doggytalents.client.screen.HeelByGroupScreen;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.DogGroupsManager;
import doggytalents.common.network.IPacket;
import doggytalents.common.network.PacketHandler;
import doggytalents.common.network.packet.data.HeelByGroupData;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.EntityUtil;
import doggytalents.forge_imitate.network.ForgeNetworkHandler;
import doggytalents.forge_imitate.network.PacketDistributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_437;

public class HeelByGroupPackets {

    public static class REQUEST_HEEL
    implements IPacket<HeelByGroupData.REQUEST_HEEL> {
        @Override
        public void encode(HeelByGroupData.REQUEST_HEEL data, class_2540 buf) {
            buf.writeBoolean(data.heelAndSit);
            DogGroupsManager.DogGroup group = data.group;
            buf.writeInt(group.color);
            buf.method_10788(group.name, 16);
        }

        @Override
        public HeelByGroupData.REQUEST_HEEL decode(class_2540 buf) {
            boolean heelAndSit = buf.readBoolean();
            int color = buf.readInt();
            String name = buf.method_10800(16);
            return new HeelByGroupData.REQUEST_HEEL(new DogGroupsManager.DogGroup(name, color), heelAndSit);
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_HEEL data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                class_3222 sender = ((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                if (sender.method_7357().method_7904((class_1792)DoggyItems.WHISTLE.get())) {
                    return;
                }
                List dogs = sender.method_37908().method_8390(Dog.class, sender.method_5829().method_1009(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.method_6171((class_1309)sender) && dog.getGroups().isGroup(data.group));
                int max_heel_count = (Integer)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_HEEL_LIMIT);
                if (max_heel_count > 0 && dogs.size() > max_heel_count) {
                    Collections.sort(dogs, new EntityUtil.Sorter((class_1297)sender));
                    dogs = dogs.subList(0, max_heel_count);
                }
                for (Dog dog2 : dogs) {
                    if (dog2.method_5765()) {
                        dog2.method_5848();
                    }
                    dog2.clearTriggerableAction();
                    dog2.method_24346(data.heelAndSit);
                }
                DogUtil.dynamicSearchAndTeleportToOwnwerInBatch(sender.method_37908(), dogs, (class_1309)sender, 3);
                sender.method_37908().method_8396(null, sender.method_24515(), DoggySounds.WHISTLE_LONG.get(), class_3419.field_15248, 0.6f + sender.method_37908().field_9229.method_43057() * 0.1f, 0.4f + sender.method_37908().field_9229.method_43057() * 0.2f);
                sender.method_43496((class_2561)class_2561.method_43469((String)"dogcommand.heel_by_group", (Object[])new Object[]{class_2561.method_43470((String)data.group.name).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_36139(data.group.color))}));
                sender.method_7357().method_7906((class_1792)DoggyItems.WHISTLE.get(), 40);
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class RESPONSE_GROUP_LIST
    implements IPacket<HeelByGroupData.RESPONSE_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.RESPONSE_GROUP_LIST data, class_2540 buf) {
            int size = data.groups.size();
            buf.writeInt(size);
            for (int i = 0; i < size; ++i) {
                DogGroupsManager.DogGroup group = data.groups.get(i);
                buf.writeInt(group.color);
                buf.method_10788(group.name, 16);
            }
        }

        @Override
        public HeelByGroupData.RESPONSE_GROUP_LIST decode(class_2540 buf) {
            int size = buf.readInt();
            ArrayList<DogGroupsManager.DogGroup> groups = new ArrayList<DogGroupsManager.DogGroup>(size);
            for (int i = 0; i < size; ++i) {
                int color = buf.readInt();
                String name = buf.method_10800(16);
                groups.add(new DogGroupsManager.DogGroup(name, color));
            }
            return new HeelByGroupData.RESPONSE_GROUP_LIST(groups);
        }

        @Override
        public void handle(HeelByGroupData.RESPONSE_GROUP_LIST data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isClientRecipent()) {
                    class_310 mc = class_310.method_1551();
                    class_437 screen = mc.field_1755;
                    if (screen instanceof HeelByGroupScreen) {
                        HeelByGroupScreen groupScreen = (HeelByGroupScreen)screen;
                        groupScreen.assignResponse(data.groups);
                    }
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class REQUEST_GROUP_LIST
    implements IPacket<HeelByGroupData.REQUEST_GROUP_LIST> {
        @Override
        public void encode(HeelByGroupData.REQUEST_GROUP_LIST data, class_2540 buf) {
        }

        @Override
        public HeelByGroupData.REQUEST_GROUP_LIST decode(class_2540 buf) {
            return new HeelByGroupData.REQUEST_GROUP_LIST();
        }

        @Override
        public void handle(HeelByGroupData.REQUEST_GROUP_LIST data, Supplier<ForgeNetworkHandler.NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                if (!((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).isServerRecipent()) {
                    return;
                }
                class_3222 sender = ((ForgeNetworkHandler.NetworkEvent.Context)ctx.get()).getSender();
                List dogsList = sender.method_37908().method_8390(Dog.class, sender.method_5829().method_1009(100.0, 50.0, 100.0), dog -> dog.isDoingFine() && dog.method_6171((class_1309)sender));
                ArrayList<DogGroupsManager.DogGroup> groups_response = new ArrayList<DogGroupsManager.DogGroup>();
                for (Dog dog2 : dogsList) {
                    List<DogGroupsManager.DogGroup> groups = dog2.getGroups().getGroupsReadOnly();
                    for (DogGroupsManager.DogGroup group : groups) {
                        if (groups_response.contains(group)) continue;
                        groups_response.add(group);
                    }
                }
                PacketHandler.send(PacketDistributor.PLAYER.with(() -> sender), new HeelByGroupData.RESPONSE_GROUP_LIST(groups_response));
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

