/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.TalentsOptions;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_2487;
import net.minecraft.class_3417;

public class CreeperSweeperTalent
extends TalentInstance {
    private int cooldown;
    private boolean onlyAttackCreeper = false;

    public CreeperSweeperTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        this.cooldown = dogIn.field_6012;
    }

    @Override
    public void tick(AbstractDog dog) {
        if (this.level() > 0) {
            List list;
            if (this.level() >= this.talent.getMaxLevel() && ((Boolean)ConfigHandler.ServerConfig.getConfig(ConfigHandler.SERVER.MAX_CREEPER_SWEEPER_DONT_GROWL)).booleanValue()) {
                return;
            }
            int timeLeft = this.cooldown - dog.field_6012;
            if (!(timeLeft > 0 || dog.method_6172() && !dog.method_5765() || (list = dog.method_37908().method_18467(class_1548.class, dog.method_5829().method_1009((double)this.getSearchRange(dog), (double)(this.level() * 2), (double)this.getSearchRange(dog)))).isEmpty())) {
                dog.method_5783(class_3417.field_14575, dog.method_6107(), (dog.method_6051().method_43057() - dog.method_6051().method_43057()) * 0.2f + 1.0f);
                this.cooldown = dog.field_6012 + 60 + dog.method_6051().method_43048(40);
            }
        }
    }

    private int getSearchRange(AbstractDog dog) {
        if (dog instanceof Dog) {
            Dog d = (Dog)dog;
            if (d.isMode(EnumMode.GUARD, EnumMode.GUARD_FLAT, EnumMode.GUARD_MINOR)) {
                return Math.min(this.level() * 5, 8);
            }
        }
        return this.level() * 5;
    }

    @Override
    public class_1269 canAttack(AbstractDog dog, class_1309 entity) {
        if (this.level() >= 5 && this.onlyAttackCreeper) {
            return entity instanceof class_1548 ? class_1269.field_5812 : class_1269.field_5814;
        }
        return entity instanceof class_1548 && this.level() >= 5 ? class_1269.field_5812 : class_1269.field_5811;
    }

    @Override
    public class_1269 shouldAttackEntity(AbstractDog dog, class_1309 target, class_1309 owner) {
        if (this.level() >= 5 && this.onlyAttackCreeper) {
            return target instanceof class_1548 ? class_1269.field_5812 : class_1269.field_5814;
        }
        return target instanceof class_1548 && this.level() >= 5 ? class_1269.field_5812 : class_1269.field_5811;
    }

    @Override
    public void doAdditionalAttackEffects(AbstractDog dogIn, class_1297 target) {
        if (this.level() < 5) {
            return;
        }
        if (!(target instanceof class_1548)) {
            return;
        }
        class_1548 creeper = (class_1548)target;
        creeper.method_6033(0.0f);
        creeper.method_6078(dogIn.method_48923().method_48812((class_1309)dogIn));
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        this.onlyAttackCreeper = compound.method_10577("targetOnlyCreeper");
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10556("targetOnlyCreeper", this.onlyAttackCreeper);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            return this.onlyAttackCreeper;
        }
        return null;
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.CREEPER_SWEEPER_EXC.get());
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.CREEPER_SWEEPER_EXC.get()) {
            this.onlyAttackCreeper = (Boolean)data;
        }
    }

    public boolean onlyAttackCreeper() {
        return this.onlyAttackCreeper;
    }

    public void setOnlyAttackCreeper(boolean val) {
        this.onlyAttackCreeper = val;
    }
}

