/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.anim.DogAnimation;
import doggytalents.api.impl.DogAlterationProps;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.ai.nav.DogFlyingMoveControl;
import doggytalents.common.entity.ai.nav.DogFlyingNavigation;
import doggytalents.forge_imitate.atrrib.ForgeMod;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_5134;

public class FlyingFurballTalent
extends TalentInstance {
    private static UUID FLYING_FURBALL_BOOST_UUID = UUID.fromString("2a802049-97d0-4de5-934e-e24ed1d2ab9f");
    private static UUID FLYING_FURBALL_GRAVITY_UUID = UUID.fromString("76390e7e-e38d-4de5-8fce-83af09b03a3e");
    private DogFlyingMoveControl moveControl;
    private DogFlyingNavigation navigation;
    private boolean wasFlying = false;
    private int flyHoldTick = 0;

    public FlyingFurballTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (!(dog instanceof Dog)) {
            return;
        }
        Dog d = (Dog)dog;
        d.setAttributeModifier(class_5134.field_23720, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
        this.moveControl = new DogFlyingMoveControl(d, this);
        this.navigation = new DogFlyingNavigation(d, dog.method_37908());
        this.startGliding(dog);
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier(class_5134.field_23720, FLYING_FURBALL_BOOST_UUID, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dogIn) {
        Dog d;
        if (dogIn.method_37908().field_9236) {
            return;
        }
        dogIn.removeAttributeModifier(class_5134.field_23720, FLYING_FURBALL_BOOST_UUID);
        dogIn.resetMoveControl();
        dogIn.resetNavigation();
        dogIn.setDogFlying(false);
        this.stopGliding(dogIn);
        dogIn.method_5875(false);
        if (dogIn instanceof Dog && (d = (Dog)dogIn).getAnim() == DogAnimation.FLY_AIR_BOURNE) {
            d.setAnim(DogAnimation.NONE);
        }
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        dog.field_6017 = 0.0f;
        if (this.flyHoldTick > 0) {
            --this.flyHoldTick;
        }
        boolean isDogFlying = dog.isDogFlying();
        if (dog.method_5942() != this.navigation && this.shouldSwitchToFlying(dog)) {
            dog.setMoveControl((class_1335)this.moveControl);
            dog.setNavigation((class_1408)this.navigation);
        }
        if (isDogFlying && this.shouldStopFlying(dog)) {
            dog.setDogFlying(false);
            dog.method_5875(false);
        }
        if (!isDogFlying && this.canBeginFlying(dog)) {
            dog.setDogFlying(true);
            this.flyHoldTick = 15;
        }
        if (isDogFlying = dog.isDogFlying()) {
            if (this.wasFlying) {
                if (dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                    dog.setAnim(DogAnimation.FLY_AIR_BOURNE);
                }
            } else {
                dog.setAnim(DogAnimation.FLY_JUMP_START);
                this.wasFlying = true;
            }
        }
        if (!isDogFlying) {
            DogAnimation anim = dog.getAnim();
            if (anim == DogAnimation.FLY_AIR_BOURNE || anim == DogAnimation.FLY_JUMP_START || this.wasFlying && anim == DogAnimation.NONE && !dog.forcedWhenNoneAnim()) {
                dog.setAnim(DogAnimation.FLY_LANDING);
            }
            this.wasFlying = false;
        }
    }

    private boolean canBeginFlying(AbstractDog dog) {
        return dog.getAnim() == DogAnimation.NONE && !dog.forcedWhenNoneAnim() && this.shouldBeFlying(dog);
    }

    private boolean shouldStopFlying(AbstractDog dog) {
        return !this.shouldBeFlying(dog);
    }

    private boolean shouldBeFlying(AbstractDog dog) {
        if (this.flyHoldTick > 0) {
            return true;
        }
        if (!dog.isDoingFine() && dog instanceof Dog) {
            Dog ddog = (Dog)dog;
            if (!ddog.incapacitatedMananger.canMove()) {
                return false;
            }
        }
        return !dog.method_24828() && !dog.method_6172() && !dog.method_5765() && !dog.method_5799() && dog.method_5942() == this.navigation;
    }

    private boolean shouldSwitchToFlying(AbstractDog dog) {
        return !dog.method_6172() && !dog.method_5765() && !dog.method_5799();
    }

    public class_1322 createSpeedModifier(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = (double)(this.level() - 1) * 0.1;
            return new class_1322(uuidIn, "Flying Furball", speed, class_1322.class_1323.field_6328);
        }
        return null;
    }

    @Override
    public void props(AbstractDog dog, DogAlterationProps props) {
        props.setCanFly().setFallImmune();
    }

    public void startGliding(AbstractDog dog) {
        dog.setAttributeModifier(ForgeMod.ENTITY_GRAVITY.get(), FLYING_FURBALL_GRAVITY_UUID, this::createGravityModifier);
    }

    public void stopGliding(AbstractDog dog) {
        dog.removeAttributeModifier(ForgeMod.ENTITY_GRAVITY.get(), FLYING_FURBALL_GRAVITY_UUID);
    }

    public class_1322 createGravityModifier(AbstractDog dogIn, UUID uuidIn) {
        return new class_1322(uuidIn, "Flying Furball Gravity", -0.8, class_1322.class_1323.field_6330);
    }
}

