/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyTags;
import doggytalents.DoggyTalents;
import doggytalents.TalentsOptions;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.api.registry.TalentOption;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.MeatFoodHandler;
import doggytalents.common.entity.ai.triggerable.TriggerableAction;
import doggytalents.common.inventory.PackPuppyItemHandler;
import doggytalents.common.util.DogFoodUtil;
import doggytalents.common.util.DogUtil;
import doggytalents.common.util.InventoryUtil;
import doggytalents.forge_imitate.event.LivingDropsEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import org.apache.commons.lang3.ObjectUtils;

public class PackPuppyTalent
extends TalentInstance {
    public static final int MAX_DOG_INV_VIEW = 8;
    private boolean renderChest = true;
    private boolean pickupItems = true;
    private boolean offerFood = true;
    private boolean collectKillLoot = true;
    private PackPuppyItemHandler packPuppyHandler;
    private MeatFoodHandler meatFoodHandler = new MeatFoodHandler(){

        @Override
        public boolean isFood(class_1799 stack) {
            class_4174 props = stack.method_7909().method_19264();
            if (props == null) {
                return false;
            }
            return stack.method_19267() && props.method_19232() && stack.method_7909() != class_1802.field_8511 && props.method_19230() >= 6;
        }
    };
    private final double COLLECT_RADIUS = 2.0;
    private int tickTillUpdateCollect = 10;
    private final int TRIGGER_RADIUS = 12;
    private int tickTillUpdateFood = 30;
    private static int NOTIFY_RADIUS = 20;

    public PackPuppyTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
        PackPuppyItemHandler handler;
        this.packPuppyHandler = handler = new PackPuppyItemHandler();
    }

    public PackPuppyItemHandler inventory() {
        return this.packPuppyHandler;
    }

    @Override
    public void tick(AbstractDog dogIn) {
        if (!dogIn.isDoingFine()) {
            return;
        }
        if (dogIn.method_37908().field_9236) {
            return;
        }
        this.tickDogCollectItems(dogIn);
        this.tickOfferFoodToTeammate(dogIn);
    }

    public boolean canCollectItems() {
        return this.level() >= 3;
    }

    public boolean canOfferFood() {
        return this.level() >= 4;
    }

    private void tickDogCollectItems(AbstractDog dog) {
        if (dog.method_37908().field_9236) {
            return;
        }
        if (!this.canCollectItems() || !this.pickupItems) {
            return;
        }
        if (--this.tickTillUpdateCollect > 0) {
            return;
        }
        this.tickTillUpdateCollect = 10;
        List itemList = dog.method_37908().method_8390(class_1542.class, dog.method_5829().method_1009(2.0, 1.0, 2.0), PackPuppyTalent::eligibleItemToPickUp);
        if (itemList.isEmpty()) {
            return;
        }
        for (class_1542 entity : itemList) {
            class_1799 remaining = InventoryUtil.addItem((class_1263)this.packPuppyHandler, entity.method_6983());
            if (!remaining.method_7960()) {
                entity.method_6979(remaining);
                continue;
            }
            entity.method_31472();
            dog.method_5783(class_3417.field_15197, 0.25f, ((dog.method_6051().method_43057() - dog.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    public static boolean eligibleItemToPickUp(class_1542 entity) {
        if (!entity.method_5805()) {
            return false;
        }
        if (entity.method_6977()) {
            return false;
        }
        class_1799 stack = entity.method_6983();
        return !stack.method_31573(DoggyTags.PACK_PUPPY_BLACKLIST);
    }

    private void tickOfferFoodToTeammate(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (!this.canOfferFood() || !this.offerFood) {
            return;
        }
        if (--this.tickTillUpdateFood > 0) {
            return;
        }
        this.tickTillUpdateFood = 60;
        if (!(dogIn instanceof Dog)) {
            return;
        }
        Dog dog = (Dog)dogIn;
        if (!this.hasFood(dog, dog)) {
            return;
        }
        List<Dog> hungry_dogs = this.getNearbyHungryDogs(dog);
        if (hungry_dogs.isEmpty()) {
            return;
        }
        for (Dog hungry_dog : hungry_dogs) {
            this.checkAndFeedDog(dog, hungry_dog);
        }
    }

    private void checkAndFeedDog(Dog dog, Dog target) {
        if (target == dog) {
            this.tryFeed(dog, dog, false);
            return;
        }
        if (target.isBusy()) {
            return;
        }
        if (target.method_6172()) {
            return;
        }
        if (target.method_24345()) {
            return;
        }
        if (!this.hasFood(dog, target)) {
            return;
        }
        target.triggerAction(new DogEatFromChestDogAction(target, dog));
    }

    private boolean tryFeed(Dog dog, Dog feeder, boolean findHealingFood) {
        return DogFoodUtil.tryFeed(dog, feeder, findHealingFood, this.inventory());
    }

    private List<Dog> getNearbyHungryDogs(Dog dog) {
        List dogs = dog.method_37908().method_8390(Dog.class, dog.method_5829().method_1009(12.0, 4.0, 12.0), filter_dog -> this.isEligibleDog(dog, (Dog)filter_dog));
        return dogs;
    }

    private boolean isEligibleDog(Dog offerer, Dog target) {
        if (!this.isHungryDog(target)) {
            return false;
        }
        UUID ownerUUID = offerer.method_6139();
        if (ownerUUID == null) {
            return false;
        }
        return offerer.willObeyOthers() || !ObjectUtils.notEqual((Object)ownerUUID, (Object)target.method_6139());
    }

    private boolean isHungryDog(Dog dog) {
        return dog.isDoingFine() && dog.getDogHunger() < 25.0f;
    }

    @Override
    public void set(AbstractDog dog, int preLevel) {
        if (preLevel > 0 && this.level == 0) {
            this.dropInventory(dog);
        }
    }

    @Override
    public void dropInventory(AbstractDog dogIn) {
        if (dogIn.method_37908().field_9236) {
            return;
        }
        if (dogIn.method_37908().method_8450().method_8355(class_1928.field_19389)) {
            return;
        }
        for (int i = 0; i < this.packPuppyHandler.getSlots(); ++i) {
            class_1264.method_5449((class_1937)dogIn.method_37908(), (double)dogIn.method_23317(), (double)dogIn.method_23318(), (double)dogIn.method_23321(), (class_1799)this.packPuppyHandler.getStackInSlot(i));
            this.packPuppyHandler.setStackInSlot(i, class_1799.field_8037);
        }
    }

    @Override
    public void writeToNBT(AbstractDog dogIn, class_2487 compound) {
        super.writeToNBT(dogIn, compound);
        compound.method_10543(this.packPuppyHandler.serializeNBT());
        compound.method_10556("renderChest", this.renderChest);
        compound.method_10556("pickupNearby", this.pickupItems);
        compound.method_10556("offerFood", this.offerFood);
        compound.method_10556("collectKillLoot", this.collectKillLoot);
    }

    @Override
    public void readFromNBT(AbstractDog dogIn, class_2487 compound) {
        super.readFromNBT(dogIn, compound);
        this.packPuppyHandler.deserializeNBT(compound);
        this.renderChest = compound.method_10577("renderChest");
        this.pickupItems = compound.method_10577("pickupNearby");
        this.offerFood = compound.method_10577("offerFood");
        this.collectKillLoot = compound.method_10577("collectKillLoot");
    }

    @Override
    public void onRead(AbstractDog dogIn, class_2487 compound) {
        this.packPuppyHandler.deserializeNBT(compound);
    }

    @Override
    public boolean hasRenderer() {
        return (Boolean)ConfigHandler.ClientConfig.getConfig(ConfigHandler.CLIENT.RENDER_CHEST);
    }

    public static boolean hasInventory(AbstractDog dogIn) {
        return dogIn.isDoingFine() && dogIn.getTalent(DoggyTalents.PACK_PUPPY).isPresent();
    }

    public boolean hasFood(Dog finder, Dog forWho) {
        return DogFoodUtil.dogFindFoodInInv(finder, forWho, false, this.inventory()) >= 0;
    }

    public static PackPuppyTalent getInstanceFromDog(AbstractDog dog) {
        return dog.getTalent(DoggyTalents.PACK_PUPPY).map(inst -> inst.cast(PackPuppyTalent.class)).orElse(null);
    }

    @Override
    public Object getTalentOption(TalentOption<?> entry) {
        if (entry == TalentsOptions.PACK_PUPPY_RENDER.get()) {
            return this.renderChest;
        }
        if (entry == TalentsOptions.PACK_PUPPY_PICKUP.get()) {
            return this.pickupItems;
        }
        if (entry == TalentsOptions.PACK_PUPPY_FOOD.get()) {
            return this.offerFood;
        }
        if (entry == TalentsOptions.PACK_PUPPY_LOOT.get()) {
            return this.collectKillLoot;
        }
        return null;
    }

    @Override
    public void setTalentOption(TalentOption<?> entry, Object data) {
        if (entry == TalentsOptions.PACK_PUPPY_RENDER.get()) {
            this.renderChest = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_PICKUP.get()) {
            this.pickupItems = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_FOOD.get()) {
            this.offerFood = (Boolean)data;
        }
        if (entry == TalentsOptions.PACK_PUPPY_LOOT.get()) {
            this.collectKillLoot = (Boolean)data;
        }
    }

    @Override
    public Collection<TalentOption<?>> getAllTalentOptions() {
        return List.of(TalentsOptions.PACK_PUPPY_RENDER.get(), TalentsOptions.PACK_PUPPY_LOOT.get(), TalentsOptions.PACK_PUPPY_PICKUP.get(), TalentsOptions.PACK_PUPPY_FOOD.get());
    }

    public boolean renderChest() {
        return this.renderChest;
    }

    public void setRenderChest(boolean render) {
        this.renderChest = render;
    }

    public boolean pickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean val) {
        this.pickupItems = val;
    }

    public boolean offerFood() {
        return this.offerFood;
    }

    public void setOfferFood(boolean val) {
        this.offerFood = val;
    }

    public boolean collectKillLoot() {
        return this.collectKillLoot;
    }

    public void setCollectKillLoot(boolean val) {
        this.collectKillLoot = val;
    }

    public static void mayNotifyNearbyPackPuppy(LivingDropsEvent event) {
    }

    private static Optional<Dog> findNearestChestDogToNotify(class_1309 killer) {
        List dogs = killer.method_37908().method_8390(Dog.class, killer.method_5829().method_1009((double)NOTIFY_RADIUS, 3.0, (double)NOTIFY_RADIUS), filter_dog -> PackPuppyTalent.isValidItemCollector(filter_dog, killer));
        if (dogs.isEmpty()) {
            return Optional.empty();
        }
        Dog selected_dog = (Dog)dogs.get(0);
        double min_dist = selected_dog.method_5858((class_1297)killer);
        for (Dog dog : dogs) {
            double dist = dog.method_5858((class_1297)killer);
            if (!(dist < min_dist)) continue;
            min_dist = dist;
            selected_dog = dog;
        }
        return Optional.ofNullable(selected_dog);
    }

    private static boolean isValidItemCollector(Dog dog, class_1309 killer) {
        if (!dog.isDoingFine()) {
            return false;
        }
        if (!dog.readyForNonTrivialAction()) {
            return false;
        }
        if (killer == dog) {
            return false;
        }
        UUID ownerUUID = dog.method_6139();
        if (ownerUUID == null) {
            return false;
        }
        UUID killerOwnerUUID = null;
        if (killer instanceof class_1657) {
            class_1657 player = (class_1657)killer;
            killerOwnerUUID = player.method_5667();
        } else if (killer instanceof Dog) {
            Dog killerDog = (Dog)killer;
            killerOwnerUUID = dog.method_6139();
        }
        if (killerOwnerUUID == null) {
            return false;
        }
        if (ObjectUtils.notEqual((Object)ownerUUID, (Object)killerOwnerUUID)) {
            return false;
        }
        Optional instOptional = dog.getTalent(DoggyTalents.PACK_PUPPY);
        if (!instOptional.isPresent()) {
            return false;
        }
        TalentInstance inst = (TalentInstance)instOptional.get();
        if (!(inst instanceof PackPuppyTalent)) {
            return false;
        }
        PackPuppyTalent packPup = (PackPuppyTalent)inst;
        if (!packPup.canCollectItems()) {
            return false;
        }
        if (!packPup.pickupItems()) {
            return false;
        }
        if (!packPup.collectKillLoot()) {
            return false;
        }
        PackPuppyItemHandler inv = packPup.inventory();
        if (inv == null) {
            return false;
        }
        boolean hasFreeSlot = false;
        for (int i = 0; i < inv.getSlots(); ++i) {
            class_1799 stack = inv.getStackInSlot(i);
            if (!stack.method_7960()) continue;
            hasFreeSlot = true;
            break;
        }
        return hasFreeSlot;
    }

    public static class DogEatFromChestDogAction
    extends TriggerableAction {
        private Dog target;
        private int tickTillPathRecalc;
        private final int stopDist = 2;
        private boolean enoughHealingFood = false;
        private int goToTimeout = 0;
        private int feedCooldown = 0;
        private boolean failedEating = false;

        public DogEatFromChestDogAction(Dog dog, Dog target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            this.goToTimeout = 200;
        }

        @Override
        public void tick() {
            boolean is_close_to_target;
            if (!this.stillValidTarget()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.enoughEating()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.failedEating) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            boolean bl = is_close_to_target = this.dog.method_5858((class_1297)this.target) <= 4.0;
            if (!is_close_to_target) {
                --this.goToTimeout;
            }
            if (this.goToTimeout <= 0 && !is_close_to_target) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.feedCooldown > 0) {
                --this.feedCooldown;
            }
            if (!is_close_to_target) {
                this.dog.method_5988().method_6226((class_1297)this.target, 10.0f, (float)this.dog.method_5978());
                if (--this.tickTillPathRecalc <= 0) {
                    this.tickTillPathRecalc = 10;
                    if (!this.dog.method_5934() && !this.dog.method_5765()) {
                        this.dog.method_5942().method_6335((class_1297)this.target, (double)this.dog.getUrgentSpeedModifier());
                    }
                }
            } else {
                this.dog.method_5942().method_6340();
                this.checkAndEat();
            }
        }

        @Override
        public void onStop() {
        }

        private boolean enoughEating() {
            float hunger = this.dog.getDogHunger();
            if (hunger < 80.0f) {
                return false;
            }
            return !this.dog.isDogLowHealth() || !(hunger < this.dog.getMaxHunger());
        }

        private void checkAndEat() {
            boolean dogNeedsHealing;
            if (this.feedCooldown > 0) {
                return;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return;
            }
            boolean bl = dogNeedsHealing = this.dog.isDogLowHealth() && !this.dog.method_6059(class_1294.field_5924);
            if (!this.enoughHealingFood && dogNeedsHealing) {
                this.enoughHealingFood = true;
                this.failedEating = !inst.tryFeed(this.dog, this.target, true);
            } else {
                this.failedEating = !inst.tryFeed(this.dog, this.target, false);
            }
            this.feedCooldown = this.dog.method_6051().method_43048(11);
        }

        private boolean stillValidTarget() {
            if (!this.target.method_5805()) {
                return false;
            }
            if (this.dog.method_5858((class_1297)this.target) > 256.0) {
                return false;
            }
            PackPuppyTalent inst = PackPuppyTalent.getInstanceFromDog(this.target);
            if (inst == null) {
                return false;
            }
            return inst.hasFood(this.target, this.dog);
        }
    }

    public static class DogCollectLootAction
    extends TriggerableAction {
        private class_2338 target;

        public DogCollectLootAction(Dog dog, @Nonnull class_2338 target) {
            super(dog, false, false);
            this.target = target;
        }

        @Override
        public void onStart() {
            if (this.dog.method_5707(class_243.method_24955((class_2382)this.target)) > 256.0) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            this.dog.method_5942().method_6340();
            DogUtil.moveToIfReachOrElse(this.dog, this.target, this.dog.getUrgentSpeedModifier(), 1, 1, d -> {
                this.target = null;
            });
        }

        @Override
        public void tick() {
            if (this.target == null) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
            if (this.dog.method_5942().method_6357()) {
                this.setState(TriggerableAction.ActionState.FINISHED);
                return;
            }
        }

        @Override
        public void onStop() {
        }
    }
}

