/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.DoggyAttributes;
import doggytalents.api.inferface.AbstractDog;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;

public class WolfMountTalent
extends TalentInstance {
    private static final UUID WOLF_MOUNT_JUMP = UUID.fromString("7f338124-f223-4630-8515-70ee0bfbc653");
    private int lastClickTick;

    public WolfMountTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public void init(AbstractDog dogIn) {
        dogIn.setAttributeModifier(DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void set(AbstractDog dogIn, int level) {
        dogIn.setAttributeModifier(DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP, this::createSpeedModifier);
    }

    @Override
    public void remove(AbstractDog dog) {
        dog.removeAttributeModifier(DoggyAttributes.JUMP_POWER.get(), WOLF_MOUNT_JUMP);
    }

    public class_1322 createSpeedModifier(AbstractDog dogIn, UUID uuidIn) {
        if (this.level() > 0) {
            double speed = 0.06 * (double)this.level();
            if (this.level() >= 5) {
                speed += 0.04;
            }
            return new class_1322(uuidIn, "Wolf Mount", speed, class_1322.class_1323.field_6328);
        }
        return null;
    }

    @Override
    public class_1269 processInteract(AbstractDog dog, class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960()) {
            return class_1269.field_5811;
        }
        if (this.level() <= 0) {
            return class_1269.field_5811;
        }
        if (dog.method_5782() || dog.method_5765()) {
            return class_1269.field_5811;
        }
        if (!dog.canInteract((class_1309)player)) {
            return class_1269.field_5811;
        }
        if (player.method_5765()) {
            return class_1269.field_5811;
        }
        int lastClickTick0 = this.lastClickTick;
        this.lastClickTick = player.field_6012;
        if (this.lastClickTick - lastClickTick0 > 5) {
            return class_1269.field_5811;
        }
        if (!dog.method_37908().field_9236) {
            dog.method_24346(false);
            player.method_36456(dog.method_36454());
            player.method_36457(dog.method_36455());
            player.method_5804((class_1297)dog);
        }
        return class_1269.field_5812;
    }

    @Override
    public void livingTick(AbstractDog dog) {
        if (dog.method_5782() && dog.getDogHunger() < 1.0f) {
            class_1309 control = dog.method_5642();
            if (control != null) {
                control.method_43496((class_2561)class_2561.method_43469((String)"talent.doggytalents.wolf_mount.exhausted", (Object[])new Object[]{dog.method_5477()}));
            }
            dog.method_5772();
        }
    }

    @Override
    public class_1271<Float> hungerTick(AbstractDog dogIn, float hungerTick_add) {
        if (dogIn.method_5642() != null) {
            return class_1271.method_22427((Object)Float.valueOf(hungerTick_add += this.level() < 5 ? 3.0f : 1.0f));
        }
        return class_1271.method_22430((Object)Float.valueOf(hungerTick_add));
    }

    @Override
    public class_1271<Float> calculateFallDistance(AbstractDog dogIn, float distance) {
        if (this.level() >= 5) {
            return class_1271.method_22427((Object)Float.valueOf(distance - 1.0f));
        }
        return class_1271.method_22430((Object)Float.valueOf(0.0f));
    }

    @Override
    public class_1269 shouldSkipAttackFrom(AbstractDog dogIn, class_1297 entity) {
        return dogIn.method_5794(entity) ? class_1269.field_5812 : class_1269.field_5811;
    }
}

