/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.CachedSearchUtil;

import doggytalents.common.entity.Dog;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_11;
import net.minecraft.class_14;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3532;
import net.minecraft.class_7;
import net.minecraft.class_9;

public class DogGreedyFireSafeSearchPath
extends class_11 {
    private ArrayList<class_9> nodes;
    private Dog dog;
    public boolean finished;
    private int maxLength;

    private DogGreedyFireSafeSearchPath(Dog dog, ArrayList<class_9> nodes, int maxLength) {
        super(nodes, dog.method_24515(), false);
        this.nodes = nodes;
        this.dog = dog;
        this.maxLength = maxLength;
    }

    public static DogGreedyFireSafeSearchPath create(Dog dog, int maxLength) {
        Optional<class_9> start_node = DogGreedyFireSafeSearchPath.getStartNode(dog);
        if (!start_node.isPresent()) {
            return null;
        }
        ArrayList<class_9> initNodes = new ArrayList<class_9>(maxLength);
        initNodes.add(start_node.get());
        DogGreedyFireSafeSearchPath ret = new DogGreedyFireSafeSearchPath(dog, initNodes, maxLength);
        class_9 pos = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(ret);
        if (pos == null) {
            return null;
        }
        initNodes.clear();
        initNodes.add(pos);
        return ret;
    }

    private static Optional<class_9> getStartNode(Dog dog) {
        class_2338 dog_b0 = dog.method_24515();
        if (DogGreedyFireSafeSearchPath.isValidStart(dog, dog_b0)) {
            return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(dog_b0);
        }
        class_238 dog_bb = dog.method_5829();
        int min_x = class_3532.method_15357((double)dog_bb.field_1323);
        int min_z = class_3532.method_15357((double)dog_bb.field_1321);
        int max_x = class_3532.method_15357((double)dog_bb.field_1320);
        int max_z = class_3532.method_15357((double)dog_bb.field_1324);
        for (int i = min_x; i <= max_x; ++i) {
            for (int j = min_z; j <= max_z; ++j) {
                class_2338 check_b0 = new class_2338(i, dog_b0.method_10264(), j);
                if (!DogGreedyFireSafeSearchPath.isValidStart(dog, check_b0)) continue;
                return DogGreedyFireSafeSearchPath.blockPosToNodeOptional(check_b0);
            }
        }
        return Optional.empty();
    }

    private static boolean isValidStart(Dog dog, class_2338 pos) {
        class_7 pos_type = class_14.method_23476((class_1922)dog.method_37908(), (class_2338.class_2339)pos.method_25503());
        if (pos_type == class_7.field_7) {
            return false;
        }
        float malus = dog.method_5944(pos_type);
        return malus >= 0.0f;
    }

    private static Optional<class_9> blockPosToNodeOptional(class_2338 pos) {
        return Optional.of(new class_9(pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public void method_44() {
        super.method_44();
        if (this.finished) {
            return;
        }
        if (this.method_39() >= this.maxLength) {
            return;
        }
        this.tryAppendPath();
    }

    public boolean method_46() {
        return super.method_46();
    }

    public void tryAppendPath() {
        class_9 node = DogGreedyFireSafeSearchPath.scanSurroundingForNextPos(this);
        if (node != null) {
            this.nodes.add(node);
        }
    }

    private boolean containNode(class_2338 node0) {
        for (class_9 node : this.nodes) {
            if (!node.equals((Object)new class_9(node0.method_10263(), node0.method_10264(), node0.method_10260()))) continue;
            return true;
        }
        return false;
    }

    private static class_9 scanSurroundingForNextPos(DogGreedyFireSafeSearchPath path) {
        int j;
        int i;
        if (path.nodes.isEmpty()) {
            return null;
        }
        class_2338 b0 = path.nodes.get(path.nodes.size() - 1).method_22879();
        float malus_min = Float.MAX_VALUE;
        class_9 node_chosen = null;
        boolean[] X0_BLOCKED = new boolean[2];
        boolean[] Y0_BLOCKED = new boolean[2];
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                class_9 node;
                if (i == 0 && j == 0 || i * j != 0 || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.method_10069(i, 0, j))) == null) continue;
                if (node.field_41 == class_7.field_12) {
                    return node;
                }
                if (node.field_41 == class_7.field_22) {
                    if (i != 0) {
                        Y0_BLOCKED[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    X0_BLOCKED[j > 0 ? 1 : 0] = true;
                    continue;
                }
                float malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        for (i = -1; i <= 1; ++i) {
            for (j = -1; j <= 1; ++j) {
                class_9 node;
                boolean diagonal_blocked;
                if (i == 0 && j == 0 || i * j == 0) continue;
                boolean bl = X0_BLOCKED[j > 0 ? 1 : 0] && Y0_BLOCKED[i > 0 ? 1 : 0] ? true : (diagonal_blocked = false);
                if (diagonal_blocked || (node = DogGreedyFireSafeSearchPath.checkPos(path, b0.method_10069(i, 0, j))) == null) continue;
                if (node.field_41 == class_7.field_12) {
                    return node;
                }
                if (node.field_41 == class_7.field_22) {
                    if (i != 0) {
                        Y0_BLOCKED[i > 0 ? 1 : 0] = true;
                        continue;
                    }
                    X0_BLOCKED[j > 0 ? 1 : 0] = true;
                    continue;
                }
                float malus = path.dog.method_5944(node.field_41);
                if (node_chosen != null && !(malus < malus_min)) continue;
                node_chosen = node;
                malus_min = malus;
            }
        }
        if (node_chosen != null) {
            return node_chosen;
        }
        path.finished = true;
        return null;
    }

    private static class_9 checkPos(DogGreedyFireSafeSearchPath path, class_2338 pos) {
        class_2338.class_2339 b1 = pos.method_25503();
        class_7 b1_type = class_14.method_23476((class_1922)path.dog.method_37908(), (class_2338.class_2339)b1.method_25503());
        int offsetY = 0;
        if (b1_type == class_7.field_22) {
            offsetY = 1;
        } else if (b1_type == class_7.field_7) {
            offsetY = -1;
        }
        if (offsetY != 0) {
            b1.method_10100(0, offsetY, 0);
            b1_type = class_14.method_23476((class_1922)path.dog.method_37908(), (class_2338.class_2339)b1.method_25503());
        }
        if (b1_type == class_7.field_12 || b1_type == class_7.field_22) {
            class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
            ret_node.field_41 = b1_type;
            return ret_node;
        }
        if (b1_type == class_7.field_7) {
            return null;
        }
        if (path.containNode((class_2338)b1)) {
            return null;
        }
        float malus = path.dog.method_5944(b1_type);
        if (malus < 0.0f) {
            return null;
        }
        class_9 ret_node = new class_9(b1.method_10263(), b1.method_10264(), b1.method_10260());
        ret_node.field_41 = b1_type;
        return ret_node;
    }
}

