/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util;

import doggytalents.api.forge_imitate.inventory.ItemStackHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.item.IDyeableArmorItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_8053;

public class ItemUtil {
    private static int MAX_OVERVIEW = 3;

    public static ContentOverview getContentOverview(ItemStackHandler inventory) {
        HashMap<class_1792, Integer> retMap = new HashMap<class_1792, Integer>(MAX_OVERVIEW);
        int isMore = 0;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            class_1799 stack = inventory.getStackInSlot(i);
            if (stack.method_7960()) continue;
            class_1792 item = stack.method_7909();
            Integer existing = retMap.get(item);
            if (existing != null) {
                retMap.put(item, existing + stack.method_7947());
                continue;
            }
            if (retMap.size() >= MAX_OVERVIEW) {
                ++isMore;
                continue;
            }
            retMap.put(item, stack.method_7947());
        }
        return new ContentOverview(retMap, isMore);
    }

    public static class_2487 getTag(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return new class_2487();
        }
        return tag;
    }

    public static void clearTag(class_1799 stack) {
        stack.method_7980(null);
    }

    public static void putTag(class_1799 stack, class_2487 tag) {
        stack.method_7980(tag);
    }

    public static void modifyTag(class_1799 stack, Consumer<class_2487> tag_modifier) {
        class_2487 tag = stack.method_7948();
        tag_modifier.accept(tag);
    }

    public static class_2487 getTagElement(class_1799 stack, String id) {
        class_2487 tag = ItemUtil.getTag(stack);
        if (!tag.method_10573(id, 10)) {
            return null;
        }
        return tag.method_10562(id);
    }

    public static boolean hasTag(class_1799 stack) {
        return stack.method_7985();
    }

    public static void copyTag(class_1799 from, class_1799 to) {
        class_2487 from_tag = from.method_7969();
        from_tag = from_tag != null ? from_tag.method_10553() : new class_2487();
        to.method_7980(from_tag);
    }

    public static boolean fireResistant(class_1799 stack) {
        return stack.method_7909().method_24358();
    }

    public static boolean isEddible(class_1799 stack) {
        return stack.method_19267();
    }

    public static boolean hasCustomHoverName(class_1799 stack) {
        return stack.method_7938();
    }

    public static class_2561 getCustomHoverName(class_1799 stack) {
        return stack.method_7964();
    }

    public static void clearCustomHoverName(class_1799 stack) {
        stack.method_7925();
    }

    public static int getDyeColorForStack(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IDyeableArmorItem) {
            IDyeableArmorItem dye = (IDyeableArmorItem)class_17922;
            return 0xFF000000 | dye.method_7800(stack);
        }
        return -1;
    }

    public static void setDyeColorForStack(class_1799 stack, int color) {
        class_1792 item = stack.method_7909();
        if (!(item instanceof IDyeableArmorItem)) {
            return;
        }
        IDyeableArmorItem dye = (IDyeableArmorItem)item;
        dye.method_7799(stack, color);
    }

    public static Optional<class_8053> getTrim(Dog dog, class_1799 stack) {
        return class_8053.method_48428((class_5455)dog.method_37908().method_30349(), (class_1799)stack);
    }

    public static class_2487 getWrappedTag(class_1799 stack) {
        return ItemUtil.getTag(stack);
    }

    public static void addCrossbowProj(class_1799 crossbow_stack, List<class_1799> proj_stacks) {
        String CHARGED_PROJ_TAG = "ChargedProjectiles";
        class_2487 crossbow_tag = crossbow_stack.method_7948();
        class_2499 listtag = crossbow_tag.method_10573("ChargedProjectiles", 9) ? crossbow_tag.method_10554("ChargedProjectiles", 10) : new class_2499();
        for (class_1799 proj_stack : proj_stacks) {
            class_2487 proj_tag = new class_2487();
            proj_stack.method_7953(proj_tag);
            listtag.add((Object)proj_tag);
        }
        crossbow_tag.method_10566("ChargedProjectiles", (class_2520)listtag);
        class_1764.method_7782((class_1799)crossbow_stack, (boolean)true);
    }

    public static class ContentOverview {
        private final Map<class_1792, Integer> contents;
        private int isMore = 0;

        private ContentOverview(Map<class_1792, Integer> contents, int isMore) {
            this.contents = contents;
            this.isMore = isMore;
        }

        public int isMore() {
            return this.isMore;
        }

        public Map<class_1792, Integer> contents() {
            return this.contents;
        }
    }
}

