/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import doggytalents.forge_imitate.chunk.ForgeChunkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class DogBatchTeleportToDimensionPromise
extends AbstractPromise {
    private final List<Dog> dogs;
    private final UUID playerUUID;
    private final class_5321<class_1937> dimeansion;
    private final class_3218 origin;
    private final Predicate<Dog> dogValidator;
    private int tickTillCheck;
    private int timeOut;
    private final ArrayList<class_1923> forcedDogChunk = new ArrayList();

    public DogBatchTeleportToDimensionPromise(List<Dog> dogs, class_3218 origin, UUID playerUUID, class_5321<class_1937> dimeansion, Predicate<Dog> dogValidator) {
        this.dogs = dogs;
        this.playerUUID = playerUUID;
        this.dimeansion = dimeansion;
        this.origin = origin;
        this.dogValidator = dogValidator;
    }

    @Override
    public void start() {
        this.forceDogChunk();
        this.tickTillCheck = 7;
        this.timeOut = 50;
    }

    @Override
    public void tick() {
        if (--this.timeOut <= 0) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (--this.tickTillCheck > 0) {
            return;
        }
        this.tickTillCheck = 20;
        MinecraftServer mcServer = this.origin.method_8503();
        class_3218 targetLevel = mcServer.method_3847(this.dimeansion);
        if (targetLevel == null) {
            return;
        }
        if (targetLevel == this.origin) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        class_1657 owner = targetLevel.method_18470(this.playerUUID);
        if (owner == null) {
            return;
        }
        class_2338 owner_b0 = owner.method_24515();
        if (!this.allChunkInvoledAtTargetIsLoaded(targetLevel, owner_b0)) {
            return;
        }
        List<Dog> tp_dogs = this.dogs.stream().filter(d -> d.isDoingFine()).collect(Collectors.toList());
        if (tp_dogs.isEmpty()) {
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        List<class_2338> safePosList = CachedSearchUtil.getAllSafePosUsingPool((class_1937)targetLevel, tp_dogs, owner_b0, 4, 1);
        if (safePosList.isEmpty()) {
            return;
        }
        for (Dog dog : tp_dogs) {
            int index = dog.method_6051().method_43048(safePosList.size());
            dog.method_18375();
            this.teleportDog(dog, targetLevel, safePosList.get(index));
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    private boolean allChunkInvoledAtTargetIsLoaded(class_3218 target, class_2338 ownerPos) {
        class_1923 center = new class_1923(ownerPos);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (target.method_14178().method_12123(center.field_9181 + i, center.field_9180 + j)) continue;
                return false;
            }
        }
        return true;
    }

    private void teleportDog(Dog dog0, class_3218 targetLevel, class_2338 pos) {
        if (!this.dogValidator.test(dog0)) {
            return;
        }
        dog0.authorizeChangeDimension();
        class_1297 dog = dog0.method_5731(targetLevel);
        dog.method_5725(pos, dog.method_36454(), dog.method_36455());
    }

    @Override
    public void onFulfilled() {
    }

    @Override
    public void onRejected() {
    }

    @Override
    public void cleanUp() {
        this.cleanDogChunk();
    }

    private void forceDogChunk() {
        for (Dog dog : this.dogs) {
            class_1923 chunkpos;
            if (!dog.isDoingFine() || this.forcedDogChunk.contains(chunkpos = new class_1923(dog.method_24515()))) continue;
            this.forcedDogChunk.add(chunkpos);
            ForgeChunkManager.forceChunk(this.origin, "doggytalents", this.getOwner().method_5667(), chunkpos.field_9181, chunkpos.field_9180, true, true);
        }
    }

    private void cleanDogChunk() {
        for (class_1923 chunkpos : this.forcedDogChunk) {
            ForgeChunkManager.forceChunk(this.origin, "doggytalents", this.getOwner().method_5667(), chunkpos.field_9181, chunkpos.field_9180, false, true);
        }
    }
}

