/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.util.dogpromise.promise;

import doggytalents.common.entity.Dog;
import doggytalents.common.util.CachedSearchUtil.CachedSearchUtil;
import doggytalents.common.util.dogpromise.promise.AbstractPromise;
import doggytalents.forge_imitate.chunk.ForgeChunkManager;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;

public class DogDistantTeleportToOwnerCrossDimensionPromise
extends AbstractPromise {
    private static final int TIMEOUT = 200;
    private static final int SEARCH_INTERVAL = 10;
    private final class_2338 targetPos;
    private final class_2338 dogPos;
    private final UUID dogUUID;
    private final class_3218 ownerLevel;
    private final class_3218 dogLevel;
    private int timeOutTick;
    private int tickTillSearch;
    private Dog teleportedDog;
    private final class_1309 owner;
    private boolean dogChunkForced;

    public DogDistantTeleportToOwnerCrossDimensionPromise(@Nonnull UUID dogUUID, @Nonnull class_1309 owner, @Nonnull class_2338 dogPos, class_3218 dogLevel, class_3218 ownerLevel) {
        this.dogUUID = dogUUID;
        this.ownerLevel = ownerLevel;
        this.targetPos = owner.method_24515();
        this.dogPos = dogPos;
        this.owner = owner;
        this.dogLevel = dogLevel;
    }

    @Override
    public void tick() {
        if (this.dogLevel == this.ownerLevel) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        class_1297 e = null;
        if (--this.tickTillSearch <= 0) {
            this.tickTillSearch = 10;
            e = this.dogLevel.method_14190(this.dogUUID);
        }
        if (e == null) {
            if (--this.timeOutTick <= 0) {
                this.rejectedMsg = "TIMEOUT";
                this.setState(AbstractPromise.State.REJECTED);
            }
            return;
        }
        if (!(e instanceof Dog)) {
            this.rejectedMsg = "WHAT?";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        Dog dog = (Dog)e;
        List<class_2338> safePosList = CachedSearchUtil.getAllSafePosUsingPool((class_1937)this.ownerLevel, List.of((Dog)e), this.targetPos, 4, 1);
        if (safePosList.isEmpty()) {
            this.rejectedMsg = "NOSAFEPOS";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        int r = dog.method_6051().method_43048(safePosList.size());
        class_2338 safePos = safePosList.get(r);
        dog.authorizeChangeDimension();
        class_1297 dogafterTp = dog.method_5731(this.ownerLevel);
        dog.method_5725(safePos, dog.method_36454(), dog.method_36455());
        if (dogafterTp instanceof Dog) {
            this.teleportedDog = (Dog)dogafterTp;
        }
        this.setState(AbstractPromise.State.FULFILLED);
    }

    @Override
    public void onFulfilled() {
        if (this.owner != null && this.teleportedDog != null) {
            this.owner.method_43496((class_2561)class_2561.method_43469((String)"item.doggytalents.conducting_bone.fulfilled.tp_self", (Object[])new Object[]{this.teleportedDog.method_5477().getString()}));
        }
        if (this.teleportedDog != null) {
            this.ownerLevel.method_14199((class_2394)class_2398.field_11214, this.teleportedDog.method_23317(), this.teleportedDog.method_23318(), this.teleportedDog.method_23321(), 30, (double)this.teleportedDog.method_17681(), (double)0.8f, (double)this.teleportedDog.method_17681(), 0.1);
        }
    }

    @Override
    public void onRejected() {
        if (this.owner != null) {
            this.owner.method_43496((class_2561)class_2561.method_43469((String)"item.doggytalents.conducting_bone.rejected", (Object[])new Object[]{class_2561.method_43470((String)this.rejectedMsg).method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)).method_10977(class_124.field_1061))}));
        }
    }

    @Override
    public void start() {
        if (this.ownerLevel == null || this.dogLevel == null) {
            this.rejectedMsg = "CLIENTLEVEL";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        if (this.ownerLevel == this.dogLevel) {
            this.rejectedMsg = "SAMEDIM";
            this.setState(AbstractPromise.State.REJECTED);
            return;
        }
        this.timeOutTick = 200;
        class_1923 chunkpos = new class_1923(this.dogPos);
        if (this.dogLevel.method_8393(chunkpos.field_9181, chunkpos.field_9180)) {
            return;
        }
        this.setDogChunk(true);
    }

    @Override
    public void cleanUp() {
        if (this.dogChunkForced) {
            this.setDogChunk(false);
        }
    }

    private void setDogChunk(boolean loaded) {
        if (this.dogChunkForced == loaded) {
            return;
        }
        class_1923 chunkpos = new class_1923(this.dogPos);
        ForgeChunkManager.forceChunk(this.dogLevel, "doggytalents", this.dogUUID, chunkpos.field_9181, chunkpos.field_9180, loaded, true);
        this.dogChunkForced = loaded;
    }
}

