/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful;

import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlReader;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.api.EmojiFromGithub;
import com.hrznstudio.emojiful.datapack.EmojiRecipe;
import com.hrznstudio.emojiful.platform.Services;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.minecraft.class_1863;
import net.minecraft.class_3956;

public class CommonClass {
    public static String readStringFromURL(String requestURL) {
        Scanner scanner = new Scanner(new URL(requestURL).openStream(), StandardCharsets.UTF_8.toString());
        try {
            scanner.useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return "";
            }
        }
    }

    public static JsonElement readJsonFromUrl(String url) {
        String jsonText = CommonClass.readStringFromURL(url);
        JsonElement json = new JsonParser().parse(jsonText);
        return json;
    }

    public static void main(String[] s) {
        ClientEmojiHandler.loadTwemojis();
    }

    public static List<Emoji> readCategory(String cat) throws YamlException {
        YamlReader categoryReader = new YamlReader((Reader)new StringReader(CommonClass.readStringFromURL("https://raw.githubusercontent.com/InnovativeOnlineIndustries/emojiful-assets/master/" + cat)));
        return Lists.newArrayList((Object[])((Emoji[])categoryReader.read(Emoji[].class)));
    }

    public static void onRecipesUpdated(class_1863 manager) {
        ClientEmojiHandler.CATEGORIES.removeIf(EmojiCategory::worldBased);
        Constants.EMOJI_LIST.removeIf(Emoji::worldBased);
        if (Services.CONFIG.loadDatapack()) {
            class_3956<EmojiRecipe> emojiRecipeRecipeType = Services.PLATFORM.getRecipeType();
            List emojiList = manager.method_30027(emojiRecipeRecipeType);
            for (EmojiRecipe emojiRecipe : emojiList) {
                EmojiFromGithub emoji = new EmojiFromGithub();
                emoji.name = emojiRecipe.getName();
                emoji.strings = new ArrayList();
                emoji.strings.add(":" + emojiRecipe.getName() + ":");
                emoji.location = emojiRecipe.getName();
                emoji.url = emojiRecipe.getUrl();
                emoji.worldBased = true;
                Constants.EMOJI_MAP.computeIfAbsent(emojiRecipe.getCategory(), s -> new ArrayList()).add(emoji);
                Constants.EMOJI_LIST.add(emoji);
                if (!ClientEmojiHandler.CATEGORIES.stream().noneMatch(emojiCategory -> emojiCategory.name().equalsIgnoreCase(emojiRecipe.getCategory().toLowerCase()))) continue;
                ClientEmojiHandler.CATEGORIES.add(0, new EmojiCategory(emojiRecipe.getCategory(), true));
            }
            ClientEmojiHandler.indexEmojis();
        }
    }

    public static boolean shouldKeyBeIgnored(int keyCode) {
        return keyCode == 258 || keyCode == 265 || keyCode == 264 || keyCode == 263 || keyCode == 262;
    }
}

