/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.GeneData;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.duck.FFBee;

public class BeeAttributes {
    private static final UUID SPEED_MODIFIER = UUID.fromString("d21ceda4-191f-47e7-a7c7-f5eff7012bdd");
    private static final UUID HEALTH_MODIFIER = UUID.fromString("aa3feeef-be3e-4d05-b98c-689bae6e22e7");
    private static final UUID DAMAGE_MODIFIER = UUID.fromString("168df6fe-fa8d-426f-8198-d89a5bc01397");
    private final List<String> pollens = Lists.newArrayList();
    private final GeneData genes = new GeneData();
    public boolean dirty;
    private class_1799 saddle = class_1799.field_8037;
    private List<UUID> trusted = List.of();
    @Nullable
    private class_2960 texture;
    private long mutagenEndsIn;

    public static BeeAttributes of(Object bee) {
        return ((FFBee)bee).fruits$getBeeAttributes();
    }

    public void toNBT(class_2487 data) {
        if (!this.saddle.method_7960()) {
            data.method_10566("Saddle", (class_2520)this.saddle.method_7953(new class_2487()));
        }
        if (!this.trusted.isEmpty()) {
            class_2499 trustedList = new class_2499();
            for (UUID uuid : this.trusted) {
                trustedList.add((Object)class_2519.method_23256((String)uuid.toString()));
            }
            data.method_10566("Trusted", (class_2520)trustedList);
        }
        if (!this.pollens.isEmpty()) {
            class_2499 pollensList = new class_2499();
            for (String pollen : this.pollens) {
                pollensList.add((Object)class_2519.method_23256((String)pollen));
            }
            data.method_10566("Pollens", (class_2520)pollensList);
        }
        class_2487 lociTag = new class_2487();
        this.genes.toNBT(lociTag);
        if (!lociTag.method_33133()) {
            data.method_10566("Genes", (class_2520)lociTag);
        }
    }

    public void fromNBT(class_2487 data, class_4466 bee) {
        this.saddle = class_1799.field_8037;
        if (data.method_10545("Saddle")) {
            this.saddle = class_1799.method_7915((class_2487)data.method_10562("Saddle"));
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (class_2520 tag : data.method_10554("Trusted", 8)) {
            builder.add((Object)UUID.fromString(tag.method_10714()));
        }
        this.trusted = builder.build();
        this.pollens.clear();
        for (class_2520 tag : data.method_10554("Pollens", 8)) {
            this.pollens.add(tag.method_10714());
        }
        if (data.method_10545("Genes")) {
            this.genes.fromNBT(data.method_10562("Genes"));
        }
        this.updateTraits(bee);
    }

    public void setTrusted(List<UUID> trusted) {
        this.trusted = trusted;
        this.dirty = true;
    }

    public void addTrusted(UUID uuid) {
        if (this.trusted.contains(uuid)) {
            return;
        }
        this.setTrusted((List<UUID>)ImmutableList.builder().addAll(this.trusted).add((Object)uuid).build());
    }

    public List<UUID> getTrusted() {
        return this.trusted;
    }

    public List<String> getPollens() {
        return this.pollens;
    }

    public boolean isSaddled() {
        return !this.saddle.method_7960();
    }

    public boolean isSaddleable() {
        return this.hasTrait(Trait.MOUNTABLE);
    }

    public void setSaddle(class_1799 saddle) {
        this.saddle = saddle;
        this.dirty = true;
    }

    public class_1799 getSaddle() {
        return this.saddle;
    }

    public boolean trusts(UUID uuid) {
        return this.trusted.contains(uuid);
    }

    public void updateTraits(class_4466 bee) {
        this.genes.updateTraits();
        this.updateTexture();
        if (bee.method_37908().field_9236) {
            return;
        }
        class_1324 speedInstance = Objects.requireNonNull(bee.method_5996(class_5134.field_23720));
        class_1324 healthInstance = Objects.requireNonNull(bee.method_5996(class_5134.field_23716));
        class_1324 damageInstance = Objects.requireNonNull(bee.method_5996(class_5134.field_23721));
        speedInstance.method_27304(SPEED_MODIFIER);
        healthInstance.method_27304(HEALTH_MODIFIER);
        damageInstance.method_27304(DAMAGE_MODIFIER);
        if (this.hasTrait(Trait.FASTER)) {
            speedInstance.method_26837(new class_1322(SPEED_MODIFIER, "Genetic speed bonus", 0.25, class_1322.class_1323.field_6328));
        } else if (this.hasTrait(Trait.FAST)) {
            speedInstance.method_26837(new class_1322(SPEED_MODIFIER, "Genetic speed bonus", 0.15, class_1322.class_1323.field_6328));
        }
        boolean lazy = this.hasTrait(Trait.LAZY);
        if (lazy || this.hasTrait(Trait.WARRIOR)) {
            float healthRatio = bee.method_6032() / bee.method_6063();
            if (lazy) {
                healthInstance.method_26837(new class_1322(HEALTH_MODIFIER, "Genetic health bonus", 5.0, class_1322.class_1323.field_6328));
            } else {
                healthInstance.method_26837(new class_1322(HEALTH_MODIFIER, "Genetic health bonus", 10.0, class_1322.class_1323.field_6328));
                damageInstance.method_26837(new class_1322(DAMAGE_MODIFIER, "Genetic damage bonus", 2.0, class_1322.class_1323.field_6328));
            }
            bee.method_6033(healthRatio * bee.method_6063());
        }
        this.dirty = true;
    }

    public void updateTexture() {
        if (this.hasTrait(Trait.PINK)) {
            this.setTexture(new class_2960("fruitfulfun", "pink_bee"));
        } else if (this.hasTrait(Trait.WITHER_TOLERANT)) {
            this.setTexture(new class_2960("fruitfulfun", "wither_bee"));
        } else {
            this.setTexture(null);
        }
    }

    @Nullable
    public class_2960 getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable class_2960 texture) {
        this.texture = texture;
        this.dirty = true;
    }

    public void setMutagenEndsIn(long mutagenEndsIn, long gameTime) {
        if (this.mutagenEndsIn == mutagenEndsIn) {
            return;
        }
        if (mutagenEndsIn == 0L && this.mutagenEndsIn <= gameTime) {
            return;
        }
        this.mutagenEndsIn = mutagenEndsIn;
        this.dirty = true;
    }

    public long getMutagenEndsIn() {
        return this.mutagenEndsIn;
    }

    public boolean hasTrait(Trait trait) {
        return this.genes.hasTrait(trait);
    }

    public GeneData getGenes() {
        return this.genes;
    }

    public Locus getLocus(Allele allele) {
        return this.genes.getLocus(allele);
    }

    public void randomize(class_4466 bee) {
        this.genes.randomize(bee.method_6051());
        this.updateTraits(bee);
    }
}

