/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1845;
import net.minecraft.class_1856;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_3988;
import net.minecraft.class_4081;
import net.minecraft.class_4482;
import net.minecraft.class_5945;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeHasTrait;
import snownee.fruits.bee.HybridizingRecipe;
import snownee.fruits.bee.HybridizingRecipeType;
import snownee.fruits.bee.InspectorItem;
import snownee.fruits.bee.genetics.GeneData;
import snownee.fruits.bee.genetics.MutagenItem;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.loader.event.InitEvent;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.mixin.LootContextParamSetsAccess;

@KiwiModule(value="bee")
@KiwiModule.Optional
public class BeeModule
extends AbstractModule {
    @KiwiModule.Name(value="hybridizing")
    public static final KiwiGO<HybridizingRecipeType> RECIPE_TYPE = BeeModule.go(() -> new HybridizingRecipeType("fruitfulfun:hybridizing", HybridizingRecipe.class, null));
    @KiwiModule.Name(value="hybridizing")
    public static final KiwiGO<LycheeRecipe.Serializer<HybridizingRecipe>> SERIALIZER = BeeModule.go(HybridizingRecipe.Serializer::new);
    public static final KiwiGO<ContextualConditionType<BeeHasTrait>> BEE_HAS_TRAIT = BeeModule.go(BeeHasTrait.Type::new, () -> LycheeRegistries.CONTEXTUAL);
    public static class_2960 BEE_ONE_CM = new class_2960("fruitfulfun", "bee_one_cm");
    public static class_2960 BEES_BRED = new class_2960("fruitfulfun", "bees_bred");
    public static final KiwiGO<class_3414> BEE_SHEAR = BeeModule.go(() -> class_3414.method_47908((class_2960)new class_2960("fruitfulfun", "entity.bee.shear")));
    @KiwiModule.Category(value={"tools"}, after={"shears"})
    public static final KiwiGO<class_1792> INSPECTOR = BeeModule.go(() -> new InspectorItem(BeeModule.itemProp()));
    public static final KiwiGO<MutagenItem> MUTAGEN = BeeModule.go(MutagenItem::new);
    public static final KiwiGO<class_1291> MUTAGEN_EFFECT = BeeModule.go(() -> new class_1291(class_4081.field_18273, 15981803));
    public static final String WAXED_MARKER_NAME = "@FruitfulFunWaxed";
    public static final int WAXED_TICKS = 1200;
    public static Set<class_3852> BEEKEEPER_PROFESSIONS;

    public BeeModule() {
        Hooks.bee = true;
        LootContextParamSetsAccess.callRegister((String)"fruitfulfun:hybridizing", $ -> $.method_781(class_181.field_24424).method_781(class_181.field_1226).method_781(class_181.field_1224).method_781(LycheeLootContextParams.BLOCK_POS).method_780(class_181.field_1228));
    }

    public static boolean isWaxedMarker(class_8113 display) {
        return display.method_5864() == class_1299.field_42460 && display.method_5797() != null && display.method_5797().getString().equals(WAXED_MARKER_NAME);
    }

    public static void tickWaxedMarker(class_8113 display) {
        class_1937 level = display.method_37908();
        if (level.field_9236) {
            if (display.field_5974.method_43048(50) == 0) {
                class_5945.method_34682((class_1937)level, (class_2338)display.method_24515(), (class_2394)class_2398.field_29642, (class_6017)class_6019.method_35017((int)2, (int)4));
            }
            return;
        }
        if (!Hooks.bee || display.field_6012 > 1200) {
            display.method_31472();
        } else if (display.field_6012 % 20 == 0 && !(level.method_8321(display.method_24515()) instanceof class_4482)) {
            display.method_31472();
        }
    }

    public static void addBeekeeperTrades(class_1916 merchantOffers, class_3988 villager) {
        if (!Hooks.bee || !FFCommonConfig.beehiveTrade) {
            return;
        }
        if (BEEKEEPER_PROFESSIONS == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (class_3852 profession : class_7923.field_41195) {
                if (!profession.comp_818().endsWith("beekeeper")) continue;
                builder.add((Object)profession);
            }
            BEEKEEPER_PROFESSIONS = builder.build();
        }
        if (villager instanceof class_1646) {
            class_1646 v = (class_1646)villager;
            if (v.method_7231().method_16925() != 1) {
                return;
            }
            if (!BEEKEEPER_PROFESSIONS.contains(v.method_7231().method_16924())) {
                return;
            }
        } else if (villager.method_5864() == class_1299.field_17713) {
            if (!BEEKEEPER_PROFESSIONS.isEmpty()) {
                return;
            }
        } else {
            return;
        }
        class_1799 input = class_1802.field_20416.method_7854();
        input.method_7977((class_2561)class_2561.method_43471((String)"tip.fruitfulfun.beehiveTradeInputName"));
        input.method_7948().method_10556("FFTrade", true);
        class_2499 lore = new class_2499();
        lore.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)class_2561.method_43471((String)"tip.fruitfulfun.beehiveTradeInputHint"))));
        input.method_7948().method_10562("display").method_10566("Lore", (class_2520)lore);
        class_1799 output = class_1802.field_8687.method_7854();
        output.method_7948().method_10556("FFTrade", true);
        merchantOffers.add((Object)new class_1914(input, output, 1000, 2, 0.0f));
    }

    public static boolean isBeehiveTrade(class_1914 merchantOffer) {
        class_1799 cost = merchantOffer.method_8246();
        return cost.method_31574(class_1802.field_20416) && cost.method_7969() != null && cost.method_7969().method_10577("FFTrade");
    }

    protected void preInit() {
        CommonProxy.initBeeModule();
    }

    protected void init(InitEvent event) {
        event.enqueueWork(() -> {
            RecipeTypes.ALL.add((LycheeRecipeType)RECIPE_TYPE.get());
            class_1845.field_8957.add(class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)MUTAGEN.get()}));
        });
    }

    public static int getBeesValue(List<GeneData> dataList) {
        block9: {
            if (dataList.isEmpty()) {
                return 0;
            }
            int value = 0;
            for (GeneData geneData : dataList) {
                int singleValue = 0;
                for (Trait trait : geneData.getTraits()) {
                    singleValue += trait.value();
                }
                if (geneData.hasTrait(Trait.FASTER) && geneData.hasTrait(Trait.MOUNTABLE)) {
                    singleValue += geneData.hasTrait(Trait.RAIN_CAPABLE) ? 4 : 2;
                } else if (geneData.hasTrait(Trait.ADVANCED_POLLINATION) && geneData.hasTrait(Trait.WITHER_TOLERANT)) {
                    singleValue += 3;
                }
                value += Math.max(0, singleValue);
            }
            if (value > 0 && dataList.size() >= 3) {
                Set<Trait> first = dataList.get(0).getTraits();
                for (int i = 1; i < dataList.size(); ++i) {
                    if (first.equals(dataList.get(i).getTraits())) {
                        continue;
                    }
                    break block9;
                }
                value += (int)((float)value * 0.5f);
            }
        }
        return value += dataList.size();
    }
}

