/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4550;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.kiwi.util.Util;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.json.JsonPointer;

public class HybridizingRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyRecipe<HybridizingRecipe> {
    public Collection<String> pollens = List.of();
    public Collection<String> endingStep = List.of();
    public class_2371<class_1856> ingredients;

    public HybridizingRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(LycheeContext ctx, class_1937 worldIn) {
        BeeAttributes attributes = BeeAttributes.of(ctx.getParam(class_181.field_1226));
        return attributes.getPollens().size() >= this.pollens.size() && attributes.getPollens().containsAll(this.pollens);
    }

    public LycheeRecipe.Serializer<?> getSerializer() {
        return (LycheeRecipe.Serializer)BeeModule.SERIALIZER.get();
    }

    public LycheeRecipeType<?, ?> getType() {
        return (LycheeRecipeType)BeeModule.RECIPE_TYPE.get();
    }

    public int compareTo(@NotNull HybridizingRecipe o) {
        return 0;
    }

    public class_4550 getBlock() {
        return class_4550.field_20692;
    }

    public Collection<String> endingStep() {
        if (this.endingStep.isEmpty()) {
            return this.pollens;
        }
        return this.endingStep;
    }

    @NotNull
    public class_2371<class_1856> method_8117() {
        this.refreshIngredients();
        return this.ingredients;
    }

    public void refreshIngredients() {
        if (this.ingredients != null) {
            return;
        }
        this.ingredients = class_2371.method_10211();
        for (String pollen : this.pollens) {
            class_1792 item = ((class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)pollen))).method_8389();
            if (item == class_1802.field_8162) continue;
            this.ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
        }
    }

    public IntList getItemIndexes(JsonPointer pointer) {
        return IntList.of();
    }

    public void addInvisibleInputs(Consumer<class_1799> acceptor) {
        for (String pollen : this.pollens) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)pollen));
            if (!(block instanceof FruitLeavesBlock)) continue;
            FruitLeavesBlock leavesBlock = (FruitLeavesBlock)block;
            acceptor.accept(new class_1799((class_1935)leavesBlock.type.get().sapling.get()));
        }
    }

    public void addInvisibleOutputs(Consumer<class_1799> acceptor) {
        ILycheeRecipe.filterHidden((Stream)this.getAllActions()).flatMap($ -> $.getItemOutputs().stream()).map(class_1799::method_7909).distinct().map($ -> {
            class_2248 patt3805$temp = class_2248.method_9503((class_1792)$);
            if (patt3805$temp instanceof FruitLeavesBlock) {
                FruitLeavesBlock block = (FruitLeavesBlock)patt3805$temp;
                return new class_1799((class_1935)block.type.get().sapling.get());
            }
            return null;
        }).filter(Objects::nonNull).forEach(acceptor);
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<HybridizingRecipe> {
        public Serializer() {
            super(HybridizingRecipe::new);
        }

        public void fromJson(HybridizingRecipe recipe, JsonObject jsonObject) {
            JsonArray ingredients = class_3518.method_15261((JsonObject)jsonObject, (String)"pollens");
            Preconditions.checkArgument((!ingredients.isEmpty() && ingredients.size() <= 4 ? 1 : 0) != 0, (Object)"Size of pollens has to be in [1, 4]");
            recipe.pollens = Sets.newLinkedHashSetWithExpectedSize((int)ingredients.size());
            for (JsonElement element : ingredients) {
                String s = element.getAsString();
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)s));
                Preconditions.checkArgument((block != class_2246.field_10124 ? 1 : 0) != 0, (Object)("Unknown block: " + s));
                recipe.pollens.add(Util.trimRL((String)s));
            }
            Preconditions.checkArgument((recipe.pollens.size() == Set.copyOf(recipe.pollens).size() ? 1 : 0) != 0, (Object)"Pollens must be unique");
            JsonArray endingStep = class_3518.method_15292((JsonObject)jsonObject, (String)"ending_step", null);
            if (endingStep != null) {
                Preconditions.checkArgument((!endingStep.isEmpty() && endingStep.size() <= 4 ? 1 : 0) != 0, (Object)"Size of ending_step has to be in [1, 4]");
                recipe.endingStep = Sets.newLinkedHashSetWithExpectedSize((int)endingStep.size());
                for (JsonElement element : endingStep) {
                    String s = element.getAsString();
                    Preconditions.checkArgument((boolean)recipe.pollens.contains(s), (Object)"Ending step must be in pollens");
                    recipe.endingStep.add(Util.trimRL((String)s));
                }
            }
        }

        public void fromNetwork(HybridizingRecipe recipe, class_2540 buf) {
            recipe.pollens = List.copyOf(buf.method_34066(class_2540::method_19772));
            recipe.endingStep = List.copyOf(buf.method_34066(class_2540::method_19772));
        }

        public void toNetwork0(class_2540 buf, HybridizingRecipe recipe) {
            buf.method_34062(recipe.pollens, class_2540::method_10814);
            buf.method_34062(recipe.endingStep, class_2540::method_10814);
        }
    }
}

