/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_176;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3956;
import net.minecraft.class_4466;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.FruitfulFun;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.HybridizingRecipe;
import snownee.fruits.block.FruitLeavesBlock;
import snownee.kiwi.util.Util;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class HybridizingRecipeType
extends BlockKeyRecipeType<LycheeContext, HybridizingRecipe> {
    public HybridizingRecipeType(String name, Class<HybridizingRecipe> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
    }

    public static void removeOverflownPollens(class_4466 bee) {
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        if (pollens.size() > 3) {
            int toRemove = pollens.size() - 3;
            while (toRemove-- > 0) {
                pollens.remove(0);
            }
        }
    }

    public void buildCache() {
        super.buildCache();
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        Stream<HybridizingRecipe> stream = CommonProxy.recipes((class_3956)this).stream().filter($ -> !$.ghost);
        if (this.clazz.isAssignableFrom(Comparable.class)) {
            stream = stream.sorted();
        }
        this.recipes = stream.toList();
        HashMultimap multimap = HashMultimap.create();
        LinkedHashSet pollenBlocks = new LinkedHashSet();
        for (HybridizingRecipe hybridizingRecipe : this.recipes) {
            hybridizingRecipe.endingStep().stream().map(class_2960::new).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).forEach(arg_0 -> HybridizingRecipeType.lambda$buildCache$1((Multimap)multimap, hybridizingRecipe, arg_0));
            hybridizingRecipe.pollens.stream().map(class_2960::new).map(arg_0 -> ((class_7922)class_7923.field_41175).method_10223(arg_0)).forEach(pollenBlocks::add);
        }
        for (Map.Entry entry : multimap.asMap().entrySet()) {
            ArrayList list = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            list.sort(null);
            this.recipesByBlock.put((class_2248)entry.getKey(), list);
        }
        for (class_2248 class_22482 : pollenBlocks) {
            if (class_22482 instanceof FruitLeavesBlock || class_22482.method_9564().method_26164(class_3481.field_20339)) continue;
            FruitfulFun.LOGGER.warn("Pollen {} does not have a flower block tag, this may cause issues", (Object)class_22482);
        }
    }

    public void onPollinateComplete(class_4466 bee) {
        Pair result;
        if (this.isEmpty()) {
            return;
        }
        class_2338 flowerPos = bee.method_21778();
        if (flowerPos == null) {
            return;
        }
        class_1937 level = bee.method_37908();
        class_2680 state = level.method_8320(flowerPos);
        if (state.method_26215()) {
            return;
        }
        class_2248 block = state.method_26204();
        String newPollen = Util.trimRL((class_2960)class_7923.field_41175.method_10221((Object)block));
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        pollens.remove(newPollen);
        pollens.add(newPollen);
        if (!this.has(state)) {
            return;
        }
        boolean isBigFlowerUpper = false;
        if (block instanceof class_2320 && state.method_28498((class_2769)class_2320.field_10929) && state.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609) {
            state = level.method_8320(flowerPos = flowerPos.method_10074());
            if (block != state.method_26204()) {
                return;
            }
            isBigFlowerUpper = true;
        }
        if ((result = this.process(bee.method_37908(), state, this.buildContext(bee, flowerPos, state))) != null) {
            level.method_20290(2005, flowerPos, 0);
            if (isBigFlowerUpper) {
                level.method_20290(2005, flowerPos.method_10084(), 0);
            }
            pollens.clear();
        }
    }

    public Supplier<LycheeContext> buildContext(class_4466 bee, class_2338 flowerPos, class_2680 state) {
        return () -> {
            LycheeContext.Builder builder = new LycheeContext.Builder(bee.method_37908());
            builder.withRandom(bee.method_6051());
            builder.withParameter(class_181.field_1226, (Object)bee);
            builder.withParameter(class_181.field_1224, (Object)state);
            builder.withParameter(class_181.field_24424, (Object)class_243.method_24955((class_2382)flowerPos));
            builder.withParameter(LycheeLootContextParams.BLOCK_POS, (Object)flowerPos);
            return builder.create(((HybridizingRecipeType)((Object)((Object)BeeModule.RECIPE_TYPE.get()))).contextParamSet);
        };
    }

    private static /* synthetic */ void lambda$buildCache$1(Multimap multimap, HybridizingRecipe recipe, class_2248 $) {
        multimap.put((Object)$, (Object)recipe);
    }
}

