/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_5819;
import snownee.fruits.Hooks;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;

public class GeneData {
    protected final Map<Allele, Locus> loci = Maps.newIdentityHashMap();
    protected final Set<Trait> traits = Sets.newIdentityHashSet();

    public void updateTraits() {
        this.traits.clear();
        if (this.allGene(Allele.RAINC, 1)) {
            this.traits.add(Trait.RAIN_CAPABLE);
        }
        if (this.allGene(Allele.FANCY, 1)) {
            this.traits.add(Trait.PINK);
        } else if (this.allGene(Allele.FANCY, 2)) {
            this.traits.add(Trait.WITHER_TOLERANT);
        }
        if (this.allGene(Allele.FEAT1, 1)) {
            this.traits.add(Trait.LAZY);
            this.traits.add(Trait.MILD);
        } else if (this.anyGene(Allele.FEAT1, 1)) {
            this.traits.add(Trait.MILD);
        }
        if (this.allGene(Allele.FEAT1, 2)) {
            this.traits.add(Trait.FASTER);
        } else if (this.anyGene(Allele.FEAT1, 2)) {
            this.traits.add(Trait.FAST);
        }
        if (this.anyGene(Allele.FEAT1, 2) && !this.hasTrait(Trait.MILD)) {
            this.traits.add(Trait.WARRIOR);
        } else if (this.allGene(Allele.FEAT2, 1)) {
            this.traits.add(Trait.ADVANCED_POLLINATION);
        }
        if (this.allGene(Allele.FEAT2, 2)) {
            this.traits.add(Trait.MOUNTABLE);
        }
    }

    public boolean hasTrait(Trait trait) {
        return Hooks.bee && this.traits.contains(trait);
    }

    public Locus getLocus(Allele allele) {
        return this.loci.computeIfAbsent(allele, Locus::new);
    }

    public boolean anyGene(Allele allele, int gene) {
        Locus locus = this.getLocus(allele);
        return locus.getHigh() == gene || locus.getLow() == gene;
    }

    public boolean allGene(Allele allele, int gene) {
        Locus locus = this.getLocus(allele);
        return locus.getHigh() == gene && locus.getLow() == gene;
    }

    public void randomize(class_5819 random) {
        for (Allele type : Allele.values()) {
            Locus locus = new Locus(type);
            locus.randomize(random);
            this.loci.put(type, locus);
        }
    }

    public Map<Allele, Locus> getLoci() {
        return this.loci;
    }

    public Set<Trait> getTraits() {
        return this.traits;
    }

    public void setTraits(List<Trait> list) {
        this.traits.clear();
        this.traits.addAll(list);
    }

    public void breedFrom(GeneData parent1, Allele allele1, GeneData parent2, Allele allele2, class_5819 random) {
        Iterator<Allele> iterator = Allele.values().iterator();
        while (iterator.hasNext()) {
            Allele allele;
            byte gene1 = parent1.pickAllele(allele, random, (allele = iterator.next()) == allele1);
            byte gene2 = parent2.pickAllele(allele, random, allele == allele2);
            Locus locus = new Locus(allele);
            locus.setData((byte)(gene1 << 4 | gene2));
            this.loci.put(allele, locus);
        }
    }

    protected byte pickAllele(Allele allele, class_5819 random, boolean highMutation) {
        Locus locus = this.getLocus(allele);
        int gene = random.method_43056() ? locus.getHigh() : locus.getLow();
        return allele.maybeMutate((byte)gene, random, highMutation);
    }

    public void toNBT(class_2487 lociTag) {
        for (Map.Entry<Allele, Locus> entry : this.loci.entrySet()) {
            lociTag.method_10567(entry.getKey().name, entry.getValue().getData());
        }
    }

    public void fromNBT(class_2487 lociTag) {
        this.loci.clear();
        for (Allele allele : Allele.REGISTRY.values()) {
            Locus locus = new Locus(allele);
            if (lociTag.method_10545(allele.name)) {
                locus.setData(lociTag.method_10571(allele.name));
            }
            this.loci.put(allele, locus);
        }
    }
}

