/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.genetics;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import snownee.fruits.bee.genetics.Allele;

public class GeneticSavedData
extends class_18 {
    private final Map<String, AlleleRecord> alleles = Maps.newHashMap();

    public class_2487 method_75(class_2487 compoundTag) {
        class_2487 alleleTag = new class_2487();
        for (Map.Entry<String, AlleleRecord> entry : this.alleles.entrySet()) {
            class_2487 recordTag = new class_2487();
            recordTag.method_10582("Code", entry.getValue().code);
            recordTag.method_10569("Index", entry.getValue().index);
            alleleTag.method_10566(entry.getKey(), (class_2520)recordTag);
        }
        compoundTag.method_10566("Alleles", (class_2520)alleleTag);
        return compoundTag;
    }

    public static GeneticSavedData load(class_2487 compoundTag) {
        GeneticSavedData data = new GeneticSavedData();
        class_2487 alleleTag = compoundTag.method_10562("Alleles");
        HashSet knownCodes = Sets.newHashSetWithExpectedSize((int)alleleTag.method_10546());
        for (String key : alleleTag.method_10541()) {
            class_2487 recordTag = alleleTag.method_10562(key);
            String code = recordTag.method_10558("Code");
            if (!knownCodes.add(code)) continue;
            data.alleles.put(key, new AlleleRecord(code, recordTag.method_10550("Index")));
        }
        data.method_80();
        return data;
    }

    public void initAlleles(long seed) {
        for (Allele allele : Allele.values()) {
            allele.codename = (char)48;
            allele.index = -1;
        }
        class_5819 random = class_5819.method_43049((long)seed);
        for (Allele allele : Allele.values()) {
            AlleleRecord alleleRecord = this.alleles.get(allele.name);
            if (alleleRecord != null) {
                allele.codename = alleleRecord.code.charAt(0);
                allele.index = alleleRecord.index;
                random.method_43048(26);
                random.method_43048(255);
            } else {
                int codename = random.method_43048(26);
                while (Allele.byCode((char)(65 + codename)) != null) {
                    codename = (codename + 1) % 26;
                }
                allele.codename = (char)(65 + codename);
                int index = random.method_43048(255);
                while (Allele.byIndex(index) != null) {
                    index = (index + 31) % 255;
                }
                allele.index = index;
                this.alleles.put(allele.name, new AlleleRecord(String.valueOf(allele.codename), allele.index));
                this.method_80();
            }
            allele.color = class_3532.method_15369((float)((float)allele.index / 254.0f), (float)0.86f, (float)0.86f);
        }
        Allele.BY_CODE = Allele.values().stream().sorted(Comparator.comparingInt(a -> a.codename)).toList();
    }

    public record AlleleRecord(String code, int index) {
    }
}

