/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.bee.network;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_4466;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.genetics.Trait;
import snownee.kiwi.network.KPacketTarget;
import snownee.kiwi.network.KiwiPacket;
import snownee.kiwi.network.PacketHandler;

@KiwiPacket(value="sync_bee", dir=KiwiPacket.Direction.PLAY_TO_CLIENT)
public class SSyncBeePacket
extends PacketHandler {
    public static SSyncBeePacket I;

    public CompletableFuture<class_2540> receive(Function<Runnable, CompletableFuture<class_2540>> executor, class_2540 buf, @Nullable class_3222 serverPlayer) {
        int id = buf.method_10816();
        class_1799 saddle = buf.method_10819();
        List trusted = buf.method_34066(class_2540::method_10790);
        String texture = buf.method_19772();
        List traits = buf.method_34066(class_2540::method_19772);
        long mutagenEndsIn = buf.readLong();
        return executor.apply(() -> {
            class_1297 entity = Objects.requireNonNull(class_310.method_1551().field_1687).method_8469(id);
            if (entity instanceof class_4466) {
                BeeAttributes attributes = BeeAttributes.of(entity);
                attributes.setSaddle(saddle);
                attributes.setTrusted(trusted);
                if (texture.isEmpty()) {
                    attributes.setTexture(null);
                } else {
                    attributes.setTexture(class_2960.method_12829((String)texture));
                }
                attributes.getGenes().setTraits(traits.stream().map(Trait.REGISTRY::get).filter(Objects::nonNull).toList());
                attributes.setMutagenEndsIn(mutagenEndsIn, entity.method_37908().method_8510());
            }
        });
    }

    public static void send(class_4466 bee) {
        I.send(KPacketTarget.tracking((class_1297)bee), SSyncBeePacket.putData(bee));
    }

    public static void send(class_4466 bee, class_3222 player) {
        I.send(player, SSyncBeePacket.putData(bee));
    }

    private static Consumer<class_2540> putData(class_4466 bee) {
        BeeAttributes attributes = BeeAttributes.of(bee);
        return buf -> {
            buf.method_10804(bee.method_5628());
            buf.method_10793(attributes.getSaddle());
            buf.method_34062(attributes.getTrusted(), class_2540::method_10797);
            class_2960 texture = attributes.getTexture();
            buf.method_10814(texture == null ? "" : texture.toString());
            buf.method_34062(attributes.getGenes().getTraits().stream().map(Trait::name).toList(), class_2540::method_10814);
            buf.writeLong(attributes.getMutagenEndsIn());
        };
    }
}

