/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.block;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1432;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4153;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.CoreModule;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.FruitType;
import snownee.fruits.block.entity.FruitTreeBlockEntity;
import snownee.fruits.util.CommonProxy;
import snownee.kiwi.KiwiModule;

@KiwiModule.RenderLayer(value=KiwiModule.RenderLayer.Layer.CUTOUT)
public class FruitLeavesBlock
extends class_2397
implements class_2256,
class_2343 {
    public static final class_2758 AGE = class_2741.field_12497;
    public final Supplier<FruitType> type;

    public FruitLeavesBlock(Supplier<FruitType> type, class_4970.class_2251 properties) {
        super(properties.method_26235(class_2246::method_26126).method_26243(class_2246::method_26122).method_26245(class_2246::method_26122).method_26236(class_2246::method_26122));
        this.type = type;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11199, (Comparable)Integer.valueOf(7))).method_11657((class_2769)field_11200, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1))).method_11657((class_2769)field_38227, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public static class_1542 dropFruit(class_3218 level, class_2338 pos, class_2680 state, @Nullable FruitTreeBlockEntity core, int consumeLifespan) {
        if ((Integer)state.method_11654((class_2769)AGE) != 3) {
            return null;
        }
        if (!level.method_8450().method_8355(class_1928.field_19392)) {
            return null;
        }
        boolean die = true;
        if (core != null) {
            core.consumeLifespan(consumeLifespan);
            die = core.isDead();
            if (die) {
                core.removeActiveLeaves(pos);
            }
        }
        state = (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(die ? 0 : 1));
        if (die && state.method_31709()) {
            state = (class_2680)state.method_11657((class_2769)field_11200, (Comparable)Boolean.valueOf(false));
        }
        level.method_8501(pos, state);
        class_1542 itemEntity = ((FruitLeavesBlock)state.method_26204()).doDropFruit(level, pos, state, core, consumeLifespan);
        if (itemEntity != null && !level.method_8649((class_1297)itemEntity)) {
            return null;
        }
        return itemEntity;
    }

    @Nullable
    public class_1542 doDropFruit(class_3218 level, class_2338 pos, class_2680 state, @Nullable FruitTreeBlockEntity core, int consumeLifespan) {
        return FruitLeavesBlock.createItemEntity(level, pos, this.type.get().fruit.get().method_7854());
    }

    public static class_1542 createItemEntity(class_3218 level, class_2338 pos, class_1799 stack) {
        float f = class_1299.field_6052.method_17686() / 2.0f;
        double d0 = (double)((float)pos.method_10263() + 0.5f) + class_3532.method_15366((class_5819)level.field_9229, (double)-0.25, (double)0.25);
        double d1 = (double)((float)pos.method_10264() + 0.5f) + class_3532.method_15366((class_5819)level.field_9229, (double)-0.25, (double)0.25) - (double)f;
        double d2 = (double)((float)pos.method_10260() + 0.5f) + class_3532.method_15366((class_5819)level.field_9229, (double)-0.25, (double)0.25);
        class_1542 itemEntity = new class_1542((class_1937)level, d0, d1, d2, stack);
        itemEntity.method_6988();
        return itemEntity;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11199, field_11200, AGE, field_38227});
    }

    public boolean method_9651(class_4538 worldIn, class_2338 pos, class_2680 state, boolean isClient) {
        if ((Integer)state.method_11654((class_2769)AGE) == 1) {
            return true;
        }
        return this.canGrow(state) && (Integer)state.method_11654((class_2769)AGE) < 3;
    }

    public boolean method_9650(class_1937 worldIn, class_5819 rand, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 world, class_5819 rand, class_2338 pos, class_2680 state) {
        world.method_8501(pos, (class_2680)state.method_28493((class_2769)AGE));
    }

    @Nullable
    public FruitTreeBlockEntity findCore(class_3218 level, class_2338 pos) {
        return level.method_19494().method_20006(this.type.get().poiType::equals, pos, 10, class_4153.class_4155.field_18489).flatMap(core -> level.method_35230(core, (class_2591)CoreModule.FRUIT_TREE.get())).orElse(null);
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
        if (this.shouldDecay(state)) {
            FruitLeavesBlock.method_9497((class_2680)state, (class_1937)world, (class_2338)pos);
            world.method_8650(pos, false);
        } else if (this.canGrow(state) && world.method_22339(pos.method_10084()) >= 9) {
            if (this.hasFruit(state, (class_1937)world, pos)) {
                FFCommonConfig.DropMode mode = FFCommonConfig.getDropMode((class_1936)world);
                if (mode == FFCommonConfig.DropMode.NoDrop) {
                    return;
                }
                FruitTreeBlockEntity core = this.findCore(world, pos);
                if (mode == FFCommonConfig.DropMode.OneByOne && core != null && !core.canDrop()) {
                    return;
                }
                class_1542 itemEntity = FruitLeavesBlock.dropFruit(world, pos, state, core, 1);
                if (mode == FFCommonConfig.DropMode.OneByOne && core != null && itemEntity != null) {
                    core.setOnlyItem(itemEntity);
                }
            } else {
                boolean def = rand.method_43048(100) > 99 - FFCommonConfig.treeGrowingSpeed;
                CommonProxy.maybeGrowCrops(world, pos, state, def, () -> this.method_9652(world, rand, pos, state));
            }
        }
    }

    public boolean hasFruit(class_2680 state, class_1937 level, class_2338 pos) {
        return (Integer)state.method_11654((class_2769)AGE) == 3;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 rand) {
        if (((Boolean)(state = FruitLeavesBlock.method_10300((class_2680)state, (class_1936)world, (class_2338)pos)).method_11654((class_2769)field_11200)).booleanValue() && (Integer)state.method_11654((class_2769)field_11199) != 1) {
            state = (class_2680)state.method_11657((class_2769)field_11200, (Comparable)Boolean.valueOf(false));
        }
        world.method_8501(pos, state);
    }

    public boolean method_9542(class_2680 state) {
        return this.notPlacedByPlayer(state);
    }

    public boolean notPlacedByPlayer(class_2680 state) {
        return this.shouldDecay(state) || this.canGrow(state) || (Integer)state.method_11654((class_2769)AGE) == 0;
    }

    public boolean shouldDecay(class_2680 state) {
        return (Integer)state.method_11654((class_2769)field_11199) == 7 && (Boolean)state.method_11654((class_2769)field_11200) == false;
    }

    public boolean canGrow(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) > 0 && ((Boolean)state.method_11654((class_2769)field_11200) == false || (Integer)state.method_11654((class_2769)field_11199) == 1);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 facingState, class_1936 worldIn, class_2338 currentPos, class_2338 facingPos) {
        if (this.canGrow(state) || (Integer)state.method_11654((class_2769)AGE) == 0) {
            return super.method_9559(state, facing, facingState, worldIn, currentPos, facingPos);
        }
        return state;
    }

    public class_2680 method_9605(class_1750 context) {
        class_3610 fluidstate = context.method_8045().method_8316(context.method_8037());
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11200, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)field_38227, (Comparable)Boolean.valueOf(fluidstate.method_15772() == class_3612.field_15910));
    }

    public class_265 method_9549(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        class_1297 entity;
        class_3727 c;
        if (context instanceof class_3727 && (c = (class_3727)context).method_32480() != null && ((entity = c.method_32480()) instanceof class_1542 || entity instanceof class_1432)) {
            return class_259.method_1073();
        }
        return class_259.method_1077();
    }

    public void method_9554(class_1937 worldIn, class_2680 stateIn, class_2338 pos, class_1297 entityIn, float fallDistance) {
        super.method_9554(worldIn, stateIn, pos, entityIn, fallDistance);
        if (fallDistance >= 1.0f && worldIn instanceof class_3218) {
            class_3218 serverLevel = (class_3218)worldIn;
            if (entityIn instanceof class_1309 || entityIn instanceof class_1540) {
                Iterable posList = class_2338.method_10097((class_2338)pos.method_10069(-1, -2, -1), (class_2338)pos.method_10069(1, 0, 1));
                MutableBoolean success = new MutableBoolean(false);
                FruitLeavesBlock.rangeDrop(serverLevel, posList, 2, null, itemEntity -> success.setTrue());
                if (success.booleanValue()) {
                    // empty if block
                }
            }
        }
    }

    public static void rangeDrop(class_3218 level, Iterable<class_2338> posList, int consumeLifespan, @Nullable FruitTreeBlockEntity core, @Nullable Consumer<class_1542> consumer) {
        for (class_2338 blockpos : posList) {
            class_2680 state = level.method_8320(blockpos);
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof FruitLeavesBlock)) continue;
            FruitLeavesBlock leavesBlock = (FruitLeavesBlock)class_22482;
            if ((Integer)state.method_11654((class_2769)AGE) != 3) continue;
            class_1542 itemEntity = FruitLeavesBlock.dropFruit(level, blockpos, state, core == null ? leavesBlock.findCore(level, blockpos) : core, consumeLifespan);
            if (consumer == null || itemEntity == null) continue;
            consumer.accept(itemEntity);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 playerIn, class_1268 hand, class_3965 ray) {
        if (this.hasFruit(state, worldIn, pos) && worldIn.method_8501(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(1)))) {
            FruitLeavesBlock.giveItemTo(playerIn, ray, this.type.get().fruit.get().method_7854());
            return class_1269.method_29236((boolean)worldIn.field_9236);
        }
        return class_1269.field_5811;
    }

    public static void giveItemTo(class_1657 player, class_3965 hit, class_1799 stack) {
        class_1937 level = player.method_37908();
        if (level.field_9236) {
            return;
        }
        if (!CommonProxy.isFakePlayer((class_1297)player) && player.method_7270(stack)) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15197, player.method_5634(), 0.2f, ((player.method_6051().method_43057() - player.method_6051().method_43057()) * 0.7f + 1.0f) * 2.0f);
        } else {
            FruitLeavesBlock.method_36992((class_1937)level, (class_2338)hit.method_17777(), (class_2350)hit.method_17780(), (class_1799)stack);
        }
    }

    public boolean hasBlockEntity(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)field_11200) != false && (Integer)state.method_11654((class_2769)field_11199) == 1;
    }

    public class_2586 method_10123(class_2338 pPos, class_2680 state) {
        if (this.hasBlockEntity(state)) {
            return new FruitTreeBlockEntity(pPos, state, this.type.get());
        }
        return null;
    }
}

