/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.client.particle;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2769;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_4184;
import net.minecraft.class_4588;
import net.minecraft.class_5329;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PetalParticle
extends class_4003 {
    private final float rollStepX;
    private final float rollStepZ;
    private float rollX;
    private float oRollX;
    private boolean inWater;
    private final float particleRandom;
    private int sinceNotInWater;

    private PetalParticle(class_638 world, double posX, double posY, double posZ) {
        super(world, posX, posY, posZ);
        this.field_3847 = 300;
        this.particleRandom = this.field_3840.method_43057();
        this.field_3866 = this.field_3840.method_43048(20);
        this.field_17867 = 0.75f + this.field_3840.method_43057() * 0.25f;
        this.field_3841 = 0.7f + this.field_3840.method_43057() * 0.3f;
        this.field_3844 = 7.5E-4f;
        float baseMotionX = 0.5f + this.field_3840.method_43057() * 0.2f;
        float baseMotionY = -0.75f;
        float baseMotionZ = 0.5f + this.field_3840.method_43057() * 0.2f;
        if (this.field_3840.method_43057() < 0.2f) {
            float f = this.field_3840.method_43057() * ((float)Math.PI * 2);
            baseMotionX += class_3532.method_15374((float)f) * 0.3f;
            baseMotionZ += class_3532.method_15362((float)f) * 0.3f;
        }
        Vector3f motion = new Vector3f(baseMotionX, baseMotionY, baseMotionZ);
        motion.normalize().mul(0.03f + this.field_3840.method_43057() * 0.005f);
        this.field_3852 = motion.x();
        this.field_3869 = motion.y();
        this.field_3850 = motion.z();
        if (this.field_3840.method_43057() < 0.2f) {
            this.field_3869 -= (double)(this.field_3840.method_43057() * 0.02f);
        }
        this.rollStepX = 0.1f + this.field_3840.method_43057() * 0.1f * (float)(this.field_3840.method_43056() ? 1 : -1);
        this.rollStepZ = 0.1f + this.field_3840.method_43057() * 0.1f * (float)(this.field_3840.method_43056() ? 1 : -1);
        this.field_3842 = this.field_3859 = this.field_3840.method_43057() * 0.3f + 0.7f;
        this.field_3861 = this.field_3859;
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    public float method_18132(float pTicks) {
        if (this.field_3847 - this.field_3866 < 10) {
            float f = class_3532.method_15374((float)((float)((double)(((float)(this.field_3847 - this.field_3866) - pTicks) / 20.0f) * Math.PI)));
            return class_3532.method_15363((float)f, (float)0.0f, (float)1.0f);
        }
        return 1.0f;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        this.field_3857 = this.field_3839;
        this.oRollX = this.rollX;
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
            return;
        }
        boolean lastOnGround = this.field_3845;
        if (!this.field_3845 && !this.inWater) {
            double time = (double)this.field_3866 * (0.1 + (double)this.particleRandom * 0.03);
            double e = Math.sin(time) * 0.0025;
            this.field_3869 -= e;
            if (this.field_3869 > 0.0) {
                this.field_3869 = 0.0;
                this.field_3852 += Math.sin(this.particleRandom * ((float)Math.PI * 2)) * 5.0E-4;
                this.field_3850 += Math.cos(this.particleRandom * ((float)Math.PI * 2)) * 5.0E-4;
            }
            time = (double)(this.field_3866 + 3) * (0.1 + (double)this.particleRandom * 0.03);
            double d = Math.sin(time) * 0.0025;
            this.field_3852 += d;
            this.field_3850 += d;
            this.field_3839 += this.rollStepZ;
            this.rollX += this.rollStepX;
        }
        if (this.sinceNotInWater > 0) {
            ++this.sinceNotInWater;
        }
        this.method_3069(this.field_3852, this.field_3869, this.field_3850);
        if (this.field_3845) {
            if (!lastOnGround) {
                this.field_3866 = this.field_3847 - 20;
            }
            this.field_3852 *= 0.5;
            this.field_3850 *= 0.5;
        } else if (this.inWater) {
            this.field_3852 *= 0.66;
            this.field_3850 *= 0.66;
        } else {
            if (lastOnGround) {
                this.field_3866 = this.field_3847 - 60;
            }
            this.field_3869 *= 0.998;
            if (Math.abs(this.field_3852) > 0.3) {
                this.field_3852 *= 0.85;
            }
            if (Math.abs(this.field_3869) > 0.3) {
                this.field_3869 *= 0.85;
            }
            if (Math.abs(this.field_3850) > 0.3) {
                this.field_3850 *= 0.85;
            }
        }
    }

    public void method_3069(double pX, double pY, double pZ) {
        class_2338 pos = class_2338.method_49637((double)(this.field_3874 + pX), (double)(this.field_3854 + pY), (double)(this.field_3871 + pZ));
        class_3610 fluidState = this.field_3851.method_8316(pos);
        float waterHeight = fluidState.method_15763((class_1922)this.field_3851, pos) + (float)pos.method_10264();
        boolean oInWater = this.inWater;
        boolean bl = this.inWater = (oInWater || this.field_3854 <= (double)waterHeight) && fluidState.method_15767(class_3486.field_15517);
        if (this.inWater) {
            this.sinceNotInWater = 0;
            class_243 flow = fluidState.method_15758((class_1922)this.field_3851, pos);
            pX = flow.field_1352 * 0.05;
            pY = flow.field_1351 * 0.05 - 0.05;
            pZ = flow.field_1350 * 0.05;
        } else if (oInWater) {
            this.sinceNotInWater = 1;
        }
        double lastX = pX;
        double lastY = pY;
        double lastZ = pZ;
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            class_243 moveVec = PetalParticle.collideBoundingBox(new class_243(pX, pY, pZ), this.method_3064(), (class_1937)this.field_3851);
            pX = moveVec.field_1352;
            pY = moveVec.field_1351;
            pZ = moveVec.field_1350;
        }
        if (pX != 0.0 || pY != 0.0 || pZ != 0.0) {
            if (this.inWater) {
                pY = (double)this.accurateWaterHeight(pos, waterHeight) - this.field_3854;
            }
            this.method_3067(this.method_3064().method_989(pX, pY, pZ));
            this.method_3072();
        }
        if (Math.abs(lastY) >= (double)1.0E-5f && Math.abs(pY) < (double)1.0E-5f) {
            this.field_21507 = true;
        }
        if (!this.inWater) {
            boolean bl2 = this.field_3845 = lastY != pY && lastY < 0.0;
            if (lastX != pX) {
                this.field_3852 *= -0.5;
            }
            if (lastZ != pZ) {
                this.field_3850 *= -0.5;
            }
        }
    }

    private float accurateWaterHeight(class_2338 pos, float waterHeight) {
        if (((Boolean)this.field_3851.method_8316(pos).method_11654((class_2769)class_3609.field_15902)).booleanValue()) {
            waterHeight = pos.method_10264();
        }
        float highest = waterHeight;
        class_2350 highestSide = null;
        for (class_2350 side : class_2350.class_2353.field_11062) {
            class_2338 sidePos = pos.method_10093(side);
            float sideHeight = this.getWaterHeight(sidePos, waterHeight);
            if (!(sideHeight > highest)) continue;
            highest = sideHeight;
            highestSide = side;
        }
        if (highestSide != null) {
            float ratio;
            float f = ratio = highestSide.method_10166() == class_2350.class_2351.field_11048 ? (float)(this.field_3874 - (double)pos.method_10263()) : (float)(this.field_3871 - (double)pos.method_10260());
            if (highestSide.method_10171() == class_2350.class_2352.field_11060) {
                ratio = 1.0f - ratio;
            }
            return class_3532.method_16439((float)ratio, (float)waterHeight, (float)highest);
        }
        return waterHeight;
    }

    private float getWaterHeight(class_2338 pos, float waterHeight) {
        class_3610 fluidState = this.field_3851.method_8316(pos);
        if (fluidState.method_15767(class_3486.field_15517)) {
            return fluidState.method_15763((class_1922)this.field_3851, pos) + (float)pos.method_10264();
        }
        return waterHeight;
    }

    public static class_243 collideBoundingBox(class_243 vec3, class_238 aABB, class_1937 level) {
        class_5329 iterator = new class_5329((class_1941)level, null, aABB.method_18804(vec3), true, (mutableBlockPos, voxelShape) -> voxelShape);
        return class_1297.method_20737((class_243)vec3, (class_238)aABB, (List)ImmutableList.copyOf((Iterator)iterator));
    }

    public void method_3074(class_4588 buffer, class_4184 camera, float partialTicks) {
        Quaternionf quaternion;
        class_243 vec3d = camera.method_19326();
        float f = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3858, (double)this.field_3874) - vec3d.method_10216());
        float f1 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3838, (double)this.field_3854) - vec3d.method_10214());
        float f2 = (float)(class_3532.method_16436((double)partialTicks, (double)this.field_3856, (double)this.field_3871) - vec3d.method_10215());
        Vector3f sub = new Vector3f(f, f1, f2);
        float rollZ = class_3532.method_16439((float)partialTicks, (float)this.field_3857, (float)this.field_3839);
        if (this.field_3845 || this.inWater || this.sinceNotInWater > 0 && this.sinceNotInWater < 5) {
            quaternion = class_7833.field_40714.rotationDegrees(90.0f);
            f1 += 0.005f + rollZ % 0.01f;
        } else {
            quaternion = new Quaternionf();
            float rollX = class_3532.method_16439((float)partialTicks, (float)this.oRollX, (float)this.rollX);
            quaternion.rotateX(rollX);
            quaternion.rotateY(rollX * 0.2f);
        }
        quaternion.rotateZ(rollZ);
        Vector3f quadNormal = new Vector3f(0.0f, 0.0f, 1.0f);
        quadNormal.rotate((Quaternionfc)quaternion);
        Vector3f[] vertex = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float[] uv = new float[]{this.method_18133(), this.method_18135(), this.method_18134(), this.method_18136()};
        if (sub.dot((Vector3fc)quadNormal) < 0.0f) {
            for (int i = 0; i < 4; ++i) {
                vertex[i].mul(-1.0f, 1.0f, 1.0f);
            }
            uv[0] = this.method_18134();
            uv[2] = this.method_18133();
        }
        float f4 = this.method_18132(partialTicks);
        float alpha = f4 * this.field_3841;
        f4 *= this.field_17867 * 0.15f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vertex[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        int j = this.method_3068(partialTicks);
        buffer.method_22912((double)vertex[0].x(), (double)vertex[0].y(), (double)vertex[0].z()).method_22913(uv[2], uv[3]).method_22915(this.field_3861, this.field_3842, this.field_3859, alpha).method_22916(j).method_1344();
        buffer.method_22912((double)vertex[1].x(), (double)vertex[1].y(), (double)vertex[1].z()).method_22913(uv[2], uv[1]).method_22915(this.field_3861, this.field_3842, this.field_3859, alpha).method_22916(j).method_1344();
        buffer.method_22912((double)vertex[2].x(), (double)vertex[2].y(), (double)vertex[2].z()).method_22913(uv[0], uv[1]).method_22915(this.field_3861, this.field_3842, this.field_3859, alpha).method_22916(j).method_1344();
        buffer.method_22912((double)vertex[3].x(), (double)vertex[3].y(), (double)vertex[3].z()).method_22913(uv[0], uv[3]).method_22915(this.field_3861, this.field_3842, this.field_3859, alpha).method_22916(j).method_1344();
    }

    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public Factory(class_4002 sprite) {
            this.spriteSet = sprite;
        }

        public class_703 createParticle(class_2400 typeIn, class_638 worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            PetalParticle particle = new PetalParticle(worldIn, x, y, z);
            particle.method_18140(this.spriteSet);
            particle.field_3852 += xSpeed;
            particle.field_3869 += ySpeed;
            particle.field_3850 += zSpeed;
            if (Math.abs(xSpeed) > 0.5 || Math.abs(ySpeed) > 0.5 || Math.abs(zSpeed) > 0.5) {
                particle.field_3847 = 60;
            }
            return particle;
        }
    }
}

