/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.compat.jade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4466;
import snownee.fruits.FruitType;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.InspectorClientHandler;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.genetics.Locus;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.compat.jade.JadeCompat;
import snownee.fruits.duck.FFPlayer;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.ScaledTextElement;

public class InspectorProvider
implements IEntityComponentProvider,
IBlockComponentProvider,
IServerDataProvider<EntityAccessor> {
    public static void appendServerData(Accessor<?> accessor, class_4466 bee) {
        class_2499 list;
        Set<Trait> traits;
        if (!BeeModule.INSPECTOR.is(accessor.getPlayer().method_6030())) {
            return;
        }
        class_2487 data = accessor.getServerData();
        BeeAttributes attributes = BeeAttributes.of(bee);
        List<String> pollens = attributes.getPollens();
        if (!pollens.isEmpty()) {
            class_2499 list2 = new class_2499();
            for (String pollen : pollens) {
                list2.add((Object)class_2519.method_23256((String)pollen));
            }
            data.method_10566("Pollens", (class_2520)list2);
        }
        if (!(traits = attributes.getGenes().getTraits()).isEmpty()) {
            list = new class_2499();
            for (Trait trait : traits) {
                list.add((Object)class_2519.method_23256((String)trait.name()));
            }
            data.method_10566("Traits", (class_2520)list);
        }
        list = new class_2499();
        for (Allele allele : Allele.sortedByCode()) {
            class_2487 tag = new class_2487();
            Locus locus = attributes.getLocus(allele);
            tag.method_10582("Code", String.valueOf(allele.codename));
            tag.method_10569("High", locus.getHigh());
            tag.method_10569("Low", locus.getLow());
            list.add((Object)tag);
        }
        data.method_10566("Loci", (class_2520)list);
    }

    public static void appendTooltip(ITooltip tooltip, Accessor<?> accessor) {
        class_2487 data = accessor.getServerData();
        if (InspectorClientHandler.isAnalyzing()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tip.fruitfulfun.analyzing"));
            IElementHelper elements = IElementHelper.get();
            IElement icon = elements.smallItem(class_1802.field_20414.method_7854()).message(null);
            int i = InspectorClientHandler.getHoverTicks() / 4 % 3;
            tooltip.append(elements.spacer(2 + i * (int)icon.getCachedSize().field_1343, (int)icon.getCachedSize().field_1342));
            tooltip.append(icon);
            tooltip.append(elements.spacer((2 - i) * (int)icon.getCachedSize().field_1343, (int)icon.getCachedSize().field_1342));
            return;
        }
        if (!data.method_10545("Loci")) {
            return;
        }
        tooltip.remove(Identifiers.MC_ENTITY_HEALTH);
        tooltip.remove(Identifiers.MC_ENTITY_ARMOR);
        switch (InspectorClientHandler.getPageNow()) {
            case 0: {
                InspectorProvider.showPollens(tooltip, data);
                break;
            }
            case 1: {
                InspectorProvider.showTraits(tooltip, data);
                break;
            }
            case 2: {
                InspectorProvider.showGenes(tooltip, data, FFPlayer.of(accessor.getPlayer()));
            }
        }
        tooltip.add((IElement)new ScaledTextElement((class_2561)class_2561.method_43471((String)"tip.fruitfulfun.pressAlt").method_27692(IThemeHelper.get().isLightColorScheme() ? class_124.field_1080 : class_124.field_1063), 0.75f));
    }

    public static void showPollens(ITooltip tooltip, class_2487 data) {
        class_2499 pollens = data.method_10554("Pollens", 8);
        InspectorProvider.title(tooltip, "text.fruitfulfun.pollen");
        if (pollens.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.fruitfulfun.pollen.none"));
        } else {
            ArrayList elements = Lists.newArrayList();
            for (class_2520 tag : pollens) {
                elements.add(IElementHelper.get().item(FruitType.getFruitOrDefault(tag.method_10714()).method_7854()));
            }
            tooltip.add((List)elements);
        }
    }

    public static void showTraits(ITooltip tooltip, class_2487 data) {
        class_2499 traits = data.method_10554("Traits", 8);
        InspectorProvider.title(tooltip, "text.fruitfulfun.trait");
        if (traits.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.fruitfulfun.trait.none"));
        } else {
            ArrayList strings = Lists.newArrayList();
            for (class_2520 tag : traits) {
                Trait trait = Trait.REGISTRY.get(tag.method_10714());
                if (trait == null) continue;
                strings.add(trait.getDisplayName().getString());
            }
            tooltip.add((class_2561)class_2561.method_43470((String)String.join((CharSequence)"/", strings)));
        }
    }

    public static void showGenes(ITooltip tooltip, class_2487 data, FFPlayer player) {
        InspectorProvider.title(tooltip, "text.fruitfulfun.gene");
        class_2499 loci = data.method_10554("Loci", 10);
        if (loci.isEmpty()) {
            return;
        }
        for (class_2520 e : loci) {
            class_2487 tag = (class_2487)e;
            String code = tag.method_10558("Code");
            String name = player.fruits$getGeneName(code);
            String desc = player.fruits$getGeneDesc(code);
            String high = name + (tag.method_10550("High") + 1);
            String low = name + (tag.method_10550("Low") + 1);
            if (desc.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43469((String)"text.fruitfulfun.gene.pair", (Object[])new Object[]{high, low}));
                continue;
            }
            tooltip.add((class_2561)class_2561.method_43469((String)"text.fruitfulfun.gene.pairWithDesc", (Object[])new Object[]{desc, high, low}));
        }
    }

    public static void title(ITooltip tooltip, String key) {
        tooltip.add((IElement)new ScaledTextElement((class_2561)class_2561.method_43471((String)key), 0.75f));
        tooltip.add(IElementHelper.get().spacer(2, 2));
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        InspectorProvider.appendTooltip(tooltip, accessor);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        InspectorProvider.appendTooltip(tooltip, accessor);
    }

    public void appendServerData(class_2487 data, EntityAccessor accessor) {
        InspectorProvider.appendServerData(accessor, (class_4466)accessor.getEntity());
    }

    public class_2960 getUid() {
        return JadeCompat.INSPECTOR;
    }

    public int getDefaultPriority() {
        return 5001;
    }

    public boolean isRequired() {
        return true;
    }
}

