/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin.bee;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_4482;
import net.minecraft.class_5575;
import net.minecraft.class_8113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.fruits.bee.BeeAttributes;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.Trait;
import snownee.fruits.duck.FFBee;
import snownee.fruits.duck.FFBeehiveBlockEntity;

@Mixin(value={class_4482.class})
public class BeehiveBlockEntityMixin
extends class_2586
implements FFBeehiveBlockEntity {
    @Unique
    private int waxedTicks;

    public BeehiveBlockEntityMixin(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @WrapOperation(method={"releaseOccupant"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isRaining()Z")})
    private static boolean releaseOccupantSuppressDefault(class_1937 instance, Operation<Boolean> original, @Local(argsOnly=true) class_4482.class_4483 beeData) {
        return (Boolean)original.call(new Object[]{instance}) != false && !beeData.field_20425.method_10577("RainCapable");
    }

    @WrapOperation(method={"addOccupantWithPresetTicks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity;storeBee(Lnet/minecraft/nbt/CompoundTag;IZ)V")})
    private void addOccupantWithPresetTicks(class_4482 instance, class_2487 compoundTag, int i, boolean bl, Operation<Void> original, @Local(argsOnly=true) class_1297 entity) {
        if (entity instanceof FFBee && BeeAttributes.of(entity).hasTrait(Trait.RAIN_CAPABLE)) {
            compoundTag.method_10556("RainCapable", true);
        }
        original.call(new Object[]{instance, compoundTag, i, bl});
    }

    @Inject(method={"serverTick"}, at={@At(value="HEAD")})
    private static void serverTick(class_1937 level, class_2338 blockPos, class_2680 blockState, @NotNull class_4482 beehiveBlockEntity, CallbackInfo ci) {
        BeehiveBlockEntityMixin self = (BeehiveBlockEntityMixin)beehiveBlockEntity;
        if (self.waxedTicks > 0) {
            --self.waxedTicks;
        }
    }

    @WrapOperation(method={"serverTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BeehiveBlockEntity;tickOccupants(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Ljava/util/List;Lnet/minecraft/core/BlockPos;)V")})
    private static void serverTick_tickOccupants(class_1937 level, class_2338 blockPos, class_2680 blockState, List<class_4482.class_4483> list, @Nullable class_2338 blockPos2, Operation<Void> original, @Local(argsOnly=true) @NotNull class_4482 beehive) {
        FFBeehiveBlockEntity self = (FFBeehiveBlockEntity)beehive;
        if (!self.fruits$isWaxed()) {
            original.call(new Object[]{level, blockPos, blockState, list, blockPos2});
        }
    }

    @WrapOperation(method={"serverTick"}, at={@At(value="INVOKE", target="Ljava/util/List;isEmpty()Z")})
    private static boolean serverTick_playWorkingSound(List<class_4482.class_4483> list, Operation<Boolean> original, @Local(argsOnly=true) @NotNull class_4482 beehive) {
        FFBeehiveBlockEntity self = (FFBeehiveBlockEntity)beehive;
        if (!self.fruits$isWaxed()) {
            return (Boolean)original.call(new Object[]{list});
        }
        return true;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void load(class_2487 compoundTag, CallbackInfo ci) {
        this.waxedTicks = compoundTag.method_10550("FruitfulFun:WaxedTicks");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveAdditional(class_2487 compoundTag, CallbackInfo ci) {
        if (this.fruits$isWaxed()) {
            compoundTag.method_10569("FruitfulFun:WaxedTicks", this.waxedTicks);
        }
    }

    @Override
    public boolean fruits$isWaxed() {
        if (this.waxedTicks > 0) {
            return true;
        }
        if (Objects.requireNonNull(this.field_11863).field_9236) {
            return !this.fruits$findWaxedMarkers().isEmpty();
        }
        return false;
    }

    @Override
    public void fruits$setWaxed(boolean waxed) {
        this.waxedTicks = waxed ? 1200 : 0;
        Objects.requireNonNull(this.field_11863);
        if (waxed) {
            class_8113.class_8115 display = Objects.requireNonNull((class_8113.class_8115)class_1299.field_42460.method_5883(this.field_11863));
            display.method_33574(class_243.method_24953((class_2382)this.method_11016()));
            display.method_5665((class_2561)class_2561.method_43470((String)"@FruitfulFunWaxed"));
            this.field_11863.method_8649((class_1297)display);
        } else {
            this.fruits$findWaxedMarkers().forEach(class_1297::method_31472);
        }
    }

    @Override
    public List<class_8113.class_8115> fruits$findWaxedMarkers() {
        return Objects.requireNonNull(this.field_11863).method_18023((class_5575)class_1299.field_42460, new class_238(this.method_11016()), BeeModule::isWaxedMarker);
    }
}

