/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.mixin.gene_data;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.bee.genetics.Allele;
import snownee.fruits.bee.network.SSyncPlayerPacket;
import snownee.fruits.duck.FFPlayer;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
implements FFPlayer {
    @Unique
    private Map<String, FFPlayer.GeneName> geneNames = Map.of();

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void addAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        if (!this.geneNames.isEmpty()) {
            class_2499 list = new class_2499();
            for (Map.Entry<String, FFPlayer.GeneName> entry : this.geneNames.entrySet()) {
                class_2499 nameTag = new class_2499();
                nameTag.add((Object)class_2519.method_23256((String)entry.getKey()));
                nameTag.add((Object)class_2519.method_23256((String)entry.getValue().name()));
                nameTag.add((Object)class_2519.method_23256((String)entry.getValue().desc()));
                list.add((Object)nameTag);
            }
            compoundTag.method_10566("FruitfulFun:GeneNames", (class_2520)list);
            compoundTag.method_10582("FruitfulFun:GeneticsDifficulty", FFCommonConfig.geneticsDifficulty.name());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        String code;
        if (compoundTag.method_10545("FruitfulFun:GeneNames")) {
            for (class_2520 e : compoundTag.method_10554("FruitfulFun:GeneNames", 9)) {
                class_2499 nameTag = (class_2499)e;
                code = nameTag.method_10608(0);
                String name = nameTag.method_10608(1);
                String desc = nameTag.method_10608(2);
                this.fruits$setGeneName(code, new FFPlayer.GeneName(name, desc));
            }
        }
        if (FFCommonConfig.geneticsDifficulty == FFCommonConfig.GeneticsDifficulty.Easy) {
            FFCommonConfig.GeneticsDifficulty difficulty = null;
            if (compoundTag.method_10545("FruitfulFun:GeneticsDifficulty")) {
                try {
                    difficulty = FFCommonConfig.GeneticsDifficulty.valueOf(compoundTag.method_10558("FruitfulFun:GeneticsDifficulty"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (difficulty != FFCommonConfig.geneticsDifficulty) {
                for (Allele allele : Allele.sortedByCode()) {
                    code = String.valueOf(allele.codename);
                    FFPlayer.GeneName geneName = this.geneNames.get(code);
                    if (geneName == null || !geneName.name().equals(code)) continue;
                    this.fruits$setGeneName(code, new FFPlayer.GeneName(allele.name, ""));
                }
            }
        }
    }

    @Override
    public String fruits$getGeneName(String code) {
        if (this.geneNames.containsKey(code)) {
            return this.geneNames.get(code).name();
        }
        return code;
    }

    @Override
    public String fruits$getGeneDesc(String code) {
        if (this.geneNames.containsKey(code)) {
            return this.geneNames.get(code).desc();
        }
        return "";
    }

    @Override
    public void fruits$setGeneName(String code, FFPlayer.GeneName name) {
        if (this.geneNames.isEmpty()) {
            this.geneNames = Maps.newHashMapWithExpectedSize((int)Allele.values().size());
        }
        this.geneNames.put(code, name);
    }

    @Override
    public Map<String, FFPlayer.GeneName> fruits$getGeneNames() {
        return this.geneNames;
    }

    @Override
    public void fruits$setGeneNames(Map<String, FFPlayer.GeneName> geneNames) {
        if (geneNames.isEmpty()) {
            this.geneNames = Map.of();
        } else {
            this.geneNames = Maps.newHashMapWithExpectedSize((int)geneNames.size());
            this.geneNames.putAll(geneNames);
        }
    }

    @Override
    public void fruits$maybeInitGenes() {
        boolean changed = false;
        for (Allele allele : Allele.sortedByCode()) {
            String code = String.valueOf(allele.codename);
            if (this.geneNames.containsKey(code)) continue;
            if (FFCommonConfig.geneticsDifficulty == FFCommonConfig.GeneticsDifficulty.Easy) {
                this.fruits$setGeneName(code, new FFPlayer.GeneName(allele.name, ""));
            } else {
                this.fruits$setGeneName(code, new FFPlayer.GeneName(code, ""));
            }
            changed = true;
        }
        if (changed) {
            SSyncPlayerPacket.send((class_3222)this);
        }
    }
}

