/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.ritual;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2484;
import net.minecraft.class_2549;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2631;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2697;
import net.minecraft.class_2700;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5575;
import net.minecraft.class_8150;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.food.FoodModule;
import snownee.fruits.food.PieBlock;
import snownee.fruits.util.CommonProxy;
import snownee.fruits.vacuum.VacModule;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;

@KiwiModule(value="ritual")
@KiwiModule.Optional
public class RitualModule
extends AbstractModule {
    public static final KiwiGO<class_3414> RITUAL_FINISH = RitualModule.go(() -> class_3414.method_47908((class_2960)new class_2960("fruitfulfun", "block.ritual.finish")));
    public static final Supplier<class_2700> RITUAL = Suppliers.memoize(() -> class_2697.method_11701().method_11702(new String[]{" C C ", "C~~~C", " ~ ~ ", "C~~~C", " C C "}).method_11702(new String[]{"C~~~C", "~~~~~", "~~~~~", "~~~~~", "C~~~C"}).method_11700('C', class_2694.method_11678(CommonProxy::isLitCandle)).method_11700('~', class_2694.method_11678(class_4970.class_4971::method_26215)).method_11704());
    public static final UUID DUMMY_UUID = UUID.fromString("46fee2cc-dbea-4a2f-9768-afb958387795");
    public static final String INTERACTION_NAME = "@FruitfulFun";
    public static final int LIFETIME = 100;

    public RitualModule() {
        Hooks.ritual = true;
    }

    public static void tryStartRitual(class_1937 level, class_2338 pos, class_2680 pieState) {
        if (!level.method_18023((class_5575)class_1299.field_42623, new class_238(pos), RitualModule::isFFInteractionEntity).isEmpty()) {
            return;
        }
        List<class_2338> heads = RitualModule.findRitual(level, pos, pieState);
        if (heads.isEmpty()) {
            return;
        }
        for (class_2338 head : heads) {
            level.method_8396(null, head, class_3417.field_15024, class_3419.field_15256, 1.0f, 1.0f);
        }
        class_8150 interaction = Objects.requireNonNull((class_8150)class_1299.field_42623.method_5883(level));
        interaction.method_33574(class_243.method_24953((class_2382)pos));
        interaction.method_5665((class_2561)class_2561.method_43470((String)INTERACTION_NAME));
        level.method_8649((class_1297)interaction);
    }

    public static List<class_2338> findRitual(class_1937 level, class_2338 pos, class_2680 pieState) {
        class_2338.class_2339 mutable;
        if (!RitualModule.isCenterBlock(pieState)) {
            return List.of();
        }
        class_2700 pattern = RITUAL.get();
        class_2700.class_2702 match = pattern.method_35300((class_4538)level, (class_2338)(mutable = pos.method_25503().method_10104(class_2350.field_11043, 2).method_10104(class_2350.field_11034, 2)), class_2350.field_11036, class_2350.field_11043);
        if (match == null) {
            return List.of();
        }
        ArrayList headPosList = Lists.newArrayListWithExpectedSize((int)4);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2350 facing;
            mutable.method_10101((class_2382)pos).method_10098(class_2350.field_11036).method_10104(direction, 4);
            class_2680 head = level.method_8320((class_2338)mutable);
            if (!head.method_27852(class_2246.field_10337) && !head.method_27852(class_2246.field_10472) || (facing = RitualModule.getSkullFacing(head)) == null) continue;
            headPosList.add(mutable.method_10062());
        }
        return headPosList;
    }

    @Nullable
    public static class_2350 getSkullFacing(class_2680 state) {
        if (state.method_26204() instanceof class_2549) {
            return (class_2350)state.method_11654((class_2769)class_2549.field_11724);
        }
        if (state.method_26204() instanceof class_2484) {
            return switch ((Integer)state.method_11654((class_2769)class_2484.field_11505)) {
                case 0 -> class_2350.field_11043;
                case 4 -> class_2350.field_11034;
                case 8 -> class_2350.field_11035;
                case 12 -> class_2350.field_11039;
                default -> null;
            };
        }
        return null;
    }

    public static boolean tickDragonHead(class_1937 level, class_2338 blockPos, class_2680 blockState, class_2631 skullBlockEntity) {
        class_2350 facing = RitualModule.getSkullFacing(blockState);
        if (facing == null) {
            return false;
        }
        class_2338.class_2339 center = blockPos.method_25503().method_10104(facing, 4).method_10098(class_2350.field_11033);
        List entities = level.method_18023((class_5575)class_1299.field_42623, new class_238((class_2338)center), RitualModule::isFFInteractionEntity);
        if (entities.isEmpty()) {
            return false;
        }
        class_8150 interaction = (class_8150)entities.get(0);
        skullBlockEntity.field_41316 = false;
        int n = skullBlockEntity.field_41315 = interaction.field_6012 >= 99 ? 0 : 2;
        if (!level.field_9236) {
            return true;
        }
        if (interaction.field_6012 % 2 != 0) {
            return true;
        }
        double x = (double)blockPos.method_10263() + 0.5;
        double y = (double)blockPos.method_10264() + (blockState.method_27852(class_2246.field_10472) ? 0.6 : 0.3);
        double z = (double)blockPos.method_10260() + 0.5;
        class_243 motion = interaction.method_19538().method_1023(x, y, z).method_1029();
        motion = motion.method_1024(-0.1f);
        double power = class_3532.method_15350((double)((double)(interaction.field_6012 + 20) / 100.0), (double)0.25, (double)1.0);
        for (int i = 0; i < 3; ++i) {
            double dx = (motion.field_1352 * 0.08 + level.field_9229.method_43059() * 0.005) * power;
            double dy = (motion.field_1351 * 0.08 + level.field_9229.method_43059() * 0.005) * power;
            double dz = (motion.field_1350 * 0.08 + level.field_9229.method_43059() * 0.005) * power;
            for (int k = 2; k < 6; ++k) {
                level.method_8406((class_2394)class_2398.field_11216, x, y, z, dx * (double)k, dy * (double)k, dz * (double)k);
            }
            motion = motion.method_1024(0.1f);
        }
        return true;
    }

    public static boolean isFFInteractionEntity(class_8150 interaction) {
        return interaction.method_5797() != null && interaction.method_5797().getString().equals(INTERACTION_NAME);
    }

    public static boolean isCenterBlock(class_2680 blockState) {
        return FoodModule.CHORUS_FRUIT_PIE.is(blockState) && (Integer)blockState.method_11654((class_2769)PieBlock.PIE_SERVINGS) == 4;
    }

    public static void tickInteraction(class_8150 interaction) {
        List itemEntities;
        class_1937 level = interaction.method_37908();
        if (level.field_9236) {
            if (interaction.field_6012 == 55) {
                level.method_45446(interaction.method_24515(), (class_3414)RITUAL_FINISH.get(), class_3419.field_15256, 1.0f, 1.0f, false);
            }
            if (interaction.field_6012 == 99) {
                RitualModule.finishRitual(interaction);
            }
            return;
        }
        if (interaction.field_6012 > 100) {
            interaction.method_31472();
            return;
        }
        if (!RitualModule.isCenterBlock(level.method_8320(interaction.method_24515()))) {
            interaction.method_31472();
            return;
        }
        if (interaction.field_6012 == 100) {
            RitualModule.finishRitual(interaction);
            return;
        }
        if (!interaction.method_5782() && !(itemEntities = level.method_8390(class_1542.class, interaction.method_5829(), itemEntity -> itemEntity.method_5805() && !itemEntity.method_5740())).isEmpty()) {
            class_1542 itemEntity2 = (class_1542)itemEntities.get(0);
            itemEntity2.method_5804((class_1297)interaction);
            itemEntity2.method_6982(100);
        }
    }

    public static void finishRitual(class_8150 interaction) {
        class_3218 serverLevel;
        class_161 advancement;
        class_2680 state;
        class_2338 pos;
        class_1937 level = interaction.method_37908();
        List<class_2338> heads = RitualModule.findRitual(level, pos = interaction.method_24515(), state = level.method_8320(pos));
        if (heads.isEmpty()) {
            return;
        }
        for (class_2338 head : heads) {
            class_2586 class_25862 = level.method_8321(head);
            if (!(class_25862 instanceof class_2631)) continue;
            class_2631 skullBlockEntity = (class_2631)class_25862;
            skullBlockEntity.field_41315 = 0;
        }
        if (level.field_9236) {
            class_265 shape = state.method_26220((class_1922)level, pos);
            level.method_8650(pos, false);
            if (shape.method_1110()) {
                return;
            }
            class_238 aabb = shape.method_1107();
            for (int i = 0; i < 24; ++i) {
                double x = class_3532.method_16436((double)level.field_9229.method_43058(), (double)aabb.field_1323, (double)aabb.field_1320) + (double)pos.method_10263();
                double y = class_3532.method_16436((double)level.field_9229.method_43058(), (double)aabb.field_1322, (double)aabb.field_1325) + (double)pos.method_10264();
                double z = class_3532.method_16436((double)level.field_9229.method_43058(), (double)aabb.field_1321, (double)aabb.field_1324) + (double)pos.method_10260();
                level.method_8406((class_2394)class_2398.field_11237, x, y, z, 0.0, 0.0, 0.0);
            }
            return;
        }
        level.method_8650(pos, false);
        class_1799 itemStack = class_1799.field_8037;
        class_1297 i = interaction.method_31483();
        if (i instanceof class_1542) {
            class_1542 itemEntity = (class_1542)i;
            itemStack = itemEntity.method_6983();
        }
        interaction.method_31472();
        int breathCount = Hooks.vac && VacModule.VAC_GUN_CASING.is(itemStack) ? 1 : heads.size() + 1;
        class_1295 flame = new class_1295(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
        flame.method_5603(0.5f * (float)breathCount);
        flame.method_5604(200);
        flame.method_5608((class_2394)class_2398.field_11216);
        flame.method_5610(new class_1293(class_1294.field_5921, 1, 1));
        flame.field_5940 = DUMMY_UUID;
        level.method_8649((class_1297)flame);
        level.method_8396(null, pos, class_3417.field_14671, class_3419.field_15256, 1.0f, 1.0f);
        if (breathCount == 1) {
            interaction.method_5775(VacModule.VAC_GUN.itemStack());
            itemStack.method_7934(1);
        }
        if ((advancement = Hooks.advancement(serverLevel = (class_3218)level, "ritual")) != null) {
            for (class_3222 player : serverLevel.method_18456()) {
                if (player.method_5858((class_1297)interaction) > 256.0) continue;
                player.method_14236().method_12878(advancement, "_");
            }
        }
    }

    public static void rightClickInteraction(class_8150 interaction, class_1657 player, class_1268 interactionHand) {
        class_1937 level = interaction.method_37908();
        if (level.field_9236) {
            return;
        }
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_7960()) {
            return;
        }
        itemStack = itemStack.method_7971(1);
        class_1542 itemEntity = new class_1542(level, player.method_23317(), player.method_23318(), player.method_23321(), itemStack.method_7971(1));
        if (level.method_8649((class_1297)itemEntity)) {
            itemEntity.method_5804((class_1297)interaction);
            itemEntity.method_6982(100);
        }
    }
}

