/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.util;

import com.mojang.authlib.GameProfile;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_3481;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5540;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6809;
import net.minecraft.class_6817;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.CoreModule;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.FFRegistries;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.GeneticSavedData;
import snownee.fruits.cherry.item.FlowerCrownItem;
import snownee.fruits.command.FFCommands;
import snownee.fruits.compat.farmersdelight.FarmersDelightModule;
import snownee.fruits.compat.trinkets.TrinketsCompat;
import snownee.fruits.duck.FFPlayer;
import snownee.fruits.vacuum.VacGunItem;
import snownee.fruits.vacuum.VacModule;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.Mod;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.Util;

@Mod(value="fruitfulfun")
public class CommonProxy
implements ModInitializer {
    public static final UUID FAKE_PLAYER_UUID = UUID.fromString("ae5efe90-eef0-4899-94fc-de4786c242e8");
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(FAKE_PLAYER_UUID, "[FruitfulFun]");
    private static final class_6862<class_1792> KNIVES = AbstractModule.itemTag((String)"c", (String)"tools/knives");

    public static boolean isCurativeItem(class_1293 effectInstance, class_1799 stack) {
        return stack.method_31574(class_1802.field_8103);
    }

    public static boolean isFakePlayer(class_1297 entity) {
        return entity instanceof FakePlayer;
    }

    public static class_2596<class_2602> getAddEntityPacket(class_1297 entity) {
        return new class_2604(entity);
    }

    public static void maybeGrowCrops(class_3218 world, class_2338 pos, class_2680 state, boolean defaultResult, Runnable defaultAction) {
        if (defaultResult) {
            defaultAction.run();
        }
    }

    public static void addBuiltinPacks() {
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("fruitfulfun").orElseThrow();
        if (Hooks.food) {
            CommonProxy.addBuiltinPack(modContainer, "food");
        }
        if (Hooks.farmersdelight) {
            String mode = FarmersDelightModule.getMode();
            if ("vectorwing".equals(mode)) {
                CommonProxy.addBuiltinPack(modContainer, "farmersdelight");
            } else {
                CommonProxy.addBuiltinPack(modContainer, "farmersdelight_" + mode);
            }
        }
        if (FFCommonConfig.villageAppleTreeWorldGen) {
            CommonProxy.addBuiltinPack(modContainer, "apple_tree_in_village");
        }
    }

    private static void addBuiltinPack(ModContainer modContainer, String id) {
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)new class_2960("fruitfulfun", id), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
    }

    public static boolean isShears(class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.SHEARS);
    }

    public static boolean isBookshelf(class_2680 blockState) {
        return blockState.method_26164(ConventionalBlockTags.BOOKSHELVES);
    }

    public static boolean insertItem(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, class_2350 direction, class_1799 item) {
        Storage storage = (Storage)ItemStorage.SIDED.find(level, blockPos, blockState, blockEntity, (Object)direction);
        if (storage == null || !storage.supportsInsertion()) {
            return false;
        }
        boolean success = false;
        try (Transaction tx = Transaction.openOuter();){
            long inserted = storage.insert((Object)ItemVariant.of((class_1799)item), (long)item.method_7947(), (TransactionContext)tx);
            if (inserted > 0L) {
                tx.commit();
                item.method_7934((int)inserted);
                success = true;
            }
        }
        return success;
    }

    public static class_1799 extractOneItem(class_1937 level, class_2338 blockPos, class_2680 blockState, @Nullable class_2586 blockEntity, class_2350 direction) {
        Storage storage = (Storage)ItemStorage.SIDED.find(level, blockPos, blockState, blockEntity, (Object)direction);
        if (storage == null || !storage.supportsExtraction()) {
            return class_1799.field_8037;
        }
        VacGunItem.playContainerAnimation(blockEntity);
        Iterator iterator = storage.nonEmptyIterator();
        if (!iterator.hasNext()) {
            return class_1799.field_8037;
        }
        class_1799 result = class_1799.field_8037;
        try (Transaction tx = Transaction.openOuter();){
            ItemVariant resource = (ItemVariant)((StorageView)iterator.next()).getResource();
            long extracted = storage.extract((Object)resource, 1L, (TransactionContext)tx);
            if (extracted > 0L) {
                tx.commit();
                result = resource.toStack();
            }
        }
        return result;
    }

    public static class_3222 getFakePlayer(class_1937 level) {
        return FakePlayer.get((class_3218)((class_3218)level), (GameProfile)FAKE_PLAYER_PROFILE);
    }

    public static boolean isKnife(class_1799 itemStack) {
        return itemStack.method_31573(KNIVES);
    }

    public static boolean isBeehive(class_1799 itemStack) {
        return itemStack.method_31574(class_1802.field_20416) || itemStack.method_31574(class_1802.field_20415) || class_2248.method_9503((class_1792)itemStack.method_7909()).method_9564().method_26164(class_3481.field_20340);
    }

    public void onInitialize() {
        CommonProxy.addFeature("citron");
        CommonProxy.addFeature("tangerine");
        CommonProxy.addFeature("lime");
        TradeOfferHelper.registerWanderingTraderOffers((int)1, trades -> {
            if (FFCommonConfig.wanderingTraderSaplingPrice == 0) {
                return;
            }
            trades.add((entity, random) -> {
                class_1799 sapling = ((class_2248)class_156.method_32309(FFRegistries.FRUIT_TYPE.method_10220().filter($ -> $.tier == 0).map($ -> $.sapling.get()).toList(), (class_5819)random)).method_8389().method_7854();
                class_1799 emeralds = new class_1799((class_1935)class_1802.field_8687, FFCommonConfig.wanderingTraderSaplingPrice);
                return new class_1914(emeralds, sapling, 5, 1, 1.0f);
            });
        });
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world == server.method_30002()) {
                long seed = world.method_8412();
                GeneticSavedData data = (GeneticSavedData)world.method_17983().method_17924(GeneticSavedData::load, GeneticSavedData::new, "fruitfulfun_genetics");
                data.initAlleles(seed);
            }
        });
        if (Platform.isModLoaded((String)"leaves_us_in_peace")) {
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
                if (FFCommonConfig.leavesUsInPeaceIncompatibilityNotified || CommonProxy.isFakePlayer((class_1297)handler.method_32311())) {
                    return;
                }
                class_5250 msg = class_2561.method_43471((String)"tip.fruitfulfun.leavesUsInPeace");
                server.method_43496((class_2561)msg);
                handler.method_32311().method_43496((class_2561)msg);
                FFCommonConfig.leavesUsInPeaceIncompatibilityNotified = true;
                KiwiConfigManager.getHandler(FFCommonConfig.class).save();
            });
        }
        if (!Platform.isProduction()) {
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(FFCommands.register()));
        }
    }

    public static class_1799 getRecipeRemainder(class_1799 itemStack) {
        return itemStack.getRecipeRemainder();
    }

    public static void initBeeModule() {
        BeeModule.BEE_ONE_CM = class_3468.method_15021((String)BeeModule.BEE_ONE_CM.toString(), (class_3446)class_3446.field_16977);
        BeeModule.BEES_BRED = class_3468.method_15021((String)BeeModule.BEES_BRED.toString(), (class_3446)class_3446.field_16975);
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            Map<String, FFPlayer.GeneName> map = FFPlayer.of(oldPlayer).fruits$getGeneNames();
            FFPlayer.of(newPlayer).fruits$setGeneNames(map);
        });
    }

    public static void initVacModule() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (VacModule.VAC_GUN.is(player.method_5998(hand))) {
                player.method_6019(hand);
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (VacModule.VAC_GUN.is(player.method_5998(hand))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (VacModule.VAC_GUN.is(player.method_5998(hand))) {
                player.method_6019(hand);
                return class_1269.field_21466;
            }
            return class_1269.field_5811;
        });
        AttackEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (VacModule.VAC_GUN.is(player.method_5998(hand))) {
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
    }

    public static void addFeature(String id) {
        class_5321 key = class_6817.method_46865((String)Objects.requireNonNull(Util.RL((String)id, (String)"fruitfulfun")).toString());
        BiomeModifications.addFeature(context -> context.hasTag(ConventionalBiomeTags.TREE_DECIDUOUS) || context.hasTag(ConventionalBiomeTags.TREE_JUNGLE) || context.hasFeature(class_6809.field_35934), (class_2893.class_2895)class_2893.class_2895.field_13178, (class_5321)key);
    }

    public static FlowerCrownItem getFlowerCrown(class_1309 entity) {
        class_1799 stack = entity.method_6118(class_1304.field_6169);
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof FlowerCrownItem) {
            FlowerCrownItem item = (FlowerCrownItem)class_17922;
            return item;
        }
        if (Hooks.trinkets) {
            return TrinketsCompat.getFlowerCrown(entity);
        }
        return null;
    }

    public static boolean isLitCandle(class_2680 blockState) {
        return blockState.method_28498((class_2769)class_5540.field_27083) && (Boolean)blockState.method_11654((class_2769)class_5540.field_27083) != false && blockState.method_26164(CoreModule.CANDLES);
    }

    public static void extinguishCandle(@Nullable class_1657 player, class_2680 blockState, class_1936 level, class_2338 blockPos) {
        if (blockState.method_26204() instanceof class_5540) {
            class_5540.method_31614((class_1657)player, (class_2680)blockState, (class_1936)level, (class_2338)blockPos);
            return;
        }
        if (blockState.method_26164(CoreModule.CANDLES) && ((Boolean)blockState.method_11654((class_2769)class_5540.field_27083)).booleanValue()) {
            level.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_5540.field_27083, (Comparable)Boolean.valueOf(false)), 11);
            level.method_8406((class_2394)class_2398.field_11251, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.9, (double)blockPos.method_10260() + 0.5, 0.0, 0.1, 0.0);
            level.method_8396(null, blockPos, class_3417.field_26955, class_3419.field_15245, 1.0f, 1.0f);
            level.method_33596((class_1297)player, class_5712.field_28733, blockPos);
        }
    }
}

