/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.pomegranate.PomegranateModule;
import snownee.fruits.util.CommonProxy;
import snownee.fruits.util.PreventUpdateAnimation;
import snownee.fruits.vacuum.ContainerOpenerFakePlayer;
import snownee.fruits.vacuum.VacGunContainer;
import snownee.fruits.vacuum.VacItemProjectile;
import snownee.fruits.vacuum.VacModule;
import snownee.fruits.vacuum.network.CGunShotPacket;
import snownee.kiwi.item.ModItem;

public class VacGunItem
extends ModItem
implements PreventUpdateAnimation {
    public static final int MAX_ITEM_COUNT = 16;
    private static final int ITEM_BAR_COLOR = class_3532.method_15353((float)0.4f, (float)1.0f, (float)0.4f);
    private static final ThreadLocal<class_1542> DUMMY_ITEM_ENTITY = new ThreadLocal();

    public VacGunItem() {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903));
    }

    public static void shoot(class_1657 player, class_1268 hand) {
        class_1799 gun = player.method_5998(hand);
        if (player.method_7357().method_7904(gun.method_7909())) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType == null) {
            return;
        }
        if ("item".equals(ammoType)) {
            VacGunContainer container = VacGunItem.readItemContainer(gun);
            if (container == null || container.method_5442()) {
                return;
            }
            VacItemProjectile projectile = VacGunItem.shootItem(player, gun, container);
            if (projectile != null && PomegranateModule.POMEGRANATE_ITEM.is(projectile.method_7495())) {
                player.method_7357().method_7906(gun.method_7909(), 10);
            } else {
                long gameTime = player.method_37908().method_8510();
                long lastShot = gun.method_7948().method_10537("LastShot");
                player.method_7357().method_7906(gun.method_7909(), gameTime - lastShot < 8L ? 2 : 4);
            }
        } else if ("fluid".equals(ammoType)) {
            // empty if block
        }
        if (player.method_7340()) {
            CGunShotPacket.I.sendToServer($ -> {});
        } else {
            gun.method_7948().method_10544("LastShot", player.method_37908().method_8510());
        }
    }

    @Nullable
    public static VacItemProjectile shootItem(class_1657 player, class_1799 gun, VacGunContainer container) {
        if (player.method_37908().field_9236) {
            return null;
        }
        class_1799 itemStack = container.getLastItem();
        if (itemStack.method_7960()) {
            return null;
        }
        class_1799 split = itemStack.method_7971(1);
        class_243 lookAngle = player.method_5720();
        double d = player.method_23320() - 0.6;
        VacItemProjectile projectile = Objects.requireNonNull((VacItemProjectile)((class_1299)VacModule.ITEM_PROJECTILE.get()).method_5883(player.method_37908()));
        projectile.method_5814(player.method_23317(), d, player.method_23321());
        projectile.method_7432((class_1297)player);
        projectile.method_16940(split);
        projectile.method_7485(lookAngle.method_10216(), lookAngle.method_10214(), lookAngle.method_10215(), 2.0f, 0.01f);
        player.method_37908().method_8649((class_1297)projectile);
        container.method_5431();
        VacGunItem.saveItemContainer(gun, container);
        class_5819 random = player.method_6051();
        player.method_37908().method_43129(null, (class_1297)player, (class_3414)VacModule.GUN_SHOOT_ITEM.get(), player.method_5634(), 0.2f, ((random.method_43057() - random.method_43057()) * 0.7f + 1.0f) * 2.0f);
        return projectile;
    }

    public static int getItemCount(class_1799 gun) {
        if (gun.method_7969() == null) {
            return 0;
        }
        return gun.method_7969().method_10550("ItemCount");
    }

    public static void collectItem(class_1657 player, class_1542 itemEntity, class_1799 gun, @Nullable VacGunContainer container) {
        if (player.method_37908().field_9236) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return;
        }
        if (gun.method_7969() != null && VacGunItem.getItemCount(gun) >= 16) {
            return;
        }
        class_1799 itemStack = itemEntity.method_6983();
        VacGunContainer container2 = container;
        if (container2 == null) {
            container2 = VacGunItem.readItemContainer(gun);
        }
        if (container2 == null) {
            return;
        }
        int count = itemStack.method_7947();
        if ((count -= (itemStack = container2.method_5491(itemStack)).method_7947()) > 0) {
            player.method_6103((class_1297)itemEntity, count);
        }
        if (itemStack.method_7960()) {
            itemEntity.method_31472();
        } else {
            itemEntity.method_6979(itemStack);
        }
        if (container == null) {
            VacGunItem.saveItemContainer(gun, container2);
        }
    }

    public static VacGunContainer readItemContainer(class_1799 gun) {
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return null;
        }
        VacGunContainer container = new VacGunContainer(16);
        if (gun.method_7969() != null) {
            container.method_7659(gun.method_7969().method_10554("Items", 10));
        }
        return container;
    }

    public static void saveItemContainer(class_1799 gun, VacGunContainer container) {
        class_2487 tag = gun.method_7948();
        if (container.method_5442()) {
            tag.method_10551("AmmoType");
            tag.method_10551("Items");
            tag.method_10551("ItemCount");
            return;
        }
        tag.method_10582("AmmoType", "item");
        tag.method_10566("Items", (class_2520)container.method_7660());
        tag.method_10569("ItemCount", container.getItemCount());
    }

    @Nullable
    public static String getAmmoType(class_1799 gun) {
        if (gun.method_7969() == null) {
            return null;
        }
        String ammoType = gun.method_7969().method_10558("AmmoType");
        return ammoType.isEmpty() ? null : ammoType;
    }

    public int method_7881(class_1799 itemStack) {
        return 72000;
    }

    public class_1839 method_7853(class_1799 itemStack) {
        return class_1839.field_27079;
    }

    public void method_7852(class_1937 level, class_1309 living, class_1799 gun, int i) {
        if (!(living instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)living;
        class_243 start = player.method_5836(1.0f);
        if (level.field_9236) {
            return;
        }
        class_243 lookAngle = player.method_5828(1.0f);
        double reach = Math.min(i / 2 + 2, 8);
        class_243 end = start.method_1031(lookAngle.field_1352 * reach, lookAngle.field_1351 * reach, lookAngle.field_1350 * reach);
        class_1542 dummy = DUMMY_ITEM_ENTITY.get();
        if (dummy == null) {
            dummy = new class_1542(level, 0.0, 0.0, 0.0, class_1799.field_8037);
            DUMMY_ITEM_ENTITY.set(dummy);
        }
        dummy.method_51502(level);
        class_3965 hit = level.method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)dummy));
        dummy.method_51502(null);
        end = hit.method_17784();
        start = start.method_1019(lookAngle);
        class_238 aabb = new class_238(start, end).method_1014(1.0);
        VacGunItem.extractContainer(level, gun, lookAngle, start, (class_239)hit, aabb);
        VacGunItem.processEntities(level, player, gun, lookAngle, start, end, aabb);
        if (i % 2 == 0) {
            VacGunItem.processBlocks(level, player, gun, lookAngle, start, end, aabb);
        }
    }

    private static void extractContainer(class_1937 level, class_1799 gun, class_243 lookAngle, class_243 start, class_239 hit, class_238 aabb) {
        class_2350 direction;
        class_2586 blockEntity;
        class_2680 state;
        if (hit.method_17783() != class_239.class_240.field_1332) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return;
        }
        int count = VacGunItem.getItemCount(gun);
        if (count >= 16) {
            return;
        }
        if ((count += level.method_8390(class_1542.class, aabb, e -> {
            if (e.field_5960 || e.method_7325() || !e.method_5805()) {
                return false;
            }
            class_243 center = e.method_5829().method_1005();
            return center.method_1020(start).method_1026(lookAngle) > 0.866;
        }).size()) >= 16) {
            return;
        }
        class_3965 blockHitResult = (class_3965)hit;
        class_2338 pos = blockHitResult.method_17777();
        class_1799 itemStack = CommonProxy.extractOneItem(level, pos, state = level.method_8320(pos), blockEntity = level.method_8321(pos), direction = blockHitResult.method_17780());
        if (itemStack.method_7960()) {
            return;
        }
        class_243 end = hit.method_17784().method_1031((double)direction.method_10148() * 0.2, (double)direction.method_10164() * 0.2, (double)direction.method_10165() * 0.2);
        class_1542 itemEntity = new class_1542(level, end.field_1352, end.field_1351, end.field_1350, itemStack);
        itemEntity.method_18800(0.0, 0.1, 0.0);
        level.method_8649((class_1297)itemEntity);
    }

    private static void processEntities(class_1937 level, class_1657 player, class_1799 gun, class_243 lookAngle, class_243 start, class_243 end, class_238 aabb) {
        List entities = level.method_8390(class_1297.class, aabb, e -> {
            if (e == player || e.field_5960 || e.method_7325() || !e.method_5805()) {
                return false;
            }
            class_238 box = e.method_5829();
            if (box.method_17939() > 0.5 || box.method_17940() > 0.9 || box.method_17941() > 0.5) {
                return false;
            }
            class_243 center = box.method_1005();
            return center.method_1020(start).method_1026(lookAngle) > 0.866;
        });
        VacGunContainer container = null;
        boolean save = false;
        for (class_1297 entity : entities) {
            class_243 center;
            class_243 dist;
            double lengthSqr;
            if (entity.method_5765()) {
                class_243 position = entity.method_19538();
                entity.method_5848();
                entity.method_33574(position);
            }
            if ((lengthSqr = (dist = start.method_1020(center = entity.method_5829().method_1005())).method_1027()) < 1.0 && entity instanceof class_1542) {
                class_1542 itemEntity = (class_1542)entity;
                if (container == null) {
                    container = VacGunItem.readItemContainer(gun);
                }
                VacGunItem.collectItem(player, itemEntity, gun, container);
                save = true;
                entity.field_6007 = true;
                continue;
            }
            if (lengthSqr < 4.0) {
                power = dist.method_1029().method_1021(Math.max(0.2, lengthSqr / 16.0));
                entity.method_18799(power);
                entity.method_38785();
            } else {
                power = dist.method_1029().method_1021(0.2);
                power = power.method_1021(Math.max(0.1, 1.0 - lengthSqr / 64.0));
                class_243 deltaMovement = entity.method_18798().method_1019(power);
                if (deltaMovement.method_1027() > 0.5) {
                    deltaMovement = deltaMovement.method_1029().method_1021(0.5);
                }
                entity.method_18799(deltaMovement);
            }
            entity.field_6007 = true;
            if (!(entity instanceof class_1308)) continue;
            class_1308 mob = (class_1308)entity;
            mob.method_5942().method_6340();
        }
        if (save && container != null) {
            VacGunItem.saveItemContainer(gun, container);
        }
    }

    private static void processBlocks(class_1937 level, class_1657 player, class_1799 gun, class_243 lookAngle, class_243 start, class_243 end, class_238 aabb) {
        class_2338.method_29715((class_238)aabb).forEach(pos -> {
            class_2302 cropBlock;
            class_243 center = class_243.method_24953((class_2382)pos);
            class_243 dist = center.method_1020(start);
            if (dist.method_1029().method_1026(lookAngle) < 0.866 && dist.method_1027() > 0.9) {
                return;
            }
            class_2680 state = level.method_8320(pos);
            if (state.method_26215()) {
                return;
            }
            if (CommonProxy.isLitCandle(state)) {
                CommonProxy.extinguishCandle(player, state, (class_1936)level, pos);
                return;
            }
            if (player != null && state.method_26164(VacModule.VCD_PERFORM_USING)) {
                class_3965 blockHitResult = new class_3965(center, player.method_5735().method_10153(), pos, false);
                state.method_26174(level, player, player.method_6058(), blockHitResult);
                return;
            }
            class_2248 patt12312$temp = state.method_26204();
            if (patt12312$temp instanceof class_2302 && (cropBlock = (class_2302)patt12312$temp).method_9825(state)) {
                level.method_8651(pos, true, (class_1297)player);
                return;
            }
            if (state.method_26164(VacModule.VCD_PERFORM_BREAKING)) {
                level.method_8651(pos, true, (class_1297)player);
            }
        });
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        return class_5328.method_29282((class_1937)level, (class_1657)player, (class_1268)hand);
    }

    public boolean method_7885(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1657 player) {
        return false;
    }

    public int method_31569(class_1799 itemStack) {
        String ammoType = VacGunItem.getAmmoType(itemStack);
        if ("item".equals(ammoType)) {
            int itemCount = VacGunItem.getItemCount(itemStack);
            return class_3532.method_15386((float)((float)itemCount / 16.0f * 13.0f));
        }
        if ("fluid".equals(ammoType)) {
            // empty if block
        }
        return 0;
    }

    public int method_31571(class_1799 itemStack) {
        return ITEM_BAR_COLOR;
    }

    public boolean method_31567(class_1799 itemStack) {
        String ammoType = VacGunItem.getAmmoType(itemStack);
        if ("item".equals(ammoType)) {
            return VacGunItem.getItemCount(itemStack) > 0;
        }
        if ("fluid".equals(ammoType)) {
            // empty if block
        }
        return false;
    }

    public boolean method_31566(class_1799 gun, class_1799 itemStack, class_1735 slot, class_5536 clickAction, class_1657 player, class_5630 slotAccess) {
        if (clickAction != class_5536.field_27014 || !slot.method_32754(player) || itemStack.method_7960()) {
            return false;
        }
        VacGunContainer container = VacGunItem.readItemContainer(gun);
        if (container == null) {
            return false;
        }
        class_1799 itemStack2 = container.method_5491(itemStack);
        if (itemStack.method_7947() == itemStack2.method_7947()) {
            return false;
        }
        itemStack.method_7939(itemStack2.method_7947());
        VacGunItem.saveItemContainer(gun, container);
        return true;
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        super.method_7851(stack, worldIn, tooltip, flagIn);
        String ammoType = VacGunItem.getAmmoType(stack);
        if ("item".equals(ammoType)) {
            VacGunContainer container = VacGunItem.readItemContainer(stack);
            if (container != null) {
                int i = 0;
                int itemCount = 0;
                for (class_1799 itemStack2 : container.field_5828) {
                    if (itemStack2.method_7960()) continue;
                    if (++i > 4) break;
                    itemCount += itemStack2.method_7947();
                    class_5250 mutableComponent = itemStack2.method_7964().method_27661();
                    mutableComponent.method_27693(" x").method_27693(String.valueOf(itemStack2.method_7947()));
                    tooltip.add((class_2561)mutableComponent);
                }
                if (container.getItemCount() > itemCount) {
                    tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{container.getItemCount() - itemCount}).method_27692(class_124.field_1056));
                }
            }
        } else if ("fluid".equals(ammoType)) {
            // empty if block
        }
    }

    public static void playContainerAnimation(class_2586 blockEntity) {
        if (blockEntity instanceof class_1263 && blockEntity instanceof class_3908) {
            class_3908 menuProvider = (class_3908)blockEntity;
            ContainerOpenerFakePlayer player = ContainerOpenerFakePlayer.getOrCreate((class_3218)blockEntity.method_10997(), blockEntity.method_11016());
            player.method_17355(menuProvider);
        }
    }
}

