/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2292;
import net.minecraft.class_2346;
import net.minecraft.class_2375;
import net.minecraft.class_2468;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import snownee.fruits.util.ClientProxy;
import snownee.fruits.vacuum.client.ItemProjectileColor;

public class ItemProjectileColors {
    private static final Map<class_1792, ItemProjectileColor> COLORS = Maps.newIdentityHashMap();
    private static final class_1767[] DYE_COLOR_ORDER;

    public static void register(class_1792 item, ItemProjectileColor color) {
        COLORS.put(item, color);
    }

    public static ItemProjectileColor get(class_1799 itemStack) {
        if (!COLORS.containsKey(itemStack.method_7909())) {
            ItemProjectileColors.guessColor(itemStack.method_7909());
        }
        return COLORS.get(itemStack.method_7909());
    }

    private static void guessColor(class_1792 item) {
        class_2346 block;
        class_1747 blockItem;
        class_1767[] class_1767Array;
        ItemProjectileColor color = ClientProxy.getItemProjectileColor(item);
        if (color != null) {
            ItemProjectileColors.register(item, color);
            return;
        }
        if (item instanceof class_1747 && (class_1767Array = (blockItem = (class_1747)item).method_7711()) instanceof class_2346 && ((block = (class_2346)class_1767Array) instanceof class_2468 || block instanceof class_2375 || block instanceof class_2292)) {
            ItemProjectileColors.register(item, new ItemProjectileColor.FallingBlock(block));
            return;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        String palette = null;
        for (class_1767 dyeColor : DYE_COLOR_ORDER) {
            if (!id.method_12832().contains(dyeColor.method_7792())) continue;
            palette = id.method_12832().replace(dyeColor.method_7792(), "%s");
            break;
        }
        if (palette == null) {
            return;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)DYE_COLOR_ORDER.length);
        for (class_1767 dyeColor : DYE_COLOR_ORDER) {
            item = (class_1792)class_7923.field_41178.method_10223(id = id.method_45136(String.format(palette, dyeColor.method_7792())));
            if (item == class_1802.field_8162) {
                return;
            }
            list.add(Pair.of((Object)item, (Object)dyeColor));
        }
        for (Pair pair : list) {
            ItemProjectileColors.register((class_1792)pair.getFirst(), ItemProjectileColor.ofDyeColor((class_1767)pair.getSecond()));
        }
    }

    public static void invalidate() {
        COLORS.clear();
    }

    static {
        class_1767[] values = class_1767.values();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)values.length);
        list.add(class_1767.field_7967);
        list.add(class_1767.field_7951);
        for (class_1767 color : values) {
            if (color == class_1767.field_7967 || color == class_1767.field_7951) continue;
            list.add(color);
        }
        DYE_COLOR_ORDER = (class_1767[])list.toArray(class_1767[]::new);
    }
}

