/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.placement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import snownee.kiwi.customization.placement.ParsedProtoTag;
import snownee.kiwi.customization.placement.PlaceSlotProvider;

public record PlaceSlot(class_2350 side, ImmutableSortedMap<String, String> tags) {
    public static final Comparator<String> TAG_COMPARATOR = (a, b) -> {
        boolean bStar;
        boolean aStar = a.charAt(0) == '*';
        boolean bl = bStar = b.charAt(0) == '*';
        if (aStar != bStar) {
            return aStar ? -1 : 1;
        }
        return a.compareTo((String)b);
    };
    private static ImmutableListMultimap<Pair<class_2680, class_2350>, PlaceSlot> BLOCK_STATE_LOOKUP = ImmutableListMultimap.of();
    private static ImmutableSet<class_2248> BLOCK_HAS_SLOTS = ImmutableSet.of();

    public static Collection<PlaceSlot> find(class_2680 blockState, class_2350 side) {
        if (blockState.method_28498((class_2769)class_2741.field_12508)) {
            blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
        }
        return BLOCK_STATE_LOOKUP.get((Object)Pair.of((Object)blockState, (Object)side));
    }

    public static Optional<PlaceSlot> find(class_2680 blockState, class_2350 side, String primaryTag) {
        if (PlaceSlot.hasNoSlots(blockState.method_26204())) {
            return Optional.empty();
        }
        Collection<PlaceSlot> slots = PlaceSlot.find(blockState, side);
        if (slots.isEmpty()) {
            return Optional.empty();
        }
        return slots.stream().filter(slot -> slot.primaryTag().equals(primaryTag)).findAny();
    }

    public static boolean hasNoSlots(class_2248 block) {
        return !BLOCK_HAS_SLOTS.contains((Object)block);
    }

    public static void renewData(PlaceSlotProvider.Preparation preparation) {
        BLOCK_STATE_LOOKUP = ImmutableListMultimap.copyOf(preparation.slots());
        BLOCK_HAS_SLOTS = (ImmutableSet)preparation.slots().keySet().stream().map(Pair::getFirst).map(class_4970.class_4971::method_26204).collect(ImmutableSet.toImmutableSet());
    }

    public static int blockCount() {
        return BLOCK_HAS_SLOTS.size();
    }

    public String primaryTag() {
        return (String)this.tags.firstKey();
    }

    public List<String> tagList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.tags.size());
        this.tags.forEach((k, v) -> {
            if (v.isEmpty()) {
                list.add(k);
            } else {
                list.add(k + ":" + v);
            }
        });
        return list;
    }

    public boolean hasTag(ParsedProtoTag resolvedTag) {
        Preconditions.checkArgument((boolean)resolvedTag.isResolved(), (Object)"Tag must be resolved");
        if (resolvedTag.prefix().equals("*")) {
            return this.tags.containsKey((Object)resolvedTag.toString());
        }
        return Objects.equals(this.tags.get((Object)resolvedTag.key()), resolvedTag.value());
    }
}

