/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.anvil_crafting;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.anvil_crafting.AnvilContext;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.json.JsonPointer;

public class AnvilCraftingRecipe
extends LycheeRecipe<AnvilContext>
implements Comparable<AnvilCraftingRecipe> {
    protected class_1856 left;
    protected class_1856 right = class_1856.field_9017;
    protected int levelCost;
    protected int materialCost;
    protected class_1799 output;
    private List<PostAction> assembling = Collections.EMPTY_LIST;

    public AnvilCraftingRecipe(class_2960 id) {
        super(id);
        this.maxRepeats = IntBoundsHelper.ONE;
    }

    public boolean matches(AnvilContext ctx, class_1937 pLevel) {
        if (!this.right.method_8103() && ctx.right.method_7947() < this.materialCost) {
            return false;
        }
        return this.left.method_8093(ctx.left) && this.right.method_8093(ctx.right);
    }

    @Override
    public class_1799 assemble(AnvilContext ctx, class_5455 registryAccess) {
        ctx.levelCost = this.levelCost;
        ctx.materialCost = this.materialCost;
        ctx.itemHolders.replace(2, this.method_8110(registryAccess));
        ctx.enqueueActions(this.assembling.stream(), 1, true);
        ctx.runtime.run(this, ctx);
        return ctx.method_5438(2);
    }

    public class_1856 getLeft() {
        return this.left;
    }

    public class_1856 getRight() {
        return this.right;
    }

    public int getMaterialCost() {
        return this.materialCost;
    }

    @Override
    public class_1799 method_8110(class_5455 registryAccess) {
        return this.getResultItem();
    }

    public class_1799 getResultItem() {
        return this.output.method_7972();
    }

    public class_2371<class_1856> method_8117() {
        if (this.right.method_8103()) {
            return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.left});
        }
        return class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{this.left, this.right});
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        if (pointer.size() == 1) {
            if (pointer.getString(0).equals("item_out")) {
                return IntList.of((int)2);
            }
            if (pointer.getString(0).equals("item_in")) {
                return this.right.method_8103() ? IntList.of((int)0) : IntList.of((int)0, (int)1);
            }
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("item_in")) {
            try {
                int i = pointer.getInt(1);
                if (i >= 0 && i < 2) {
                    return IntList.of((int)i);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    @Override
    public JsonPointer defaultItemPointer() {
        return ITEM_OUT;
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.ANVIL_CRAFTING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.ANVIL_CRAFTING;
    }

    @Override
    public int compareTo(AnvilCraftingRecipe that) {
        return Integer.compare(this.method_8118() ? 1 : 0, that.method_8118() ? 1 : 0);
    }

    public void addAssemblingAction(PostAction action) {
        Objects.requireNonNull(action);
        if (this.assembling == Collections.EMPTY_LIST) {
            this.assembling = Lists.newArrayList();
        }
        this.assembling.add(action);
    }

    @Override
    public Stream<PostAction> getAllActions() {
        return Stream.concat(this.getPostActions(), this.assembling.stream());
    }

    @Override
    public boolean isActionPath(JsonPointer pointer) {
        if (pointer.isRoot()) {
            return false;
        }
        String token = pointer.getString(0);
        return "assembling".equals(token) || "post".equals(token);
    }

    @Override
    public Map<JsonPointer, List<PostAction>> getActionGroups() {
        return Map.of(POST, this.actions, new JsonPointer("/assembling"), this.assembling);
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<AnvilCraftingRecipe> {
        public Serializer() {
            super(AnvilCraftingRecipe::new);
        }

        @Override
        public void fromJson(AnvilCraftingRecipe pRecipe, JsonObject pSerializedRecipe) {
            JsonElement itemIn = pSerializedRecipe.get("item_in");
            if (itemIn.isJsonArray()) {
                JsonArray array = itemIn.getAsJsonArray();
                pRecipe.left = class_1856.method_52177((JsonElement)array.get(0));
                if (array.size() > 0) {
                    pRecipe.right = class_1856.method_52177((JsonElement)array.get(1));
                }
            } else {
                pRecipe.left = class_1856.method_52177((JsonElement)itemIn);
            }
            PostAction.parseActions(pSerializedRecipe.get("assembling"), pRecipe::addAssemblingAction);
            pRecipe.output = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)pSerializedRecipe, (String)"item_out"));
            pRecipe.levelCost = class_3518.method_15282((JsonObject)pSerializedRecipe, (String)"level_cost", (int)1);
            Preconditions.checkArgument((pRecipe.levelCost > 0 ? 1 : 0) != 0, (Object)"level_cost must be greater than 0");
            pRecipe.materialCost = class_3518.method_15282((JsonObject)pSerializedRecipe, (String)"material_cost", (int)1);
        }

        @Override
        public void fromNetwork(AnvilCraftingRecipe pRecipe, class_2540 pBuffer) {
            pRecipe.left = class_1856.method_8086((class_2540)pBuffer);
            pRecipe.right = class_1856.method_8086((class_2540)pBuffer);
            pRecipe.output = pBuffer.method_10819();
            pRecipe.levelCost = pBuffer.method_10816();
            pRecipe.materialCost = pBuffer.method_10816();
        }

        @Override
        public void toNetwork0(class_2540 pBuffer, AnvilCraftingRecipe pRecipe) {
            pRecipe.left.method_8088(pBuffer);
            pRecipe.right.method_8088(pBuffer);
            pBuffer.method_10793(pRecipe.output);
            pBuffer.method_10804(pRecipe.levelCost);
            pBuffer.method_10804(pRecipe.materialCost);
        }
    }
}

