/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.block_crushing;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2105;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_4550;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.util.RecipeMatcher;

public class BlockCrushingRecipe
extends LycheeRecipe<BlockCrushingContext>
implements BlockKeyRecipe<BlockCrushingRecipe> {
    public static final class_4550 ANVIL = class_4550.class_4710.method_23880().method_29233(class_3481.field_15486).method_23882();
    protected class_4550 fallingBlock = ANVIL;
    protected class_4550 landingBlock = class_4550.field_20692;
    protected class_2371<class_1856> ingredients = class_2371.method_10211();

    public BlockCrushingRecipe(class_2960 id) {
        super(id);
    }

    public boolean matches(BlockCrushingContext ctx, class_1937 pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateHelper.fastMatch(this.landingBlock, ctx)) {
            return false;
        }
        if (!this.matchesFallingBlock(ctx.fallingBlock.method_6962(), ctx.fallingBlock.field_7194)) {
            return false;
        }
        if (this.ingredients.isEmpty()) {
            return true;
        }
        List<class_1542> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.method_8093($.method_6983()))).limit(27L).toList();
        List<class_1799> items = itemEntities.stream().map(class_1542::method_6983).toList();
        Optional<RecipeMatcher<class_1799>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(class_1799::method_7947).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    public boolean matchesFallingBlock(class_2680 blockstate, class_2487 nbt) {
        if (this.fallingBlock == class_4550.field_20692) {
            return true;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)this.fallingBlock;
        if (access.getTag() != null && !blockstate.method_26164(access.getTag())) {
            return false;
        }
        if (access.getBlocks() != null && !access.getBlocks().contains(blockstate.method_26204())) {
            return false;
        }
        if (!access.getProperties().method_22514(blockstate)) {
            return false;
        }
        if (access.getNbt() != class_2105.field_9716) {
            return nbt != null && access.getNbt().method_9077((class_2520)nbt);
        }
        return true;
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.BLOCK_CRUSHING;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.BLOCK_CRUSHING;
    }

    @Override
    public class_4550 getBlock() {
        return this.fallingBlock;
    }

    public class_4550 getLandingBlock() {
        return this.landingBlock;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    @Override
    public List<class_4550> getBlockInputs() {
        return List.of(this.fallingBlock, this.landingBlock);
    }

    @Override
    public int compareTo(BlockCrushingRecipe that) {
        int i = Integer.compare(this.getMaxRepeats().method_9041() ? 1 : 0, that.getMaxRepeats().method_9041() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.method_8118() ? 1 : 0, that.method_8118() ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = Integer.compare(this.landingBlock == class_4550.field_20692 ? 1 : 0, that.landingBlock == class_4550.field_20692 ? 1 : 0);
        if (i != 0) {
            return i;
        }
        i = -Integer.compare(this.ingredients.size(), that.ingredients.size());
        if (i != 0) {
            return i;
        }
        return this.method_8114().method_12833(that.method_8114());
    }

    public static class Serializer
    extends LycheeRecipe.Serializer<BlockCrushingRecipe> {
        public Serializer() {
            super(BlockCrushingRecipe::new);
        }

        @Override
        public void fromJson(BlockCrushingRecipe pRecipe, JsonObject pSerializedRecipe) {
            if (pSerializedRecipe.has("falling_block")) {
                pRecipe.fallingBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("falling_block"));
            }
            if (pSerializedRecipe.has("landing_block")) {
                pRecipe.landingBlock = BlockPredicateHelper.fromJson(pSerializedRecipe.get("landing_block"));
            }
            if (pSerializedRecipe.has("item_in")) {
                JsonElement itemIn = pSerializedRecipe.get("item_in");
                if (itemIn.isJsonArray()) {
                    itemIn.getAsJsonArray().forEach($ -> pRecipe.ingredients.add((Object)class_1856.method_52177((JsonElement)$)));
                } else {
                    pRecipe.ingredients.add((Object)class_1856.method_52177((JsonElement)itemIn));
                }
                Preconditions.checkArgument((pRecipe.ingredients.size() <= 27 ? 1 : 0) != 0, (String)"Ingredients cannot be more than %s", (int)27);
            }
        }

        @Override
        public void fromNetwork(BlockCrushingRecipe pRecipe, class_2540 pBuffer) {
            pRecipe.fallingBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pRecipe.landingBlock = BlockPredicateHelper.fromNetwork(pBuffer);
            pBuffer.method_34068(i -> pRecipe.ingredients, class_1856::method_8086);
        }

        @Override
        public void toNetwork0(class_2540 pBuffer, BlockCrushingRecipe pRecipe) {
            BlockPredicateHelper.toNetwork(pRecipe.fallingBlock, pBuffer);
            BlockPredicateHelper.toNetwork(pRecipe.landingBlock, pBuffer);
            pBuffer.method_34062(pRecipe.ingredients, (b, i) -> i.method_8088(b));
        }
    }
}

