/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.block_crushing;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.block_crushing.BlockCrushingContext;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.block_crushing.LycheeFallingBlockEntity;
import snownee.lychee.core.input.ItemHolder;
import snownee.lychee.core.network.SCustomLevelEventPacket;
import snownee.lychee.core.recipe.type.BlockKeyRecipeType;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CommonProxy;

public class BlockCrushingRecipeType
extends BlockKeyRecipeType<BlockCrushingContext, BlockCrushingRecipe> {
    private LycheeRecipeType.ValidItemCache validItems = new LycheeRecipeType.ValidItemCache();

    public BlockCrushingRecipeType(String name, Class<BlockCrushingRecipe> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
        this.compactInputs = true;
    }

    public void process(class_1540 entity) {
        boolean matched;
        if (this.isEmpty()) {
            return;
        }
        class_2338 pos = CommonProxy.getOnPos((class_1297)entity);
        class_2680 fallingBlock = entity.method_6962();
        Collection recipes = this.recipesByBlock.getOrDefault(fallingBlock.method_26204(), Collections.EMPTY_LIST);
        if (recipes.isEmpty()) {
            return;
        }
        class_238 box = entity.method_5829();
        class_1937 level = entity.method_37908();
        class_2680 landingBlock = level.method_8320(pos);
        if (landingBlock.method_26164(LycheeTags.EXTEND_BOX)) {
            box = box.method_991(new class_238(pos));
        }
        List itemEntities = entity.method_37908().method_8390(class_1542.class, box, $ -> $.method_5805() && this.validItems.contains($.method_6983()));
        BlockCrushingContext.Builder ctxBuilder = new BlockCrushingContext.Builder(entity.method_37908(), itemEntities, entity);
        ctxBuilder.withParameter(class_181.field_24424, entity.method_19538());
        ctxBuilder.withParameter(class_181.field_1226, entity);
        ctxBuilder.withParameter(class_181.field_1224, landingBlock);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        BlockCrushingContext ctx = ctxBuilder.create(this.contextParamSet);
        boolean matchedAny = false;
        int loop = 0;
        block2: do {
            matched = false;
            for (BlockCrushingRecipe recipe : recipes) {
                if (recipe.ingredients.isEmpty() && loop > 0) continue;
                try {
                    int i;
                    Optional match = this.tryMatch(recipe, level, ctx);
                    if (!match.isPresent()) continue;
                    matched = true;
                    matchedAny = true;
                    int times = 1;
                    if (ctx.getMatch() != null && ctx.getMatch().inputUsed.length > 0) {
                        int[] inputUsed = ctx.getMatch().inputUsed;
                        times = recipe.getRandomRepeats(Integer.MAX_VALUE, ctx);
                        for (i = 0; i < inputUsed.length; ++i) {
                            if (inputUsed[i] <= 0) continue;
                            class_1799 stack = ((class_1542)ctx.filteredItems.get(i)).method_6983();
                            times = Math.min(times, stack.method_7947() / inputUsed[i]);
                        }
                    }
                    ((BlockCrushingRecipe)match.get()).applyPostActions(ctx, times);
                    if (!ctx.runtime.doDefault) {
                        ((LycheeFallingBlockEntity)entity).lychee$cancelDrop();
                    }
                    if (CommonProxy.hasKiwi) {
                        HashSet alreadySentParticles = Sets.newHashSet();
                        for (i = 0; i < ctx.itemHolders.size(); ++i) {
                            ItemHolder holder = ctx.itemHolders.get(i);
                            if (ctx.itemHolders.ignoreConsumptionFlags.get(i) || holder.get().method_7960() || !(holder instanceof ItemHolder.InWorld) || alreadySentParticles.contains(holder)) continue;
                            alreadySentParticles.add(holder);
                            SCustomLevelEventPacket.sendItemParticles(holder.get(), ctx.getServerLevel(), ((ItemHolder.InWorld)holder).getEntity().method_19538());
                        }
                    }
                    ctx.totalItems -= ctx.itemHolders.postApply(true, times);
                    if (recipe.getMaxRepeats().method_9041()) {
                        ctx.filteredItems = null;
                        ctx.setMatch(null);
                        ctx.itemEntities.removeIf($ -> $.method_6983().method_7960());
                        continue;
                    }
                    break block2;
                }
                catch (Exception e) {
                    Lychee.LOGGER.error("", (Throwable)e);
                    break block2;
                }
            }
        } while (++loop < 100 && matched);
        if (matchedAny) {
            class_2680 state = level.method_8320(entity.method_24515());
            if (!class_2346.method_10128((class_2680)state)) {
                entity.method_23327(entity.method_23317(), (double)(pos.method_10264() + 1), entity.method_23321());
            }
            ((LycheeFallingBlockEntity)entity).lychee$matched();
            ctx.itemEntities.forEach($ -> $.method_6979($.method_6983().method_7972()));
        }
    }

    @Override
    public void buildCache() {
        super.buildCache();
        this.validItems.buildCache(this.recipes);
    }
}

