/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.client.core.post;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.post.RandomSelect;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;

public interface PostActionRenderer<T extends PostAction> {
    public static final Map<PostActionType<?>, PostActionRenderer<?>> RENDERERS = Maps.newHashMap();
    public static final PostActionRenderer<PostAction> DEFAULT = new PostActionRenderer<PostAction>(){};

    public static <T extends PostAction> PostActionRenderer<T> of(PostAction action) {
        return RENDERERS.getOrDefault(action.getType(), DEFAULT);
    }

    public static <T extends PostAction> void register(PostActionType<T> type, PostActionRenderer<T> renderer) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(renderer);
        RENDERERS.put(type, renderer);
    }

    public static List<class_2561> getTooltipsFromRandom(RandomSelect randomSelect, PostAction child) {
        int c;
        ArrayList list;
        int index = Arrays.asList(randomSelect.entries).indexOf(child);
        ArrayList arrayList = list = randomSelect.entries.length == 1 && randomSelect.emptyWeight == 0 ? Lists.newArrayList((Object[])new class_2561[]{randomSelect.getDisplayName()}) : PostActionRenderer.of(child).getBaseTooltips(child);
        if (index == -1) {
            return list;
        }
        if (randomSelect.entries.length > 1 || randomSelect.emptyWeight > 0) {
            String chance = CommonProxy.chance((float)randomSelect.weights[index] / (float)randomSelect.totalWeight);
            if (randomSelect.rolls == IntBoundsHelper.ONE) {
                list.add(class_2561.method_43469((String)"tip.lychee.randomChance.one", (Object[])new Object[]{chance}).method_27692(class_124.field_1054));
            } else {
                list.add(class_2561.method_43469((String)"tip.lychee.randomChance", (Object[])new Object[]{chance, BoundsHelper.getDescription(randomSelect.rolls)}).method_27692(class_124.field_1054));
            }
        }
        if ((c = randomSelect.showingConditionsCount() + child.showingConditionsCount()) > 0) {
            list.add(ClientProxy.format("contextual.lychee", c).method_27692(class_124.field_1080));
        }
        class_310 mc = class_310.method_1551();
        randomSelect.getConditionTooltips(list, 0, (class_1937)mc.field_1687, (class_1657)mc.field_1724);
        child.getConditionTooltips(list, 0, (class_1937)mc.field_1687, (class_1657)mc.field_1724);
        return list;
    }

    default public void render(T action, class_332 graphics, int x, int y) {
    }

    default public List<class_2561> getBaseTooltips(T action) {
        return Lists.newArrayList((Object[])new class_2561[]{((PostAction)action).getDisplayName()});
    }

    default public List<class_2561> getTooltips(T action) {
        List<class_2561> list = this.getBaseTooltips(action);
        int c = ((ContextualHolder)action).showingConditionsCount();
        if (c > 0) {
            list.add((class_2561)ClientProxy.format("contextual.lychee", c).method_27692(class_124.field_1080));
        }
        class_310 mc = class_310.method_1551();
        ((ContextualHolder)action).getConditionTooltips(list, 0, (class_1937)mc.field_1687, (class_1657)mc.field_1724);
        return list;
    }

    default public void loadCatalystsInfo(T action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
    }
}

