/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core;

import com.google.gson.JsonObject;
import net.minecraft.class_2540;
import net.minecraft.class_3518;
import snownee.lychee.util.json.JsonPointer;

public abstract class Reference {
    public static final Reference DEFAULT = new Constant("default");

    public static Reference create(String value) {
        if ("default".equals(value)) {
            return DEFAULT;
        }
        if (value.codePointAt(0) == 47) {
            return new Pointer(new JsonPointer(value));
        }
        return new Constant(value);
    }

    public static Reference fromJson(JsonObject parent, String key) {
        return Reference.create(class_3518.method_15253((JsonObject)parent, (String)key, (String)"default"));
    }

    public static void toJson(Reference reference, JsonObject parent, String key) {
        if (reference == DEFAULT) {
            return;
        }
        parent.addProperty(key, reference.toString());
    }

    public static Reference fromNetwork(class_2540 buf) {
        return Reference.create(buf.method_19772());
    }

    public static void toNetwork(Reference reference, class_2540 buf) {
        buf.method_10814(reference.toString());
    }

    public boolean isPointer() {
        return this.getClass() == Pointer.class;
    }

    public JsonPointer getPointer() {
        return ((Pointer)this).pointer;
    }

    public static class Pointer
    extends Reference {
        private final JsonPointer pointer;

        public Pointer(JsonPointer pointer) {
            this.pointer = pointer;
        }

        public String toString() {
            return this.pointer.toString();
        }
    }

    public static class Constant
    extends Reference {
        public final String name;

        public Constant(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

