/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_205;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_217;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_4559;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.LocationPredicateHelper;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.LightPredicateAccess;
import snownee.lychee.mixin.LocationCheckAccess;
import snownee.lychee.mixin.LocationPredicateAccess;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;

public record Location(class_205 check) implements ContextualCondition
{
    private static final Rule X = new PosRule("x", LocationPredicateAccess::getX, class_243::method_10216);
    private static final Rule Y = new PosRule("y", LocationPredicateAccess::getY, class_243::method_10214);
    private static final Rule Z = new PosRule("z", LocationPredicateAccess::getZ, class_243::method_10215);
    private static final Rule DIMENSION = new DimensionRule();
    private static final Rule FEATURE = new FeatureRule();
    private static final Rule BIOME = new BiomeRule();
    private static final Rule BLOCK = new BlockRule();
    private static final Rule FLUID = new FluidRule();
    private static final Rule LIGHT = new LightRule();
    private static final Rule SMOKEY = new SmokeyRule();
    public static final Rule[] RULES = new Rule[]{X, Y, Z, DIMENSION, FEATURE, BIOME, BLOCK, FLUID, LIGHT, SMOKEY};

    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.LOCATION;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        if (ctx.getLevel().field_9236) {
            return this.testClient(ctx.getLevel(), ctx.getParamOrNull(LycheeLootContextParams.BLOCK_POS), (class_243)ctx.getParamOrNull(class_181.field_24424)) == class_1269.field_5812 ? times : 0;
        }
        return this.check.method_881(ctx.toLootContext()) ? times : 0;
    }

    @Override
    public class_1269 testInTooltips(class_1937 level, @Nullable class_1657 player) {
        if (player == null) {
            return class_1269.field_5811;
        }
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        if (!class_2338.field_10980.equals((Object)checkAccess.getOffset())) {
            return class_1269.field_5811;
        }
        class_243 vec = player.method_19538();
        class_2338 pos = player.method_24515();
        return this.testClient(level, pos, vec);
    }

    public class_1269 testClient(class_1937 level, class_2338 pos, class_243 vec) {
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        class_2338 offset = checkAccess.getOffset();
        if (!class_2338.field_10980.equals((Object)offset)) {
            pos = pos.method_10069(offset.method_10263(), offset.method_10264(), offset.method_10260());
        }
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        boolean hasPass = false;
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            class_1269 result = rule.testClient(access, level, pos, vec);
            if (result == class_1269.field_5814) {
                return result;
            }
            if (result != class_1269.field_5811) continue;
            hasPass = true;
        }
        return hasPass ? class_1269.field_5811 : class_1269.field_5812;
    }

    @Override
    public void appendTooltips(List<class_2561> tooltips, class_1937 level, @Nullable class_1657 player, int indent, boolean inverted) {
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        boolean test = false;
        class_243 vec = null;
        class_2338 pos = null;
        String key = this.makeDescriptionId(inverted);
        boolean noOffset = class_2338.field_10980.equals((Object)checkAccess.getOffset());
        if (!noOffset) {
            class_2338 offset = checkAccess.getOffset();
            class_5250 content = class_2561.method_43469((String)key, (Object[])new Object[]{offset.method_10263(), offset.method_10264(), offset.method_10260()}).method_27692(class_124.field_1080);
            class_1269 result = this.testInTooltips(level, player);
            ContextualCondition.desc(tooltips, result, indent, content);
            ++indent;
        }
        if (noOffset && player != null) {
            test = true;
            vec = player.method_19538();
            pos = player.method_24515();
        }
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            class_1269 result = class_1269.field_5811;
            if (test) {
                result = rule.testClient(access, level, pos, vec);
            }
            rule.appendTooltips(tooltips, indent, key, access, result);
        }
    }

    @Override
    public class_5250 getDescription(boolean inverted) {
        return class_2561.method_43471((String)this.makeDescriptionId(inverted));
    }

    @Override
    public int showingCount() {
        int c = 0;
        LocationCheckAccess checkAccess = (LocationCheckAccess)this.check;
        LocationPredicateAccess access = (LocationPredicateAccess)checkAccess.getPredicate();
        for (Rule rule : RULES) {
            if (rule.isAny(access)) continue;
            ++c;
        }
        return c;
    }

    public static interface Rule {
        public String getName();

        public boolean isAny(LocationPredicateAccess var1);

        default public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            return class_1269.field_5811;
        }

        public void appendTooltips(List<class_2561> var1, int var2, String var3, LocationPredicateAccess var4, class_1269 var5);
    }

    private record PosRule(String name, Function<LocationPredicateAccess, class_2096.class_2099> boundsGetter, Function<class_243, Double> valueGetter) implements Rule
    {
        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return this.boundsGetter.apply(access).method_9041();
        }

        @Override
        public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            return CommonProxy.interactionResult(this.boundsGetter.apply(access).method_9047(this.valueGetter.apply(vec).doubleValue()));
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{BoundsHelper.getDescription((class_2096)this.boundsGetter.apply(access)).method_27692(class_124.field_1068)}));
        }
    }

    private static class DimensionRule
    implements Rule {
        private DimensionRule() {
        }

        @Override
        public String getName() {
            return "dimension";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getDimension() == null;
        }

        @Override
        public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            return CommonProxy.interactionResult(level.method_27983() == access.getDimension());
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            class_5250 name = ClientProxy.getDimensionDisplayName(access.getDimension()).method_27692(class_124.field_1068);
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class FeatureRule
    implements Rule {
        private FeatureRule() {
        }

        @Override
        public String getName() {
            return "feature";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getStructure() == null;
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            class_5250 name = ClientProxy.getStructureDisplayName(access.getStructure().method_29177()).method_27692(class_124.field_1068);
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class BiomeRule
    implements Rule {
        private BiomeRule() {
        }

        @Override
        public String getName() {
            return "biome";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getBiome() == null && ((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag() == null;
        }

        @Override
        public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            class_6880 biome = level.method_23753(pos);
            if (access.getBiome() != null && biome.method_40226(access.getBiome().method_29177())) {
                return class_1269.field_5812;
            }
            class_6862<class_1959> tag = ((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag();
            if (tag != null && biome.method_40220(tag)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5814;
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            String valueKey = access.getBiome() != null ? class_156.method_646((String)"biome", (class_2960)access.getBiome().method_29177()) : class_156.method_646((String)"biomeTag", (class_2960)((LocationPredicateHelper)((Object)access)).lychee$getBiomeTag().comp_327());
            class_5250 name = class_2561.method_43471((String)valueKey).method_27692(class_124.field_1068);
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }
    }

    private static class BlockRule
    implements Rule {
        private BlockRule() {
        }

        @Override
        public String getName() {
            return "block";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getBlock() == class_4550.field_20692;
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            class_2248 block = CommonProxy.getCycledItem(List.copyOf(BlockPredicateHelper.getMatchedBlocks(access.getBlock())), class_2246.field_10124, 1000);
            class_5250 name = block.method_9518().method_27692(class_124.field_1068);
            BlockPredicateAccess blockAccess = (BlockPredicateAccess)access.getBlock();
            if (blockAccess.getProperties() != class_4559.field_20736 || blockAccess.getNbt() != class_2105.field_9716) {
                name.method_27693("*");
            }
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{name}));
        }

        @Override
        public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            return BlockPredicateHelper.fastMatch(access.getBlock(), level.method_8320(pos), () -> level.method_8321(pos)) ? class_1269.field_5812 : class_1269.field_5814;
        }
    }

    private static class FluidRule
    implements Rule {
        private FluidRule() {
        }

        @Override
        public String getName() {
            return "fluid";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getFluid() == class_4551.field_20708;
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
        }
    }

    private static class LightRule
    implements Rule {
        private LightRule() {
        }

        @Override
        public String getName() {
            return "light";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getLight() == class_4552.field_20712;
        }

        @Override
        public class_1269 testClient(LocationPredicateAccess access, class_1937 level, class_2338 pos, class_243 vec) {
            int light = level.method_22339(pos);
            return CommonProxy.interactionResult(((LightPredicateAccess)access.getLight()).getComposite().method_9054(light));
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            class_5250 bounds = BoundsHelper.getDescription(((LightPredicateAccess)access.getLight()).getComposite()).method_27692(class_124.field_1068);
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43469((String)(key + "." + this.getName()), (Object[])new Object[]{bounds}));
        }
    }

    private static class SmokeyRule
    implements Rule {
        private SmokeyRule() {
        }

        @Override
        public String getName() {
            return "smokey";
        }

        @Override
        public boolean isAny(LocationPredicateAccess access) {
            return access.getSmokey() == null;
        }

        @Override
        public void appendTooltips(List<class_2561> tooltips, int indent, String key, LocationPredicateAccess access, class_1269 result) {
            key = (String)key + "." + this.getName();
            if (access.getSmokey() == Boolean.FALSE) {
                key = (String)key + ".not";
            }
            ContextualCondition.desc(tooltips, result, indent, class_2561.method_43471((String)key));
        }
    }

    public static class Type
    extends ContextualConditionType<Location> {
        @Override
        public Location fromJson(JsonObject o) {
            class_205 check = (class_205)class_217.field_25247.method_29312().method_517(o, (JsonDeserializationContext)ContextualCondition.gsonContext);
            return new Location(check);
        }

        @Override
        public void toJson(Location condition, JsonObject o) {
            new class_205.class_206().method_886(o, condition.check(), (JsonSerializationContext)ContextualCondition.gsonContext);
        }

        @Override
        public Location fromNetwork(class_2540 buf) {
            class_2090.class_2091 builder = LocationPredicateHelper.fromNetwork(buf);
            class_205 check = (class_205)class_205.method_30151((class_2090.class_2091)builder, (class_2338)buf.method_10811()).build();
            class_2960 biomeTag = CommonProxy.readNullableRL(buf);
            if (biomeTag != null) {
                LocationPredicateHelper access = (LocationPredicateHelper)((LocationCheckAccess)check).getPredicate();
                access.lychee$setBiomeTag((class_6862<class_1959>)class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)biomeTag));
            }
            return new Location(check);
        }

        @Override
        public void toNetwork(Location condition, class_2540 buf) {
            LocationCheckAccess access = (LocationCheckAccess)condition.check();
            LocationPredicateHelper.toNetwork(access.getPredicate(), buf);
            buf.method_10807(access.getOffset());
            class_2960 biomeTag = Optional.ofNullable(((LocationPredicateHelper)access.getPredicate()).lychee$getBiomeTag()).map(class_6862::comp_327).orElse(null);
            CommonProxy.writeNullableRL(biomeTag, buf);
        }
    }
}

