/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.def;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_2105;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2404;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4550;
import net.minecraft.class_4559;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.PropertiesPredicateHelper;
import snownee.lychee.mixin.BlockPredicateAccess;
import snownee.lychee.mixin.StatePropertiesPredicateAccess;
import snownee.lychee.util.CommonProxy;

public class BlockPredicateHelper {
    public static final class_2105 NBT_PREDICATE_DUMMY = new class_2105(new class_2487());
    private static final Cache<class_4550, List<class_2680>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    public static Set<class_2769<?>> ITERABLE_PROPERTIES = Sets.newConcurrentHashSet();

    public static Set<class_2248> getMatchedBlocks(class_4550 predicate) {
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        LinkedHashSet blocks = Sets.newLinkedHashSet();
        if (access.getBlocks() != null) {
            blocks.addAll(access.getBlocks());
        }
        if (access.getTag() != null) {
            blocks.addAll(CommonProxy.tagElements(class_7923.field_41175, access.getTag()));
        }
        return blocks;
    }

    public static Set<class_3611> getMatchedFluids(class_4550 predicate) {
        return BlockPredicateHelper.getMatchedBlocks(predicate).stream().filter(class_2404.class::isInstance).map(class_2248::method_9564).map(class_4970.class_4971::method_26227).filter(Predicate.not(class_3610::method_15769)).map(class_3610::method_15772).collect(Collectors.toSet());
    }

    public static List<class_1799> getMatchedItemStacks(class_4550 predicate) {
        return BlockPredicateHelper.getMatchedBlocks(predicate).stream().map(class_2248::method_8389).filter(Predicate.not(class_1802.field_8162::equals)).distinct().map(class_1792::method_7854).toList();
    }

    public static boolean fastMatch(class_4550 predicate, LycheeContext context) {
        return BlockPredicateHelper.fastMatch(predicate, (class_2680)context.getParam(class_181.field_1224), () -> (class_2586)context.getParamOrNull(class_181.field_1228));
    }

    public static boolean fastMatch(class_4550 predicate, class_2680 blockstate, Supplier<class_2586> beGetter) {
        class_2586 blockentity;
        if (predicate == class_4550.field_20692) {
            return true;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        if (access.getTag() != null && !blockstate.method_26164(access.getTag())) {
            return false;
        }
        if (access.getBlocks() != null && !access.getBlocks().contains(blockstate.method_26204())) {
            return false;
        }
        if (!access.getProperties().method_22514(blockstate)) {
            return false;
        }
        return access.getNbt() == class_2105.field_9716 || (blockentity = beGetter.get()) != null && access.getNbt().method_9077((class_2520)blockentity.method_38242());
    }

    public static class_4550 fromJson(JsonElement jsonElement) {
        if (jsonElement != null && jsonElement.isJsonPrimitive()) {
            String id = jsonElement.getAsString();
            if ("*".equals(id)) {
                return class_4550.field_20692;
            }
            if (id.startsWith("#")) {
                class_6862 key = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(id.substring(1)));
                return new class_4550(key, null, class_4559.field_20736, class_2105.field_9716);
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(new class_2960(id));
            return new class_4550(null, Set.of(block), class_4559.field_20736, class_2105.field_9716);
        }
        return class_4550.method_22453((JsonElement)jsonElement);
    }

    public static JsonElement toJson(class_4550 predicate) {
        if (predicate == class_4550.field_20692) {
            return new JsonPrimitive("*");
        }
        return predicate.method_22452();
    }

    public static class_4550 fromNetwork(class_2540 pBuffer) {
        int blockCount = pBuffer.method_10816();
        if (blockCount == -1) {
            return class_4550.field_20692;
        }
        HashSet blocks = null;
        if (blockCount > 0) {
            blocks = Sets.newHashSet();
            for (int i = 0; i < blockCount; ++i) {
                blocks.add((class_2248)CommonProxy.readRegistryId(class_7923.field_41175, pBuffer));
            }
        }
        class_6862 tag = null;
        class_2960 tagId = CommonProxy.readNullableRL(pBuffer);
        if (tagId != null) {
            tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
        }
        class_4559 propertiesPredicate = PropertiesPredicateHelper.fromNetwork(pBuffer);
        class_2105 nbtPredicate = pBuffer.readBoolean() ? NBT_PREDICATE_DUMMY : class_2105.field_9716;
        return new class_4550(tag, (Set)blocks, propertiesPredicate, nbtPredicate);
    }

    public static void toNetwork(class_4550 predicate, class_2540 pBuffer) {
        if (predicate == class_4550.field_20692) {
            pBuffer.method_10804(-1);
            return;
        }
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        Set<class_2248> blocks = access.getBlocks();
        if (blocks == null) {
            pBuffer.method_10804(0);
        } else {
            pBuffer.method_10804(blocks.size());
            for (class_2248 block : blocks) {
                CommonProxy.writeRegistryId(class_7923.field_41175, block, pBuffer);
            }
        }
        class_2960 tagId = null;
        class_6862<class_2248> tag = access.getTag();
        if (tag != null) {
            tagId = tag.comp_327();
        }
        CommonProxy.writeNullableRL(tagId, pBuffer);
        PropertiesPredicateHelper.toNetwork(access.getProperties(), pBuffer);
        class_2105 nbtPredicate = access.getNbt();
        pBuffer.writeBoolean(nbtPredicate != class_2105.field_9716);
    }

    public static class_2680 anyBlockState(class_4550 predicate) {
        return BlockPredicateHelper.getShowcaseBlockStates(predicate).stream().findFirst().orElse(class_2246.field_10124.method_9564());
    }

    public static List<class_2680> getShowcaseBlockStates(class_4550 predicate) {
        try {
            return (List)CACHE.get((Object)predicate, () -> BlockPredicateHelper.getShowcaseBlockStates(predicate, ITERABLE_PROPERTIES));
        }
        catch (ExecutionException e) {
            return List.of();
        }
    }

    public static List<class_2680> getShowcaseBlockStates(class_4550 predicate, Collection<class_2769<?>> iterableProperties) {
        Set<class_2248> blocks = BlockPredicateHelper.getMatchedBlocks(predicate);
        if (blocks.isEmpty()) {
            return List.of();
        }
        ArrayList states = Lists.newArrayList();
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        class_4559 propertiesPredicate = access.getProperties();
        for (class_2248 block : blocks) {
            class_2680 state = block.method_9564();
            ArrayListMultimap propertyMap = ArrayListMultimap.create();
            for (class_2769 property : block.method_9595().method_11659()) {
                String name = property.method_11899();
                class_4559.class_4562 matcher = PropertiesPredicateHelper.findMatcher(propertiesPredicate, name);
                if (matcher != null) {
                    for (Comparable object : property.method_11898()) {
                        if (!matcher.method_22530(block.method_9595(), (class_2688)((class_2680)state.method_11657(property, object)))) continue;
                        propertyMap.put((Object)property, (Object)object);
                    }
                    continue;
                }
                if (!iterableProperties.contains(property)) continue;
                propertyMap.putAll((Object)property, (Iterable)property.method_11898());
            }
            Stream<Object> stream = Stream.of(state);
            for (Map.Entry e : propertyMap.asMap().entrySet()) {
                stream = stream.flatMap($ -> ((Collection)e.getValue()).stream().map(v -> (class_2680)$.method_11657((class_2769)e.getKey(), v)));
            }
            states.addAll(stream.toList());
        }
        return states;
    }

    public static List<class_2561> getTooltips(class_2680 state, class_4550 predicate) {
        if (predicate == class_4550.field_20692) {
            return List.of(class_2561.method_43471((String)"tip.lychee.anyBlock"));
        }
        ArrayList list = Lists.newArrayList();
        list.add(state.method_26204().method_9518());
        BlockPredicateAccess access = (BlockPredicateAccess)predicate;
        List<class_4559.class_4562> matchers = ((StatePropertiesPredicateAccess)access.getProperties()).getProperties();
        for (class_4559.class_4562 matcher : matchers) {
            class_5250 name = class_2561.method_43470((String)(matcher.method_22533() + "=")).method_27692(class_124.field_1080);
            JsonElement json = matcher.method_22529();
            if (json.isJsonPrimitive()) {
                name.method_10852((class_2561)class_2561.method_43470((String)json.getAsString()).method_27692(class_124.field_1068));
            } else {
                JsonObject object = json.getAsJsonObject();
                class_2689 definition = state.method_26204().method_9595();
                class_2769 property = definition.method_11663(matcher.method_22533());
                List sorted = null;
                boolean hasMin = object.has("min");
                boolean hasMax = object.has("max");
                Preconditions.checkArgument((hasMin || hasMax ? 1 : 0) != 0);
                if (!hasMin || !hasMax) {
                    sorted = property.method_11898().stream().sorted().toList();
                }
                String min = hasMin ? object.get("min").getAsString() : property.method_11901((Comparable)sorted.get(0));
                String max = hasMax ? object.get("max").getAsString() : property.method_11901((Comparable)sorted.get(sorted.size() - 1));
                name.method_10852((class_2561)class_2561.method_43470((String)min).method_27692(class_124.field_1068));
                name.method_10852((class_2561)class_2561.method_43470((String)"~").method_27692(class_124.field_1080));
                name.method_10852((class_2561)class_2561.method_43470((String)max).method_27692(class_124.field_1068));
            }
            list.add(name);
        }
        if (access.getNbt() != class_2105.field_9716) {
            list.add(class_2561.method_43471((String)"tip.lychee.nbtPredicate").method_27692(class_124.field_1080));
        }
        return list;
    }

    static {
        ITERABLE_PROPERTIES.addAll(List.of(class_2741.field_12521, class_2741.field_12556, class_2741.field_12497, class_2741.field_12482, class_2741.field_12550, class_2741.field_27220, class_2741.field_12505, class_2741.field_12511, class_2741.field_12484, class_2741.field_12548, class_2741.field_28716, class_2741.field_12537, class_2741.field_12494, class_2741.field_12541, class_2741.field_12536, class_2741.field_12543, class_2741.field_12538, class_2741.field_20432, class_2741.field_12513, class_2741.field_28063));
    }
}

