/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_2096;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_3518;
import net.minecraft.class_4550;
import net.minecraft.class_5819;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.Job;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BoundsHelper;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.CompoundAction;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.post.input.NBTPatch;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public class RandomSelect
extends PostAction
implements CompoundAction {
    public final PostAction[] entries;
    public final int[] weights;
    public final class_2096.class_2100 rolls;
    public final boolean canRepeat;
    public final boolean hidden;
    public final boolean preventSync;
    public final int totalWeight;
    public final int emptyWeight;

    public RandomSelect(PostAction[] entries, int[] weights, int totalWeight, int emptyWeight, class_2096.class_2100 rolls) {
        Preconditions.checkArgument((entries.length == weights.length ? 1 : 0) != 0);
        this.entries = entries;
        this.weights = weights;
        this.totalWeight = totalWeight;
        this.emptyWeight = emptyWeight;
        this.rolls = rolls;
        this.canRepeat = Arrays.stream(entries).allMatch(PostAction::canRepeat);
        this.hidden = Arrays.stream(entries).allMatch(PostAction::isHidden);
        this.preventSync = Arrays.stream(entries).allMatch(PostAction::preventSync);
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.RANDOM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        int i;
        if ((times *= IntBoundsHelper.random(this.rolls, ctx.getRandom())) == 0) {
            return;
        }
        ArrayList validActions = Lists.newArrayList();
        int[] validWeights = new int[this.entries.length];
        int totalWeights = 0;
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            PostAction entry = this.entries[i2];
            if (entry.checkConditions(recipe, ctx, 1) != 1) continue;
            validWeights[validActions.size()] = this.weights[i2];
            validActions.add(entry);
            totalWeights += this.weights[i2];
        }
        if (validActions.isEmpty()) {
            return;
        }
        totalWeights += this.emptyWeight;
        int[] childTimes = new int[validActions.size()];
        for (i = 0; i < times; ++i) {
            int index = this.getRandomEntry(ctx.getRandom(), validWeights, totalWeights);
            if (index < 0) continue;
            int n = index;
            childTimes[n] = childTimes[n] + 1;
        }
        for (i = 0; i < validActions.size(); ++i) {
            if (childTimes[i] <= 0) continue;
            ctx.runtime.jobs.push(new Job((PostAction)validActions.get(i), childTimes[i]));
        }
    }

    private int getRandomEntry(class_5819 random, int[] weights, int totalWeights) {
        int j = random.method_43048(totalWeights);
        for (int i = 0; i < weights.length; ++i) {
            if ((j -= weights[i]) >= 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
    }

    @Override
    public List<class_1799> getItemOutputs() {
        return Stream.of(this.entries).map(PostAction::getItemOutputs).flatMap(Collection::stream).toList();
    }

    @Override
    public List<class_4550> getBlockOutputs() {
        return Stream.of(this.entries).map(PostAction::getBlockOutputs).flatMap(Collection::stream).toList();
    }

    @Override
    public class_2561 getDisplayName() {
        if (this.entries.length == 1 && this.emptyWeight == 0) {
            return class_2561.method_43470((String)"%s \u00d7 %s".formatted(this.entries[0].getDisplayName().getString(), BoundsHelper.getDescription(this.rolls).getString()));
        }
        return CommonProxy.getCycledItem(List.of(this.entries), this.entries[0], 1000).getDisplayName();
    }

    @Override
    public boolean canRepeat() {
        return this.canRepeat;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean preventSync() {
        return this.preventSync;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        for (PostAction action : this.entries) {
            Preconditions.checkArgument((action.getClass() != NBTPatch.class ? 1 : 0) != 0, (Object)"NBTPatch cannot be used in RandomSelect");
            action.validate(recipe, patchContext);
        }
    }

    @Override
    public void getUsedPointers(ILycheeRecipe<?> recipe, Consumer<JsonPointer> consumer) {
        for (PostAction action : this.entries) {
            action.getUsedPointers(recipe, consumer);
        }
    }

    @Override
    public JsonElement provideJsonInfo(ILycheeRecipe<?> recipe, JsonPointer pointer, JsonObject recipeObject) {
        int i = 0;
        JsonArray array = new JsonArray();
        for (PostAction action : this.entries) {
            array.add(action.provideJsonInfo(recipe, pointer.append("entries/" + i), recipeObject));
            ++i;
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("entries", (JsonElement)array);
        return jsonObject;
    }

    @Override
    public Stream<PostAction> getChildActions() {
        return Arrays.stream(this.entries);
    }

    public static class Type
    extends PostActionType<RandomSelect> {
        @Override
        public RandomSelect fromJson(JsonObject o) {
            class_2096.class_2100 rolls;
            JsonArray array = o.getAsJsonArray("entries");
            int size = array.size();
            Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"entries can not be empty");
            PostAction[] entries = new PostAction[size];
            int[] weights = new int[size];
            for (int i = 0; i < size; ++i) {
                JsonObject e = array.get(i).getAsJsonObject();
                weights[i] = class_3518.method_15282((JsonObject)e, (String)"weight", (int)1);
                Preconditions.checkArgument((weights[i] > 0 ? 1 : 0) != 0, (Object)"weight should be greater than 0");
                entries[i] = PostAction.parse(e);
            }
            if (o.has("rolls")) {
                rolls = class_2096.class_2100.method_9056((JsonElement)o.get("rolls"));
                Objects.requireNonNull((Integer)rolls.method_9038(), "min");
                Objects.requireNonNull((Integer)rolls.method_9042(), "max");
            } else {
                rolls = IntBoundsHelper.ONE;
            }
            int emptyWeight = class_3518.method_15282((JsonObject)o, (String)"empty_weight", (int)0);
            Preconditions.checkArgument((emptyWeight >= 0 ? 1 : 0) != 0, (Object)"empty_weight should be greater or equal to 0");
            return new RandomSelect(entries, weights, IntStream.of(weights).sum() + emptyWeight, emptyWeight, rolls);
        }

        @Override
        public void toJson(RandomSelect action, JsonObject o) {
            JsonArray entries = new JsonArray(action.entries.length);
            int i = 0;
            for (PostAction entry : action.entries) {
                JsonObject entryJson = entry.toJson();
                if (action.weights[i] != 1) {
                    entryJson.addProperty("weight", (Number)action.weights[i]);
                }
                entries.add((JsonElement)entryJson);
                ++i;
            }
            o.add("entries", (JsonElement)entries);
            if (action.rolls != IntBoundsHelper.ONE) {
                o.add("rolls", action.rolls.method_9036());
            }
            if (action.emptyWeight != 0) {
                o.addProperty("empty_weight", (Number)action.emptyWeight);
            }
        }

        @Override
        public RandomSelect fromNetwork(class_2540 buf) {
            int totalWeight = buf.method_10816();
            int emptyWeight = buf.method_10816();
            int size = buf.method_10816();
            PostAction[] entries = new PostAction[size];
            int[] weights = new int[size];
            for (int i = 0; i < size; ++i) {
                weights[i] = buf.method_10816();
                entries[i] = PostAction.read(buf);
            }
            return new RandomSelect(entries, weights, totalWeight, emptyWeight, IntBoundsHelper.fromNetwork(buf));
        }

        @Override
        public void toNetwork(RandomSelect action, class_2540 buf) {
            buf.method_10804(action.totalWeight);
            buf.method_10804(action.emptyWeight);
            buf.method_10804((int)Stream.of(action.entries).filter(Predicate.not(PostAction::preventSync)).count());
            for (int i = 0; i < action.entries.length; ++i) {
                PostAction entry = action.entries[i];
                if (entry.preventSync()) continue;
                buf.method_10804(action.weights[i]);
                PostActionType<?> type = entry.getType();
                CommonProxy.writeRegistryId(LycheeRegistries.POST_ACTION, type, buf);
                type.toNetwork(entry, buf);
                entry.conditionsToNetwork(buf);
            }
            IntBoundsHelper.toNetwork(action.rolls, buf);
        }
    }
}

