/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3518;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class DamageItem
extends PostAction {
    public final int damage;
    public final Reference target;

    public DamageItem(int damage, Reference target) {
        this.damage = damage;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DAMAGE_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        class_1297 thisEntity = (class_1297)ctx.getParam(class_181.field_1226);
        for (Integer index : indexes) {
            Consumer<class_1309> onBroken;
            class_1799 stack = ctx.method_5438(index);
            if (!stack.method_7963()) {
                return;
            }
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
            stack = ctx.itemHolders.split(index, 1).get();
            int damage = this.damage;
            class_1309 living = null;
            class_1268 hand = null;
            if (thisEntity instanceof class_1309) {
                living = (class_1309)thisEntity;
                if (living.method_6047() == stack) {
                    hand = class_1268.field_5808;
                } else if (living.method_6079() == stack) {
                    hand = class_1268.field_5810;
                }
            }
            if (hand == null) {
                onBroken = $ -> {};
            } else {
                class_1268 hand2 = hand;
                onBroken = $ -> $.method_20236(hand2);
            }
            if (!stack.method_7970(damage, ctx.getRandom(), thisEntity instanceof class_3222 ? (class_3222)thisEntity : null)) continue;
            if (thisEntity instanceof class_1309) {
                onBroken.accept((class_1309)thisEntity);
            }
            class_1792 item = stack.method_7909();
            stack.method_7934(1);
            if (thisEntity instanceof class_1657) {
                ((class_1657)thisEntity).method_7259(class_3468.field_15383.method_14956((Object)item));
            }
            stack.method_7974(0);
        }
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((recipe.getItemIndexes(this.target).size() > 0 ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    public static class Type
    extends PostActionType<DamageItem> {
        @Override
        public DamageItem fromJson(JsonObject o) {
            return new DamageItem(class_3518.method_15282((JsonObject)o, (String)"damage", (int)1), Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(DamageItem action, JsonObject o) {
            if (action.damage != 1) {
                o.addProperty("damage", (Number)1);
            }
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public DamageItem fromNetwork(class_2540 buf) {
            return new DamageItem(buf.method_10816(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(DamageItem action, class_2540 buf) {
            buf.method_10804(action.damage);
            Reference.toNetwork(action.target, buf);
        }
    }
}

