/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post.input;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1869;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.Reference;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public class SetItem
extends PostAction {
    public final class_1799 stack;
    public final Reference target;

    public SetItem(class_1799 stack, Reference target) {
        this.stack = stack;
        this.target = target;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.SET_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        IntList indexes = recipe.getItemIndexes(this.target);
        for (Integer index : indexes) {
            class_2487 tag = ctx.method_5438(index).method_7969();
            class_1799 stack = this.path == null ? this.stack.method_7972() : class_1799.method_7915((class_2487)CommonProxy.jsonToTag(new JsonPointer(this.path).find((JsonElement)ctx.json)));
            ctx.method_5447(index, stack);
            if (tag != null && !stack.method_7960()) {
                ctx.method_5438(index).method_7948().method_10543(tag);
            }
            ctx.itemHolders.ignoreConsumptionFlags.set(index);
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return this.stack.method_7964();
    }

    @Override
    public List<class_1799> getItemOutputs() {
        return List.of(this.stack);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void validate(ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        Preconditions.checkArgument((recipe.getItemIndexes(this.target).size() > 0 ? 1 : 0) != 0, (String)"No target found for %s", (Object)this.target);
    }

    @Override
    public JsonElement provideJsonInfo(ILycheeRecipe<?> recipe, JsonPointer pointer, JsonObject recipeObject) {
        this.path = pointer.toString();
        return CommonProxy.tagToJson(this.stack.method_7953(new class_2487()));
    }

    public static class Type
    extends PostActionType<SetItem> {
        @Override
        public SetItem fromJson(JsonObject o) {
            class_1799 stack = "minecraft:air".equals(Objects.toString(class_2960.method_12829((String)o.get("item").getAsString()))) ? class_1799.field_8037 : class_1869.method_35228((JsonObject)o);
            return new SetItem(stack, Reference.fromJson(o, "target"));
        }

        @Override
        public void toJson(SetItem action, JsonObject o) {
            CommonProxy.itemstackToJson(action.stack, o);
            Reference.toJson(action.target, o, "target");
        }

        @Override
        public SetItem fromNetwork(class_2540 buf) {
            return new SetItem(buf.method_10819(), Reference.fromNetwork(buf));
        }

        @Override
        public void toNetwork(SetItem action, class_2540 buf) {
            buf.method_10793(action.stack);
            Reference.toNetwork(action.target, buf);
        }
    }
}

