/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2096;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.fragment.Fragments;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public abstract class LycheeRecipe<C extends LycheeContext>
extends ContextualHolder
implements ILycheeRecipe<C>,
class_1860<C> {
    private final class_2960 id;
    public boolean ghost;
    public boolean hideInRecipeViewer;
    @Nullable
    public String comment;
    public String group = "default";
    protected class_2096.class_2100 maxRepeats = class_2096.class_2100.field_9708;
    protected List<PostAction> actions = List.of();

    public LycheeRecipe(class_2960 id) {
        this.id = id;
        if (LycheeConfig.debug) {
            Lychee.LOGGER.debug("Construct recipe: {}", (Object)id);
        }
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 assemble(C inv, class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return class_1799.field_8037;
    }

    public void addPostAction(PostAction action) {
        Objects.requireNonNull(action);
        if (this.actions.isEmpty()) {
            this.actions = Lists.newArrayList();
        }
        if (!action.canRepeat()) {
            this.maxRepeats = IntBoundsHelper.ONE;
        }
        this.actions.add(action);
    }

    @Override
    public Stream<PostAction> getPostActions() {
        return this.actions.stream();
    }

    @Override
    public ContextualHolder getContextualHolder() {
        return this;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    public class_2096.class_2100 getMaxRepeats() {
        return this.maxRepeats;
    }

    public int getRandomRepeats(int max, C ctx) {
        int times = Integer.MAX_VALUE;
        if (!this.maxRepeats.method_9041()) {
            times = IntBoundsHelper.random(this.maxRepeats, ((LycheeContext)ctx).getRandom());
        }
        return Math.min(max, times);
    }

    @Override
    public boolean showInRecipeViewer() {
        return !this.hideInRecipeViewer;
    }

    public boolean tickOrApply(C ctx) {
        return true;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.method_8117().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("item_in")) {
            return IntList.of((int[])IntStream.range(0, size).toArray());
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("item_in")) {
            try {
                return IntList.of((int)pointer.getInt(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    @Override
    public Map<JsonPointer, List<PostAction>> getActionGroups() {
        return Map.of(POST, this.actions);
    }

    public abstract LycheeRecipeType<?, ?> getType();

    public abstract Serializer<?> getSerializer();

    public static abstract class Serializer<R extends LycheeRecipe<?>>
    implements class_1865<R> {
        public static final class_1856 EMPTY_INGREDIENT = class_1856.method_8101((class_1799[])new class_1799[]{class_1799.field_8037});
        protected final Function<class_2960, R> factory;

        public Serializer(Function<class_2960, R> factory) {
            this.factory = factory;
        }

        public static class_1856 parseIngredientOrAir(JsonElement element) {
            JsonObject object;
            if (element instanceof JsonObject && !(object = (JsonObject)element).has("type") && object.has("item") && "minecraft:air".equals(Objects.toString(class_2960.method_12829((String)object.get("item").getAsString())))) {
                return EMPTY_INGREDIENT;
            }
            return class_1856.method_52177((JsonElement)element);
        }

        public static void actionsToNetwork(class_2540 buf, List<PostAction> actions) {
            actions = actions.stream().filter(Predicate.not(PostAction::preventSync)).toList();
            buf.method_10804(actions.size());
            for (PostAction action : actions) {
                PostActionType<?> type = action.getType();
                CommonProxy.writeRegistryId(LycheeRegistries.POST_ACTION, type, buf);
                type.toNetwork(action, buf);
                action.conditionsToNetwork(buf);
            }
        }

        public static void actionsFromNetwork(class_2540 buf, Consumer<PostAction> consumer) {
            int size = buf.method_10816();
            for (int i = 0; i < size; ++i) {
                PostActionType<?> type = CommonProxy.readRegistryId(LycheeRegistries.POST_ACTION, buf);
                Object action = type.fromNetwork(buf);
                ((ContextualHolder)action).conditionsFromNetwork(buf);
                consumer.accept((PostAction)action);
            }
        }

        public final R fromJson(class_2960 pRecipeId, JsonObject jsonObject) {
            Fragments.INSTANCE.process((JsonElement)jsonObject);
            LycheeRecipe recipe = (LycheeRecipe)this.factory.apply(pRecipeId);
            recipe.hideInRecipeViewer = class_3518.method_15258((JsonObject)jsonObject, (String)"hide_in_viewer", (boolean)false);
            recipe.ghost = class_3518.method_15258((JsonObject)jsonObject, (String)"ghost", (boolean)false);
            recipe.comment = class_3518.method_15253((JsonObject)jsonObject, (String)"comment", null);
            recipe.group = class_3518.method_15253((JsonObject)jsonObject, (String)"group", (String)recipe.group);
            Preconditions.checkArgument((boolean)class_2960.method_20207((String)recipe.group), (String)"%s is not a valid ResourceLocation", (Object)recipe.group);
            recipe.parseConditions(jsonObject.get("contextual"));
            PostAction.parseActions(jsonObject.get("post"), recipe::addPostAction);
            this.fromJson(recipe, jsonObject);
            ILycheeRecipe.processActions(recipe, jsonObject);
            if (jsonObject.has("max_repeats")) {
                recipe.maxRepeats = class_2096.class_2100.method_9056((JsonElement)jsonObject.get("max_repeats"));
                Integer min = (Integer)recipe.maxRepeats.method_9038();
                Preconditions.checkArgument((min != null && min > 0 ? 1 : 0) != 0, (Object)"Min value of max_repeats should be greater than 0");
            }
            return (R)recipe;
        }

        public abstract void fromJson(R var1, JsonObject var2);

        public final R fromNetwork(class_2960 id, class_2540 buf) {
            try {
                LycheeRecipe recipe = (LycheeRecipe)this.factory.apply(id);
                if (LycheeConfig.debug) {
                    Lychee.LOGGER.debug("Read recipe: {}", (Object)id);
                }
                recipe.hideInRecipeViewer = buf.readBoolean();
                if (recipe.hideInRecipeViewer && !recipe.getType().requiresClient) {
                    return (R)recipe;
                }
                recipe.conditionsFromNetwork(buf);
                Serializer.actionsFromNetwork(buf, recipe::addPostAction);
                recipe.comment = buf.method_19772();
                recipe.group = buf.method_19772();
                this.fromNetwork(recipe, buf);
                return (R)recipe;
            }
            catch (Exception e) {
                Lychee.LOGGER.error("Exception while reading Lychee recipe: " + String.valueOf(id), (Throwable)e);
                return null;
            }
        }

        public abstract void fromNetwork(R var1, class_2540 var2);

        public final void toNetwork(class_2540 buf, R recipe) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Write recipe: {}", (Object)((LycheeRecipe)recipe).method_8114());
            }
            buf.writeBoolean(((LycheeRecipe)recipe).hideInRecipeViewer);
            if (((LycheeRecipe)recipe).hideInRecipeViewer && !((LycheeRecipe)recipe).getType().requiresClient) {
                return;
            }
            ((ContextualHolder)recipe).conditionsToNetwork(buf);
            Serializer.actionsToNetwork(buf, ((LycheeRecipe)recipe).actions);
            buf.method_10814(Strings.nullToEmpty((String)((LycheeRecipe)recipe).comment));
            buf.method_10814(((LycheeRecipe)recipe).group);
            this.toNetwork0(buf, recipe);
        }

        public abstract void toNetwork0(class_2540 var1, R var2);

        public class_2960 getRegistryName() {
            return class_7923.field_41189.method_10221((Object)this);
        }
    }
}

