/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe.type;

import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1662;
import net.minecraft.class_173;
import net.minecraft.class_176;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class LycheeRecipeType<C extends LycheeContext, T extends LycheeRecipe<C>>
implements class_3956<T> {
    public final class_2960 id;
    public class_2960 categoryId;
    public final Class<? extends T> clazz;
    public final class_176 contextParamSet;
    private boolean empty = true;
    protected List<T> recipes;
    public boolean requiresClient;
    public boolean compactInputs;
    public boolean canPreventConsumeInputs;
    public boolean hasStandaloneCategory = true;
    public static final class_2561 DEFAULT_PREVENT_TIP = class_2561.method_43471((String)"tip.lychee.preventDefault.default").method_27692(class_124.field_1054);

    public LycheeRecipeType(String name, Class<T> clazz, @Nullable class_176 contextParamSet) {
        this.categoryId = name.contains(":") ? new class_2960(name) : new class_2960("lychee", name);
        this.id = this.categoryId;
        this.clazz = clazz;
        this.contextParamSet = contextParamSet == null ? class_173.method_757((class_2960)this.id) : contextParamSet;
        Objects.requireNonNull(this.contextParamSet);
        RecipeTypes.ALL.add(this);
    }

    public String toString() {
        return this.id.toString();
    }

    public <D extends class_1263> Optional<T> tryMatch(class_1860<D> pRecipe, class_1937 pLevel, D pContainer) {
        LycheeRecipe lycheeRecipe = (LycheeRecipe)pRecipe;
        return pRecipe.method_8115(pContainer, pLevel) && lycheeRecipe.checkConditions(lycheeRecipe, (LycheeContext)pContainer, 1) > 0 ? Optional.of(lycheeRecipe) : Optional.empty();
    }

    public List<T> recipes() {
        return this.recipes;
    }

    public List<T> inViewerRecipes() {
        return CommonProxy.recipes(this).stream().filter(LycheeRecipe::showInRecipeViewer).toList();
    }

    public void updateEmptyState() {
        this.empty = this.recipes.isEmpty();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void buildCache() {
        Stream<LycheeRecipe> stream = CommonProxy.recipes(this).stream().filter($ -> !$.ghost);
        if (this.clazz.isAssignableFrom(Comparable.class)) {
            stream = stream.sorted();
        }
        this.recipes = stream.toList();
    }

    public Optional<T> findFirst(C ctx, class_1937 level) {
        return this.recipes.stream().flatMap($ -> this.tryMatch((class_1860)$, level, (class_1263)ctx).stream()).findFirst();
    }

    public class_2561 getPreventDefaultDescription(LycheeRecipe<?> recipe) {
        return DEFAULT_PREVENT_TIP;
    }

    public static class ValidItemCache {
        private IntSet validItems = IntSets.emptySet();

        public void buildCache(List<? extends class_1860<?>> recipes) {
            this.validItems = new IntAVLTreeSet(recipes.stream().flatMap($ -> $.method_8117().stream()).flatMapToInt($ -> $.method_8100().intStream()).toArray());
        }

        public boolean contains(class_1799 stack) {
            return this.validItems.contains(class_1662.method_7408((class_1799)stack));
        }
    }
}

