/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.crafting;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1714;
import net.minecraft.class_1715;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeLootContextParamSets;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.input.ItemHolderCollection;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.input.SetItem;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.crafting.CraftingContext;
import snownee.lychee.fragment.Fragments;
import snownee.lychee.mixin.CraftingMenuAccess;
import snownee.lychee.mixin.InventoryMenuAccess;
import snownee.lychee.mixin.ShapedRecipeAccess;
import snownee.lychee.mixin.TransientCraftingContainerAccess;
import snownee.lychee.util.Pair;
import snownee.lychee.util.json.JsonPointer;

public class ShapedCraftingRecipe
extends class_1869
implements ILycheeRecipe<CraftingContext> {
    public static final Cache<Class<?>, Function<class_8566, Pair<class_243, class_1657>>> CONTAINER_WORLD_LOCATOR = CacheBuilder.newBuilder().build();
    public static final Cache<Class<?>, Function<class_1703, Pair<class_243, class_1657>>> MENU_WORLD_LOCATOR = CacheBuilder.newBuilder().build();
    private static final Cache<class_8566, CraftingContext> CONTEXT_CACHE = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.SECONDS).build();
    private final ContextualHolder conditions = new ContextualHolder();
    public boolean ghost;
    public boolean hideInRecipeViewer;
    @Nullable
    public String comment;
    @Nullable
    public String pattern;
    private List<PostAction> actions = List.of();
    private List<PostAction> assembling = List.of();

    public ShapedCraftingRecipe(class_2960 id, String group, class_7710 category, int width, int height, class_2371<class_1856> ingredients, class_1799 result, boolean showNotification) {
        super(id, group, category, width, height, ingredients, result, showNotification);
    }

    @Nullable
    private static Pair<class_243, class_1657> getContainerContext(class_8566 container) {
        try {
            return (Pair)((Function)CONTAINER_WORLD_LOCATOR.get((Object)container.getClass(), () -> {
                for (Class clazz = container.getClass().getSuperclass(); clazz != class_8566.class; clazz = clazz.getSuperclass()) {
                    Function locator = (Function)CONTAINER_WORLD_LOCATOR.getIfPresent(clazz);
                    if (locator == null) continue;
                    return locator;
                }
                return container1 -> null;
            })).apply(container);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static CraftingContext makeContext(class_8566 container, class_1937 level, int matchX, int matchY, boolean mirror) {
        Pair<class_243, class_1657> pair = ShapedCraftingRecipe.getContainerContext(container);
        CraftingContext.Builder builder = new CraftingContext.Builder(level, matchX, matchY, mirror);
        if (pair != null) {
            builder.withOptionalParameter(class_181.field_24424, pair.getFirst());
            builder.withOptionalParameter(class_181.field_1226, (class_1297)pair.getSecond());
        }
        CraftingContext ctx = builder.create(LycheeLootContextParamSets.CRAFTING);
        CONTEXT_CACHE.put((Object)container, (Object)ctx);
        return ctx;
    }

    public boolean method_17728(class_8566 container, class_1937 level) {
        if (this.ghost) {
            return false;
        }
        if (level.field_9236) {
            return super.method_17728(container, level);
        }
        ShapedRecipeAccess access = (ShapedRecipeAccess)((Object)this);
        int i = 0;
        int j = 0;
        boolean mirror = false;
        boolean matched = false;
        block0: for (i = 0; i <= container.method_17398() - this.method_8150(); ++i) {
            for (j = 0; j <= container.method_17397() - this.method_8158(); ++j) {
                if (access.callMatches(container, i, j, true)) {
                    matched = true;
                    break block0;
                }
                if (this.method_8150() <= 1 || !access.callMatches(container, i, j, false)) continue;
                matched = true;
                mirror = true;
                break block0;
            }
        }
        if (!matched) {
            return false;
        }
        CraftingContext ctx = ShapedCraftingRecipe.makeContext(container, level, i, j, mirror);
        boolean bl = matched = this.conditions.checkConditions(this, ctx, 1) > 0;
        if (matched) {
            class_1799 result = this.method_8110(level.method_30349()).method_7972();
            class_2371 ingredients = this.method_8117();
            class_1799[] items = new class_1799[ingredients.size() + 1];
            int startIndex = container.method_17398() * ctx.matchY + ctx.matchX;
            int k = 0;
            for (i = 0; i < this.method_8158(); ++i) {
                for (j = 0; j < this.method_8150(); ++j) {
                    items[k] = container.method_5438(startIndex + container.method_17398() * i + (ctx.mirror ? this.method_8150() - j : j));
                    if (!items[k].method_7960()) {
                        items[k] = items[k].method_7972();
                        items[k].method_7939(1);
                    }
                    ++k;
                }
            }
            items[ingredients.size()] = result;
            ctx.itemHolders = ItemHolderCollection.Inventory.of(ctx, items);
        }
        return matched;
    }

    public class_1799 method_17727(class_8566 container, class_5455 registryAccess) {
        CraftingContext ctx = (CraftingContext)CONTEXT_CACHE.getIfPresent((Object)container);
        if (ctx == null) {
            return class_1799.field_8037;
        }
        ctx.enqueueActions(this.assembling.stream(), 1, true);
        ctx.runtime.run(this, ctx);
        return ctx.method_5438(ctx.method_5439() - 1);
    }

    public class_2371<class_1799> getRemainingItems(class_8566 container) {
        class_2371 items = super.method_8111((class_1263)container);
        CraftingContext ctx = (CraftingContext)CONTEXT_CACHE.getIfPresent((Object)container);
        if (ctx == null) {
            return items;
        }
        this.applyPostActions(ctx, 1);
        int startIndex = container.method_17398() * ctx.matchY + ctx.matchX;
        int k = 0;
        for (int i = 0; i < this.method_8158(); ++i) {
            for (int j = 0; j < this.method_8150(); ++j) {
                if (ctx.itemHolders.ignoreConsumptionFlags.get(k)) {
                    items.set(startIndex + container.method_17398() * i + (ctx.mirror ? this.method_8150() - j : j), (Object)ctx.method_5438(k));
                }
                ++k;
            }
        }
        return items;
    }

    @Override
    public JsonPointer defaultItemPointer() {
        return RESULT;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.method_8117().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("result")) {
            return IntList.of((int)size);
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("key")) {
            String key = pointer.getString(1);
            if (key.length() != 1) {
                return IntList.of();
            }
            IntArrayList list = IntArrayList.of();
            int cp = key.codePointAt(0);
            int l = this.pattern.length();
            for (int i = 0; i < l; ++i) {
                if (cp != this.pattern.codePointAt(i)) continue;
                list.add(i);
            }
            return list;
        }
        return IntList.of((int)size);
    }

    @Override
    public Stream<PostAction> getPostActions() {
        return this.actions.stream();
    }

    @Override
    public Stream<PostAction> getAllActions() {
        return Stream.concat(this.getPostActions(), this.assembling.stream());
    }

    @Override
    public ContextualHolder getContextualHolder() {
        return this.conditions;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void addPostAction(PostAction action) {
        Objects.requireNonNull(action);
        if (action instanceof SetItem) {
            SetItem setItem = (SetItem)action;
            if (this.getItemIndexes(setItem.target).contains(this.method_8117().size())) {
                throw new JsonSyntaxException("Can't set item to the result in \"post\", use \"assembling\".");
            }
        }
        if (this.actions.isEmpty()) {
            this.actions = Lists.newArrayList();
        }
        this.actions.add(action);
    }

    public void addAssemblingAction(PostAction action) {
        Objects.requireNonNull(action);
        if (action instanceof SetItem) {
            SetItem setItem = (SetItem)action;
            IntList intList = this.getItemIndexes(setItem.target);
            if (!intList.isEmpty() && !intList.contains(this.method_8117().size())) {
                throw new JsonSyntaxException("Can't set item to the ingredients in \"assembling\", use \"post\".");
            }
        }
        if (this.assembling.isEmpty()) {
            this.assembling = Lists.newArrayList();
        }
        this.assembling.add(action);
    }

    @Override
    public boolean showInRecipeViewer() {
        return !this.hideInRecipeViewer;
    }

    public class_1865<?> method_8119() {
        return RecipeSerializers.CRAFTING;
    }

    public boolean method_8118() {
        return !this.conditions.getConditions().isEmpty() || !this.assembling.isEmpty();
    }

    @Override
    public boolean isActionPath(JsonPointer pointer) {
        if (pointer.isRoot()) {
            return false;
        }
        String token = pointer.getString(0);
        return "assembling".equals(token) || "post".equals(token);
    }

    @Override
    public Map<JsonPointer, List<PostAction>> getActionGroups() {
        return Map.of(POST, this.actions, new JsonPointer("/assembling"), this.assembling);
    }

    static {
        CONTAINER_WORLD_LOCATOR.put(class_1715.class, container -> {
            TransientCraftingContainerAccess access = (TransientCraftingContainerAccess)container;
            class_1703 menu = access.getMenu();
            try {
                return (Pair)((Function)MENU_WORLD_LOCATOR.get(menu.getClass(), () -> {
                    for (Class<?> clazz = menu.getClass().getSuperclass(); clazz != class_1703.class; clazz = clazz.getSuperclass()) {
                        Function locator = (Function)MENU_WORLD_LOCATOR.getIfPresent(clazz);
                        if (locator == null) continue;
                        return locator;
                    }
                    return menu1 -> null;
                })).apply(menu);
            }
            catch (ExecutionException e) {
                return null;
            }
        });
        MENU_WORLD_LOCATOR.put(class_1714.class, menu -> {
            CraftingMenuAccess access = (CraftingMenuAccess)menu;
            return Pair.of((class_243)access.getAccess().method_17396((level, pos) -> class_243.method_24953((class_2382)pos), (Object)access.getPlayer().method_19538()), access.getPlayer());
        });
        MENU_WORLD_LOCATOR.put(class_1723.class, menu -> {
            InventoryMenuAccess access = (InventoryMenuAccess)menu;
            return Pair.of(access.getOwner().method_19538(), access.getOwner());
        });
    }

    public static class Serializer
    implements class_1865<ShapedCraftingRecipe> {
        private static ShapedCraftingRecipe fromNormal(class_1869 recipe) {
            return new ShapedCraftingRecipe(recipe.method_8114(), recipe.method_8112(), recipe.method_45441(), recipe.method_8150(), recipe.method_8158(), (class_2371<class_1856>)recipe.method_8117(), ((ShapedRecipeAccess)recipe).getResult(), recipe.method_49188());
        }

        public ShapedCraftingRecipe fromJson(class_2960 id, JsonObject jsonObject) {
            Fragments.INSTANCE.process((JsonElement)jsonObject);
            ShapedCraftingRecipe recipe = Serializer.fromNormal((class_1869)class_1865.field_9035.method_8121(id, jsonObject));
            recipe.hideInRecipeViewer = class_3518.method_15258((JsonObject)jsonObject, (String)"hide_in_viewer", (boolean)false);
            recipe.ghost = class_3518.method_15258((JsonObject)jsonObject, (String)"ghost", (boolean)false);
            recipe.comment = class_3518.method_15253((JsonObject)jsonObject, (String)"comment", null);
            StringBuilder sb = new StringBuilder();
            StreamSupport.stream(jsonObject.getAsJsonArray("pattern").spliterator(), false).map(JsonElement::getAsString).forEach(sb::append);
            recipe.pattern = sb.toString();
            recipe.conditions.parseConditions(jsonObject.get("contextual"));
            PostAction.parseActions(jsonObject.get("post"), recipe::addPostAction);
            PostAction.parseActions(jsonObject.get("assembling"), recipe::addAssemblingAction);
            ILycheeRecipe.processActions(recipe, jsonObject);
            return recipe;
        }

        public ShapedCraftingRecipe fromNetwork(class_2960 id, class_2540 buf) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Read recipe: {}", (Object)id);
            }
            ShapedCraftingRecipe recipe = Serializer.fromNormal((class_1869)class_1865.field_9035.method_8122(id, buf));
            recipe.hideInRecipeViewer = buf.readBoolean();
            if (recipe.hideInRecipeViewer) {
                return recipe;
            }
            recipe.conditions.conditionsFromNetwork(buf);
            LycheeRecipe.Serializer.actionsFromNetwork(buf, recipe::addPostAction);
            recipe.comment = buf.method_19772();
            recipe.pattern = buf.method_19772();
            return recipe;
        }

        public void toNetwork(class_2540 buf, ShapedCraftingRecipe recipe) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Write recipe: {}", (Object)recipe.method_8114());
            }
            class_1865.field_9035.method_8124(buf, (class_1860)recipe);
            buf.writeBoolean(recipe.hideInRecipeViewer);
            if (recipe.hideInRecipeViewer) {
                return;
            }
            recipe.conditions.conditionsToNetwork(buf);
            LycheeRecipe.Serializer.actionsToNetwork(buf, recipe.actions);
            buf.method_10814(Strings.nullToEmpty((String)recipe.comment));
            buf.method_10814(Strings.nullToEmpty((String)recipe.pattern));
        }
    }
}

