/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.item_inside;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_4550;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ItemShapelessRecipe;
import snownee.lychee.core.recipe.LycheeCounter;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.item_inside.ItemInsideRecipeType;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.RecipeMatcher;

public class ItemInsideRecipe
extends ItemShapelessRecipe<ItemInsideRecipe>
implements BlockKeyRecipe<ItemInsideRecipe> {
    private int time;
    protected class_4550 block;
    private boolean special;

    public ItemInsideRecipe(class_2960 id) {
        super(id);
    }

    @Override
    public LycheeRecipe.Serializer<?> getSerializer() {
        return RecipeSerializers.ITEM_INSIDE;
    }

    @Override
    public LycheeRecipeType<?, ?> getType() {
        return RecipeTypes.ITEM_INSIDE;
    }

    public int getTime() {
        return this.time;
    }

    @Override
    public boolean tickOrApply(ItemShapelessContext ctx) {
        LycheeCounter entity = (LycheeCounter)ctx.getParam(class_181.field_1226);
        if (entity.lychee$getCount() >= this.time) {
            entity.lychee$setRecipeId(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(ItemShapelessContext ctx, class_1937 pLevel) {
        int[] amount;
        if (ctx.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateHelper.fastMatch(this.block, ctx)) {
            return false;
        }
        List<class_1542> itemEntities = ctx.itemEntities.stream().filter($ -> this.ingredients.stream().anyMatch(ingredient -> ingredient.method_8093($.method_6983()))).limit(27L).toList();
        List<class_1799> items = itemEntities.stream().map(class_1542::method_6983).toList();
        Optional<RecipeMatcher<class_1799>> match = RecipeMatcher.findMatches(items, this.ingredients, amount = items.stream().mapToInt(class_1799::method_7947).toArray());
        if (match.isEmpty()) {
            return false;
        }
        ctx.filteredItems = itemEntities;
        ctx.setMatch(match.get());
        return true;
    }

    @Override
    public class_4550 getBlock() {
        return this.block;
    }

    @Nullable
    public ItemInsideRecipeType.Cache buildCache(Object2FloatMap<class_1792> itemWeights, List<ItemInsideRecipe> specialRecipes) {
        boolean bl = this.special = !this.method_8117().stream().anyMatch(CommonProxy::isSimpleIngredient);
        if (this.special) {
            specialRecipes.add(this);
            return null;
        }
        List<Set<class_1792>> mappedIngredients = this.method_8117().stream().map(class_1856::method_8105).map($ -> {
            HashSet items = Sets.newHashSet();
            float weight = 1.0f / (float)((class_1799[])$).length;
            for (class_1799 stack : $) {
                items.add(stack.method_7909());
                itemWeights.merge((Object)stack.method_7909(), weight, Float::sum);
            }
            return items;
        }).toList();
        return new ItemInsideRecipeType.Cache(this, mappedIngredients);
    }

    public boolean method_8118() {
        return this.special;
    }

    public static class Serializer
    extends ItemShapelessRecipe.Serializer<ItemInsideRecipe> {
        public Serializer() {
            super(ItemInsideRecipe::new);
        }

        @Override
        public void fromJson(ItemInsideRecipe pRecipe, JsonObject pSerializedRecipe) {
            super.fromJson(pRecipe, pSerializedRecipe);
            pRecipe.time = class_3518.method_15282((JsonObject)pSerializedRecipe, (String)"time", (int)0);
            pRecipe.block = BlockPredicateHelper.fromJson(pSerializedRecipe.get("block_in"));
            Preconditions.checkArgument((!pRecipe.ingredients.isEmpty() ? 1 : 0) != 0, (Object)"Ingredients cannot be empty");
        }

        @Override
        public void fromNetwork(ItemInsideRecipe pRecipe, class_2540 pBuffer) {
            super.fromNetwork(pRecipe, pBuffer);
            pRecipe.time = pBuffer.method_10816();
            pRecipe.block = BlockPredicateHelper.fromNetwork(pBuffer);
        }

        @Override
        public void toNetwork0(class_2540 pBuffer, ItemInsideRecipe pRecipe) {
            super.toNetwork0(pBuffer, pRecipe);
            pBuffer.method_10804(pRecipe.time);
            BlockPredicateHelper.toNetwork(pRecipe.block, pBuffer);
        }
    }
}

