/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.item_inside;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.core.ItemShapelessContext;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.recipe.LycheeCounter;
import snownee.lychee.core.recipe.type.ItemShapelessRecipeType;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.item_inside.ItemInsideRecipe;
import snownee.lychee.util.CommonProxy;

public class ItemInsideRecipeType
extends LycheeRecipeType<ItemShapelessContext, ItemInsideRecipe> {
    private List<ItemInsideRecipe> specialRecipes = Lists.newArrayList();
    private Multimap<class_1792, ItemInsideRecipe> recipesByItem = ArrayListMultimap.create();

    public ItemInsideRecipeType(String name, Class<ItemInsideRecipe> clazz, @Nullable class_176 paramSet) {
        super(name, clazz, paramSet);
        this.compactInputs = true;
    }

    @Override
    public void buildCache() {
        this.specialRecipes.clear();
        this.recipesByItem.clear();
        super.buildCache();
        Object2FloatOpenHashMap itemCount = new Object2FloatOpenHashMap();
        List caches = this.recipes.stream().map(arg_0 -> this.lambda$buildCache$0((Object2FloatMap)itemCount, arg_0)).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        List<class_1792> sorted = itemCount.object2FloatEntrySet().stream().sorted((a, b) -> Float.compare(b.getFloatValue(), a.getFloatValue())).map(Map.Entry::getKey).toList();
        for (class_1792 item : sorted) {
            caches.removeIf(cache -> {
                if (cache.ingredients.stream().anyMatch($ -> $.contains(item))) {
                    this.recipesByItem.put((Object)item, (Object)cache.recipe);
                    return cache.ingredients.stream().peek($ -> $.remove(item)).anyMatch(Set::isEmpty);
                }
                return false;
            });
        }
    }

    public void process(class_1297 entity, class_1799 stack, class_2338 pos, class_243 origin) {
        Collection recipes;
        if (this.isEmpty()) {
            return;
        }
        MutableObject prevRecipeId = new MutableObject();
        if (entity instanceof LycheeCounter) {
            prevRecipeId.setValue((Object)((LycheeCounter)entity).lychee$getRecipeId());
            ((LycheeCounter)entity).lychee$setRecipeId(null);
        }
        if ((recipes = this.recipesByItem.get((Object)stack.method_7909())).isEmpty() && this.specialRecipes.isEmpty()) {
            return;
        }
        class_1937 level = entity.method_37908();
        class_2680 blockstate = level.method_8320(pos);
        class_2248 block = blockstate.method_26204();
        List items = level.method_8390(class_1542.class, class_238.method_30048((class_243)origin, (double)3.0, (double)3.0, (double)3.0), $ -> {
            if ($.method_31481()) {
                return false;
            }
            return pos.equals((Object)$.method_24515()) || level.method_8320($.method_24515()).method_27852(block);
        });
        ItemShapelessContext.Builder ctxBuilder = new ItemShapelessContext.Builder(level, items);
        ctxBuilder.withParameter(class_181.field_24424, CommonProxy.clampPos(origin, pos));
        ctxBuilder.withParameter(class_181.field_1226, entity);
        ctxBuilder.withParameter(class_181.field_1224, blockstate);
        ctxBuilder.withParameter(LycheeLootContextParams.BLOCK_POS, pos);
        LycheeContext ctx = ctxBuilder.create(this.contextParamSet);
        ItemInsideRecipe prevRecipe = Optional.ofNullable((class_2960)prevRecipeId.getValue()).map(CommonProxy::recipe).filter($ -> $.method_17716() == this).orElse(null);
        Iterable iterable = Iterables.concat((Iterable)recipes, this.specialRecipes);
        if (prevRecipe != null) {
            iterable = Iterables.concat(List.of(prevRecipe), (Iterable)Iterables.filter((Iterable)iterable, $ -> $ != prevRecipe));
        }
        ItemShapelessRecipeType.process(this, iterable, ctx, arg_0 -> ItemInsideRecipeType.lambda$process$8(entity, prevRecipeId, (ItemShapelessContext)ctx, arg_0));
    }

    private static /* synthetic */ boolean lambda$process$8(class_1297 entity, MutableObject prevRecipeId, ItemShapelessContext ctx, ItemInsideRecipe recipe) {
        ((LycheeCounter)entity).lychee$update((class_2960)prevRecipeId.getValue(), recipe);
        return recipe.tickOrApply(ctx);
    }

    private /* synthetic */ Cache lambda$buildCache$0(Object2FloatMap itemCount, ItemInsideRecipe $) {
        return $.buildCache((Object2FloatMap<class_1792>)itemCount, this.specialRecipes);
    }

    record Cache(ItemInsideRecipe recipe, List<Set<class_1792>> ingredients) {
    }
}

