/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.tropheusj.dripstone_fluid_lib.DripstoneInteractingFluid;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_2968;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.minecraft.class_5362;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.Mod;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.LycheeTags;
import snownee.lychee.PostActionTypes;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.compat.fabric_recipe_api.AlwaysTrueIngredient;
import snownee.lychee.core.contextual.CustomCondition;
import snownee.lychee.core.post.CustomAction;
import snownee.lychee.core.post.Explode;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.dripstone_dripping.DripstoneRecipeMod;
import snownee.lychee.interaction.InteractionRecipeMod;
import snownee.lychee.mixin.RecipeManagerAccess;
import snownee.lychee.util.ClientProxy;

@Mod(value="lychee")
public class CommonProxy
implements ModInitializer {
    public static final Event<CustomActionListener> CUSTOM_ACTION_EVENT = EventFactory.createArrayBacked(CustomActionListener.class, listeners -> (id, action, recipe, patchContext) -> {
        for (CustomActionListener listener : listeners) {
            if (!listener.on(id, action, recipe, patchContext)) continue;
            return true;
        }
        return false;
    });
    public static final Event<CustomConditionListener> CUSTOM_CONDITION_EVENT = EventFactory.createArrayBacked(CustomConditionListener.class, listeners -> (id, condition) -> {
        for (CustomConditionListener listener : listeners) {
            if (!listener.on(id, condition)) continue;
            return true;
        }
        return false;
    });
    private static final Random RANDOM = new Random();
    public static boolean hasKiwi = CommonProxy.isModLoaded("kiwi");
    public static boolean hasDFLib = CommonProxy.isModLoaded("dripstone_fluid_lib");
    private static class_1863 recipeManager;

    public static void dropItemStack(class_1937 pLevel, double pX, double pY, double pZ, class_1799 pStack, @Nullable Consumer<class_1542> extraStep) {
        while (!pStack.method_7960()) {
            class_1542 itementity = new class_1542(pLevel, pX + RANDOM.nextGaussian() * 0.1 - 0.05, pY, pZ + RANDOM.nextGaussian() * 0.1 - 0.05, pStack.method_7971(Math.min(RANDOM.nextInt(21) + 10, pStack.method_7914())));
            itementity.method_18800(RANDOM.nextGaussian() * 0.05 - 0.025, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05 - 0.025);
            if (extraStep != null) {
                extraStep.accept(itementity);
            }
            pLevel.method_8649((class_1297)itementity);
        }
    }

    public static String makeDescriptionId(String pType, @Nullable class_2960 pId) {
        return pId == null ? pType + ".unregistered_sadface" : pType + "." + CommonProxy.wrapNamespace(pId.method_12836()) + "." + pId.method_12832().replace('/', '.');
    }

    public static String wrapNamespace(String modid) {
        return "minecraft".equals(modid) ? "lychee" : modid;
    }

    public static class_5250 white(CharSequence s) {
        return class_2561.method_43470((String)s.toString()).method_27692(class_124.field_1068);
    }

    public static String chance(float chance) {
        return ((double)chance < 0.01 ? "<1" : String.valueOf((int)(chance * 100.0f))) + "%";
    }

    public static String capitaliseAllWords(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static <T> T getCycledItem(List<T> list, T fallback, int interval) {
        if (list.isEmpty()) {
            return fallback;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        long index = System.currentTimeMillis() / (long)interval % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    public static class_2960 readNullableRL(class_2540 buf) {
        String string = buf.method_19772();
        if (string.isEmpty()) {
            return null;
        }
        return new class_2960(string);
    }

    public static void writeNullableRL(class_2960 rl, class_2540 buf) {
        if (rl == null) {
            buf.method_10814("");
        } else {
            buf.method_10814(rl.toString());
        }
    }

    public static class_1269 interactionResult(Boolean bool) {
        if (bool == null) {
            return class_1269.field_5811;
        }
        return bool != false ? class_1269.field_5812 : class_1269.field_5814;
    }

    public static <T> T readRegistryId(class_2378<T> registry, class_2540 buf) {
        return (T)registry.method_10200(buf.method_10816());
    }

    public static <T> void writeRegistryId(class_2378<T> registry, T entry, class_2540 buf) {
        buf.method_10804(registry.method_10206(entry));
    }

    public static class_1863 recipeManager() {
        if (recipeManager == null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.trace("Early loading recipes..");
            }
            recipeManager = class_310.method_1551().method_1562().method_2877();
        }
        return recipeManager;
    }

    public static void setRecipeManager(class_1863 recipeManager, boolean fromServer) {
        if (!fromServer && CommonProxy.isPhysicalClient() && ClientProxy.isSinglePlayer()) {
            return;
        }
        CommonProxy.recipeManager = recipeManager;
        if (LycheeConfig.debug) {
            Lychee.LOGGER.trace("Setting recipe manager..");
        }
    }

    public static class_1860<?> recipe(class_2960 id) {
        return CommonProxy.recipeManager().method_8130(id).orElse(null);
    }

    public static <T extends class_1860<?>> Collection<T> recipes(class_3956<T> type) {
        return ((RecipeManagerAccess)CommonProxy.recipeManager()).callByType(type).values();
    }

    public static class_2338 getOnPos(class_1297 entity) {
        int i = class_3532.method_15357((double)entity.method_23317());
        int j = class_3532.method_15357((double)(entity.method_23318() - 0.05));
        int k = class_3532.method_15357((double)entity.method_23321());
        class_2338 blockpos = new class_2338(i, j, k);
        if (entity.method_37908().method_22347(blockpos)) {
            class_2338 blockpos1 = blockpos.method_10074();
            class_2680 blockstate = entity.method_37908().method_8320(blockpos1);
            if (CommonProxy.collisionExtendsVertically(blockstate, entity.method_37908(), blockpos1, entity)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public static boolean collisionExtendsVertically(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        return state.method_26164(class_3481.field_16584) || state.method_26164(class_3481.field_15504) || state.method_26204() instanceof class_2349;
    }

    public static class_243 clampPos(class_243 origin, class_2338 pos) {
        double x = CommonProxy.clamp(origin.field_1352, pos.method_10263());
        double y = CommonProxy.clamp(origin.field_1351, pos.method_10264());
        double z = CommonProxy.clamp(origin.field_1350, pos.method_10260());
        if (x == origin.field_1352 && y == origin.field_1351 && z == origin.field_1350) {
            return origin;
        }
        return new class_243(x, y, z);
    }

    private static double clamp(double v, int target) {
        if (v < (double)target) {
            return target;
        }
        if (v >= (double)(target + 1)) {
            return (double)target + 0.999999;
        }
        return v;
    }

    public static <T> List<T> tagElements(class_2378<T> registry, class_6862<T> tag) {
        return Streams.stream((Iterable)registry.method_40286(tag)).map(class_6880::comp_349).toList();
    }

    public static boolean isSimpleIngredient(class_1856 ingredient) {
        return !ingredient.requiresTesting();
    }

    public static class_2338 parseOffset(JsonObject o) {
        int x = class_3518.method_15282((JsonObject)o, (String)"offsetX", (int)0);
        int y = class_3518.method_15282((JsonObject)o, (String)"offsetY", (int)0);
        int z = class_3518.method_15282((JsonObject)o, (String)"offsetZ", (int)0);
        class_2338 offset = class_2338.field_10980;
        if (x != 0 || y != 0 || z != 0) {
            offset = new class_2338(x, y, z);
        }
        return offset;
    }

    public static boolean isPhysicalClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static void itemstackToJson(class_1799 stack, JsonObject jsonObject) {
        jsonObject.addProperty("item", class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
        if (stack.method_7985()) {
            jsonObject.addProperty("nbt", stack.method_7969().toString());
        }
        if (stack.method_7947() > 1) {
            jsonObject.addProperty("count", (Number)stack.method_7947());
        }
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static JsonObject tagToJson(class_2487 tag) {
        return ((JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)tag)).getAsJsonObject();
    }

    public static class_2487 jsonToTag(JsonElement json) {
        if (json.isJsonObject()) {
            return (class_2487)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, json);
        }
        try {
            return class_2522.method_10718((String)json.getAsString());
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void registerCustomActionListener(CustomActionListener listener) {
        CUSTOM_ACTION_EVENT.register((Object)listener);
    }

    public static void registerCustomConditionListener(CustomConditionListener listener) {
        CUSTOM_CONDITION_EVENT.register((Object)listener);
    }

    public static void postCustomActionEvent(String id, CustomAction action, ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        ((CustomActionListener)CUSTOM_ACTION_EVENT.invoker()).on(id, action, recipe, patchContext);
    }

    public static void postCustomConditionEvent(String id, CustomCondition condition) {
        ((CustomConditionListener)CUSTOM_CONDITION_EVENT.invoker()).on(id, condition);
    }

    public static IngredientInfo.Type getIngredientType(class_1856 ingredient) {
        if (ingredient == LycheeRecipe.Serializer.EMPTY_INGREDIENT) {
            return IngredientInfo.Type.AIR;
        }
        CustomIngredient customIngredient = ingredient.getCustomIngredient();
        if (customIngredient != null && customIngredient.getSerializer() == AlwaysTrueIngredient.SERIALIZER) {
            return IngredientInfo.Type.ANY;
        }
        return IngredientInfo.Type.NORMAL;
    }

    public static boolean hasModdedDripParticle(class_3610 fluid) {
        return hasDFLib && fluid.method_15772() instanceof DripstoneInteractingFluid;
    }

    public static class_2396<class_2388> registerParticleType(class_2394.class_2395<class_2388> deserializer) {
        return FabricParticleTypes.complex(deserializer);
    }

    public static class_1799 dispensePlacement(class_2342 pSource, class_1799 pStack, class_2350 direction) {
        class_1792 class_17922 = pStack.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return pStack;
        }
        class_1747 item = (class_1747)class_17922;
        class_2338 blockpos = pSource.method_10122().method_10093(direction);
        class_2680 state = pSource.method_10207().method_8320(blockpos);
        if (class_2346.method_10128((class_2680)state)) {
            item.method_7712((class_1750)new class_2968((class_1937)pSource.method_10207(), blockpos, direction, pStack, direction));
        }
        return pStack;
    }

    public static void explode(Explode action, class_3218 level, class_243 pos, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 damageCalculator, float radius) {
        class_1927 explosion = new class_1927((class_1937)level, entity, damageSource, damageCalculator, pos.field_1352, pos.field_1351, pos.field_1350, radius, action.fire, action.blockInteraction);
        explosion.method_8348();
        explosion.method_8350(true);
        if (!explosion.method_46667()) {
            explosion.method_8352();
        }
        for (class_3222 player : level.method_18456()) {
            if (!(player.method_5707(pos) < 4096.0)) continue;
            player.field_13987.method_14364((class_2596)new class_2664(pos.field_1352, pos.field_1351, pos.field_1350, radius, explosion.method_8346(), (class_243)explosion.method_8351().get(player)));
        }
    }

    public void onInitialize() {
        if (hasKiwi) {
            FabricLoader.getInstance().getModContainer("kiwi").map(ModContainer::getMetadata).map(ModMetadata::getVersion).ifPresent(version -> {
                try {
                    Version minVersion = Version.parse((String)"11.1.1");
                    if (minVersion.compareTo(version) > 0) {
                        throw new RuntimeException("Kiwi version is too low! Please update to at least 11.1.1. You have %s".formatted(version));
                    }
                }
                catch (VersionParsingException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        RecipeTypes.init();
        LycheeTags.init();
        LycheeRegistries.init();
        ContextualConditionTypes.init();
        PostActionTypes.init();
        RecipeSerializers.init();
        CustomIngredientSerializer.register(AlwaysTrueIngredient.SERIALIZER);
        UseBlockCallback.EVENT.register(InteractionRecipeMod::useItemOn);
        AttackBlockCallback.EVENT.register(InteractionRecipeMod::clickItemOn);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("lychee", "dripstone_dripping"), DripstoneRecipeMod.DRIPSTONE_DRIPPING);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("lychee", "dripstone_falling"), DripstoneRecipeMod.DRIPSTONE_FALLING);
        class_2378.method_10230((class_2378)class_7923.field_41180, (class_2960)new class_2960("lychee", "dripstone_splash"), DripstoneRecipeMod.DRIPSTONE_SPLASH);
    }

    public static interface CustomActionListener {
        public boolean on(String var1, CustomAction var2, ILycheeRecipe<?> var3, ILycheeRecipe.NBTPatchContext var4);
    }

    public static interface CustomConditionListener {
        public boolean on(String var1, CustomCondition var2);
    }
}

