/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.mru.packing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.imb11.mru.packing.resource.UnpackedResourcePack;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unpacker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"MRU/ResourceUnpacker");
    private static final HashMap<Class<?>, UnpackedResourcePack> PACKS = new HashMap();
    private static boolean unpacked = false;

    public static void register(Class<?> location, UnpackedResourcePack pack) {
        PACKS.put(location, pack);
        Unpacker.unpack(location, pack);
    }

    @ApiStatus.Internal
    public static ArrayList<UnpackedResourcePack> getPacks() {
        return new ArrayList<UnpackedResourcePack>(PACKS.values());
    }

    private static URI jarUrlResolver(String modID, Class<?> location) throws URISyntaxException {
        return location.getProtectionDomain().getCodeSource().getLocation().toURI();
    }

    private static void unpack(Class<?> location, UnpackedResourcePack pack) {
        LOGGER.info("Starting to unpack {}", (Object)location.getName());
        Path unpackedPath = pack.getPackPath();
        Path metaPath = unpackedPath.resolve("pack.mcmeta");
        Path readmePath = unpackedPath.resolve("README.txt");
        try {
            Files.createDirectories(unpackedPath, new FileAttribute[0]);
        }
        catch (IOException e2) {
            LOGGER.error("Exception thrown while creating folders for the unpacked config resource pack (path: {}): {}", (Object)unpackedPath, (Object)e2);
        }
        if (!readmePath.toFile().exists() && pack.getReadme() != null) {
            LOGGER.info("Creating README.txt in unpacked resource pack folder.");
            try {
                Files.writeString(readmePath, (CharSequence)pack.getReadme(), new OpenOption[0]);
            }
            catch (IOException e3) {
                LOGGER.error("Failed to write README.txt");
                throw new RuntimeException(e3);
            }
        }
        int packFormat = 15;
        if (!metaPath.toFile().exists()) {
            LOGGER.info("Creating pack.mcmeta in unpacked resource pack folder.");
            String desc = pack.getReadme();
            if (desc == null) {
                desc = "An unpacked resource pack provided by MRU.";
            }
            try {
                Files.writeString(metaPath, (CharSequence)String.format("{\n  \"pack\": {\n    \"description\": \"%s\",\n    \"pack_format\": %d\n  }\n}\n", StringEscapeUtils.escapeJson((String)desc), packFormat), new OpenOption[0]);
            }
            catch (IOException e4) {
                LOGGER.error("Failed to write pack.mcmeta.");
                throw new RuntimeException(e4);
            }
        }
        try {
            String metaContent = Files.readString(metaPath);
            Gson GSON = new GsonBuilder().setPrettyPrinting().create();
            JsonObject object = (JsonObject)GSON.fromJson(metaContent, JsonObject.class);
            object.getAsJsonObject("pack").addProperty("pack_format", (Number)packFormat);
            Files.writeString(metaPath, (CharSequence)GSON.toJson((JsonElement)object), new OpenOption[0]);
            LOGGER.info("Updated pack.mcmeta to pack format {}", (Object)packFormat);
        }
        catch (IOException e5) {
            LOGGER.error("Failed to update pack.mcmeta.");
            throw new RuntimeException(e5);
        }
        try {
            URI jarUrl = Unpacker.jarUrlResolver(pack.getModID(), location);
            URL resourceUrl = location.getClassLoader().getResource("packed");
            if (resourceUrl == null) {
                throw new IllegalArgumentException("Resource not found: packed - There are no resources to unpack!");
            }
            URI uri = resourceUrl.toURI();
            LOGGER.info("Unpacking resources from: {}", (Object)uri);
            try {
                String jarPath = Paths.get(jarUrl).toString();
                LOGGER.info("Running from JAR file: {}", (Object)jarPath);
                try (JarFile jarFile = new JarFile(jarPath);){
                    Stream<JarEntry> entries = jarFile.stream();
                    entries.filter(e -> e.getName().startsWith("packed/")).forEach(entry -> {
                        Path targetPath = unpackedPath.resolve(entry.getName().substring("packed/".length()));
                        LOGGER.info("Unpacking: {}", (Object)targetPath);
                        if (entry.isDirectory()) {
                            try {
                                if (!Files.exists(targetPath, new LinkOption[0])) {
                                    Files.createDirectories(targetPath, new FileAttribute[0]);
                                }
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to create directory: {}", (Object)targetPath, (Object)e);
                            }
                        } else if (!Files.exists(targetPath, new LinkOption[0])) {
                            try (InputStream inputStream = jarFile.getInputStream((ZipEntry)entry);){
                                Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                LOGGER.error("Failed to copy file: {}", (Object)targetPath, (Object)e);
                            }
                        }
                    });
                }
            }
            catch (Exception ignored) {
                Path path = Paths.get(uri);
                Files.walk(path, new FileVisitOption[0]).forEach(sourcePath -> {
                    try {
                        Path relativePath = path.relativize((Path)sourcePath);
                        Path targetPath = unpackedPath.resolve(relativePath);
                        if (Files.isDirectory(sourcePath, new LinkOption[0])) {
                            if (!Files.exists(targetPath, new LinkOption[0])) {
                                Files.createDirectories(targetPath, new FileAttribute[0]);
                            }
                        } else if (!Files.exists(targetPath, new LinkOption[0])) {
                            Files.copy(sourcePath, targetPath, new CopyOption[0]);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to copy file.", (Throwable)e);
                    }
                });
            }
            pack.walkNamespaces();
        }
        catch (Exception e6) {
            LOGGER.error("Failed to unpack resources", (Throwable)e6);
        }
    }
}

