/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import me.justahuman.more_cobblemon_tweaks.MoreCobblemonTweaks;
import me.justahuman.more_cobblemon_tweaks.utils.Textures;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5244;
import net.minecraft.class_642;

public class ModConfig {
    private static final Gson GSON = new Gson().newBuilder().setPrettyPrinting().create();
    public static final JsonObject INTERNAL_CONFIG = new JsonObject();
    public static final JsonObject DEFAULT_CONFIG = new JsonObject();
    private static final Map<Integer, class_2561> BOX_NAME_CACHE = new HashMap<Integer, class_2561>();
    private static final Map<Integer, class_2960> WALLPAPER_CACHE = new HashMap<Integer, class_2960>();

    public static void loadFromFile() {
        INTERNAL_CONFIG.asMap().clear();
        WALLPAPER_CACHE.clear();
        BOX_NAME_CACHE.clear();
        try (FileReader reader = new FileReader(ModConfig.getConfigFile());){
            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                jsonObject.entrySet().forEach(entry -> INTERNAL_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
            }
        }
        catch (Exception e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while loading Config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static boolean isEnabled(String option) {
        JsonPrimitive primitive;
        JsonElement jsonElement = INTERNAL_CONFIG.get(option);
        return jsonElement instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement).isBoolean() ? primitive.getAsBoolean() : DEFAULT_CONFIG.get(option).getAsBoolean();
    }

    public static void setEnabled(String key, boolean value) {
        INTERNAL_CONFIG.addProperty(key, Boolean.valueOf(value));
    }

    public static class_2561 getBoxName(int box) {
        JsonPrimitive primitive;
        JsonObject object;
        JsonElement jsonElement;
        JsonObject boxNames;
        JsonObject object2;
        JsonObject serverBoxes;
        class_2561 cache = BOX_NAME_CACHE.get(box);
        if (cache != null) {
            return cache;
        }
        JsonElement jsonElement2 = INTERNAL_CONFIG.get("pc_box_names");
        JsonObject jsonObject = serverBoxes = jsonElement2 instanceof JsonObject ? (object2 = (JsonObject)jsonElement2) : null;
        if (serverBoxes == null) {
            BOX_NAME_CACHE.put(box, class_5244.field_39003);
            return null;
        }
        class_642 info = class_310.method_1551().method_1558();
        if (info == null) {
            info = new class_642("", "singleplayer", true);
        }
        JsonObject jsonObject2 = boxNames = (jsonElement = serverBoxes.get(info.field_3761)) instanceof JsonObject ? (object = (JsonObject)jsonElement) : null;
        if (boxNames == null) {
            BOX_NAME_CACHE.put(box, class_5244.field_39003);
            return null;
        }
        JsonElement jsonElement3 = boxNames.get(String.valueOf(box));
        class_2561 name = jsonElement3 instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement3).isString() ? class_2561.method_43470((String)primitive.getAsString()).method_27692(class_124.field_1067) : class_5244.field_39003;
        BOX_NAME_CACHE.put(box, name);
        return name;
    }

    public static void setBoxName(int box, String name) {
        JsonObject object;
        JsonObject boxNames;
        JsonObject object2;
        JsonElement jsonElement;
        class_642 info = class_310.method_1551().method_1558();
        if (info == null) {
            info = new class_642("", "singleplayer", true);
        }
        JsonObject serverBoxes = (jsonElement = INTERNAL_CONFIG.get("pc_box_names")) instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : new JsonObject();
        JsonElement jsonElement2 = serverBoxes.get(info.field_3761);
        JsonObject jsonObject = boxNames = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : new JsonObject();
        if (name == null || name.isBlank()) {
            boxNames.remove(String.valueOf(box));
            BOX_NAME_CACHE.put(box, class_5244.field_39003);
        } else {
            boxNames.addProperty(String.valueOf(box), name);
            BOX_NAME_CACHE.put(box, (class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1067));
        }
        serverBoxes.add(info.field_3761, (JsonElement)boxNames);
        INTERNAL_CONFIG.add("pc_box_names", (JsonElement)serverBoxes);
        ModConfig.saveConfig(false);
    }

    public static class_2960 getBoxTexture(int box) {
        JsonPrimitive primitive;
        JsonObject object;
        JsonElement jsonElement;
        JsonObject wallpapers;
        JsonObject object2;
        JsonObject pcWallpapers;
        class_2960 cache = WALLPAPER_CACHE.get(box);
        if (cache != null) {
            return cache;
        }
        JsonElement jsonElement2 = INTERNAL_CONFIG.get("pc_wallpapers");
        JsonObject jsonObject = pcWallpapers = jsonElement2 instanceof JsonObject ? (object2 = (JsonObject)jsonElement2) : null;
        if (pcWallpapers == null) {
            WALLPAPER_CACHE.put(box, Textures.WALLPAPER_DEFAULT_TEXTURE);
            return Textures.WALLPAPER_DEFAULT_TEXTURE;
        }
        class_642 info = class_310.method_1551().method_1558();
        if (info == null) {
            info = new class_642("", "singleplayer", true);
        }
        JsonObject jsonObject2 = wallpapers = (jsonElement = pcWallpapers.get(info.field_3761)) instanceof JsonObject ? (object = (JsonObject)jsonElement) : null;
        if (wallpapers == null) {
            WALLPAPER_CACHE.put(box, Textures.WALLPAPER_DEFAULT_TEXTURE);
            return Textures.WALLPAPER_DEFAULT_TEXTURE;
        }
        JsonElement jsonElement3 = wallpapers.get(String.valueOf(box));
        class_2960 wallpaper = jsonElement3 instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonElement3).isString() ? new class_2960(primitive.getAsString().replace("dystoriantweaks:", "more_cobblemon_tweaks:")) : Textures.WALLPAPER_DEFAULT_TEXTURE;
        WALLPAPER_CACHE.put(box, wallpaper);
        return wallpaper;
    }

    public static void setBoxTexture(int box, class_2960 texture) {
        JsonObject object;
        JsonObject object2;
        JsonElement jsonElement;
        class_642 info = class_310.method_1551().method_1558();
        if (info == null) {
            info = new class_642("", "singleplayer", true);
        }
        JsonObject pcWallpapers = (jsonElement = INTERNAL_CONFIG.get("pc_wallpapers")) instanceof JsonObject ? (object2 = (JsonObject)jsonElement) : new JsonObject();
        JsonElement jsonElement2 = pcWallpapers.get(info.field_3761);
        JsonObject wallpapers = jsonElement2 instanceof JsonObject ? (object = (JsonObject)jsonElement2) : new JsonObject();
        wallpapers.addProperty(String.valueOf(box), texture.toString());
        pcWallpapers.add(info.field_3761, (JsonElement)wallpapers);
        INTERNAL_CONFIG.add("pc_wallpapers", (JsonElement)pcWallpapers);
        WALLPAPER_CACHE.put(box, texture);
        ModConfig.saveConfig(false);
    }

    public static void saveConfig() {
        ModConfig.saveConfig(true);
    }

    public static void saveConfig(boolean resetCache) {
        if (resetCache) {
            BOX_NAME_CACHE.clear();
            WALLPAPER_CACHE.clear();
        }
        try (FileWriter fileWriter = new FileWriter(ModConfig.getConfigFile());){
            GSON.toJson((JsonElement)INTERNAL_CONFIG, (Appendable)fileWriter);
            fileWriter.flush();
        }
        catch (IOException e) {
            MoreCobblemonTweaks.LOGGER.warn("Error occurred while saving config!");
            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
        }
    }

    public static File getConfigFile() {
        File configFile;
        block13: {
            configFile = FabricLoader.getInstance().getConfigDir().resolve("more_cobblemon_tweaks.json").toFile();
            if (!configFile.exists()) {
                try {
                    configFile.getParentFile().mkdirs();
                    if (!configFile.createNewFile()) {
                        throw new IOException();
                    }
                    File oldFile = FabricLoader.getInstance().getConfigDir().resolve("dystorian_tweaks.json").toFile();
                    if (oldFile.isFile()) {
                        try (FileReader reader = new FileReader(oldFile);){
                            JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                            if (jsonElement instanceof JsonObject) {
                                JsonObject jsonObject = (JsonObject)jsonElement;
                                jsonObject.entrySet().forEach(entry -> INTERNAL_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
                            }
                            ModConfig.saveConfig();
                            break block13;
                        }
                        catch (Exception e) {
                            MoreCobblemonTweaks.LOGGER.warn("Error occurred while loading old Config!");
                            MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
                        }
                        break block13;
                    }
                    DEFAULT_CONFIG.entrySet().forEach(entry -> INTERNAL_CONFIG.add((String)entry.getKey(), (JsonElement)entry.getValue()));
                    ModConfig.saveConfig();
                }
                catch (IOException | SecurityException e) {
                    MoreCobblemonTweaks.LOGGER.warn("Failed to create config file!");
                    MoreCobblemonTweaks.LOGGER.warn(e.getMessage());
                }
            }
        }
        return configFile;
    }

    static {
        DEFAULT_CONFIG.addProperty("enhanced_egg_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("enhanced_berry_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("enhanced_consumable_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("enhanced_held_item_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("wt_compact_lore", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_iv_display", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("open_box_history", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("pc_search", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("custom_pc_wallpapers", Boolean.valueOf(true));
        DEFAULT_CONFIG.addProperty("custom_pc_box_names", Boolean.valueOf(true));
        DEFAULT_CONFIG.add("pc_wallpapers", (JsonElement)new JsonObject());
        DEFAULT_CONFIG.add("pc_box_names", (JsonElement)new JsonObject());
    }
}

