/*
 * Decompiled with CFR 0.152.
 */
package me.justahuman.more_cobblemon_tweaks.features;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.item.berry.FriendshipRaisingBerryItem;
import com.cobblemon.mod.common.item.berry.PPRestoringBerryItem;
import com.cobblemon.mod.common.item.interactive.CandyItem;
import com.cobblemon.mod.common.item.interactive.FeatherItem;
import com.cobblemon.mod.common.item.interactive.MintItem;
import com.cobblemon.mod.common.item.interactive.PPUpItem;
import com.cobblemon.mod.common.item.interactive.VitaminItem;
import com.cobblemon.mod.common.item.interactive.ability.AbilityChangeItem;
import java.util.List;
import java.util.Set;
import me.justahuman.more_cobblemon_tweaks.features.egg.EnhancedEggLore;
import net.fabricmc.loader.impl.util.StringUtil;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_2561;

public class LoreEnhancements {
    private static final Set<class_1792> TYPE_GEMS = Set.of(CobblemonItems.NORMAL_GEM, CobblemonItems.FIRE_GEM, CobblemonItems.WATER_GEM, CobblemonItems.GRASS_GEM, CobblemonItems.ELECTRIC_GEM, CobblemonItems.ICE_GEM, CobblemonItems.FIGHTING_GEM, CobblemonItems.POISON_GEM, CobblemonItems.GROUND_GEM, CobblemonItems.FLYING_GEM, CobblemonItems.PSYCHIC_GEM, CobblemonItems.BUG_GEM, CobblemonItems.ROCK_GEM, CobblemonItems.GHOST_GEM, CobblemonItems.DRAGON_GEM, CobblemonItems.DARK_GEM, CobblemonItems.STEEL_GEM, CobblemonItems.FAIRY_GEM);

    public static void enhanceEggLore(List<class_2561> lore, List<class_2561> newLore, EnhancedEggLore enhancedEggLore) {
        String gender;
        class_2561 name = enhancedEggLore.getName(lore);
        boolean shiny = enhancedEggLore.isShiny();
        if (shiny) {
            name = name.method_27661().method_10852((class_2561)class_2561.method_43470((String)" \u2605").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
        }
        if ((gender = enhancedEggLore.getGender()).equals("MALE") || gender.equals("FEMALE")) {
            boolean male = gender.equals("MALE");
            name = name.method_27661().method_10852((class_2561)class_2561.method_43470((String)(male ? " \u2642" : " \u2640")).method_27694(style -> style.method_36139(male ? 3329023 : 16536660)));
        }
        lore.set(0, name);
        List<class_2561> hatchProgress = enhancedEggLore.getHatchProgress();
        boolean spacer = false;
        if (hatchProgress != null && !hatchProgress.isEmpty()) {
            newLore.addAll(hatchProgress);
            spacer = true;
        }
        String nature = enhancedEggLore.getNature();
        String abilityName = enhancedEggLore.getAbility();
        String form = enhancedEggLore.getForm();
        if (!(nature.isBlank() && abilityName.isBlank() && form.isBlank() || !spacer)) {
            newLore.add((class_2561)class_2561.method_43470((String)" "));
            spacer = false;
        }
        if (!nature.isBlank()) {
            if (nature.contains(":")) {
                nature = StringUtil.capitalize((String)nature.substring(nature.indexOf(58) + 1));
            }
            newLore.add((class_2561)class_2561.method_43470((String)"Nature: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)nature).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (!abilityName.isBlank()) {
            newLore.add((class_2561)class_2561.method_43470((String)"Ability: ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)StringUtil.capitalize((String)abilityName)).method_27692(class_124.field_1068)));
            spacer = true;
        }
        if (!form.isBlank()) {
            newLore.add((class_2561)class_2561.method_43470((String)"Form: ").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)StringUtil.capitalize((String)form))));
            spacer = true;
        }
        if (enhancedEggLore.hasIVs()) {
            short hp = enhancedEggLore.getHpIV();
            short attack = enhancedEggLore.getAtkIV();
            short defense = enhancedEggLore.getDefIV();
            short spAttack = enhancedEggLore.getSpAtkIV();
            short spDefense = enhancedEggLore.getSpDefIV();
            short speed = enhancedEggLore.getSpeedIV();
            if (spacer) {
                newLore.add((class_2561)class_2561.method_43470((String)" "));
            }
            if (hp != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"HP: ").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(hp)).method_27692(class_124.field_1068)));
            }
            if (attack != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"Attack: ").method_27692(class_124.field_1078).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(attack)).method_27692(class_124.field_1068)));
            }
            if (defense != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"Defense: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(defense)).method_27692(class_124.field_1068)));
            }
            if (spAttack != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"Sp. Attack: ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spAttack)).method_27692(class_124.field_1068)));
            }
            if (spDefense != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"Sp. Defense: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(spDefense)).method_27692(class_124.field_1068)));
            }
            if (speed != -1) {
                newLore.add((class_2561)class_2561.method_43470((String)"Speed: ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(speed)).method_27692(class_124.field_1068)));
            }
        }
    }

    public static void enhanceBerryLore(class_1792 item, List<class_2561> newLore) {
        if (item instanceof FriendshipRaisingBerryItem) {
            FriendshipRaisingBerryItem friendshipBerry = (FriendshipRaisingBerryItem)item;
            LoreEnhancements.evBerry(newLore, friendshipBerry.getStat().getDisplayName().getString());
        } else if (item instanceof PPRestoringBerryItem) {
            newLore.add((class_2561)class_2561.method_43470((String)"Restores a selected move's PP when fed").method_27692(class_124.field_1080));
        }
    }

    public static void enhanceConsumablesLore(class_1792 item, List<class_2561> newLore) {
        if (item instanceof MintItem) {
            MintItem mint = (MintItem)item;
            newLore.add((class_2561)class_2561.method_43470((String)"Changes the stat effect of a Pok\u00e9mon's Nature to %s.".formatted(class_2561.method_43471((String)mint.getNature().getDisplayName()).getString())).method_27692(class_124.field_1080));
            newLore.add((class_2561)class_2561.method_43470((String)"Note: This does not change the Pok\u00e9mon's actual Nature.").method_27692(class_124.field_1080));
        } else if (item instanceof FeatherItem) {
            FeatherItem feather = (FeatherItem)item;
            LoreEnhancements.evFeather(newLore, feather.getStat().getDisplayName().getString());
        } else if (item instanceof VitaminItem) {
            VitaminItem vitamin = (VitaminItem)item;
            LoreEnhancements.evMedicine(newLore, vitamin.getStat().getDisplayName().getString());
        } else if (item instanceof PPUpItem) {
            if (item == CobblemonItems.PP_UP) {
                newLore.add((class_2561)class_2561.method_43470((String)"Increases the maximum PP of a selected move by 20% it's base PP. Can be stacked 3 times.").method_27692(class_124.field_1080));
            } else if (item == CobblemonItems.PP_MAX) {
                newLore.add((class_2561)class_2561.method_43470((String)"Increases the maximum PP of a selected move to 160% it's base PP."));
            }
        } else if (item instanceof CandyItem) {
            if (item == CobblemonItems.EXPERIENCE_CANDY_XS) {
                LoreEnhancements.expCandy(newLore, "100");
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_S) {
                LoreEnhancements.expCandy(newLore, "800");
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_M) {
                LoreEnhancements.expCandy(newLore, "3,000");
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_L) {
                LoreEnhancements.expCandy(newLore, "10,000");
            } else if (item == CobblemonItems.EXPERIENCE_CANDY_XL) {
                LoreEnhancements.expCandy(newLore, "30,000");
            } else if (item == CobblemonItems.RARE_CANDY) {
                newLore.add((class_2561)class_2561.method_43470((String)"Increases the Pok\u00e9mon's level by 1.").method_27692(class_124.field_1080));
            }
        }
    }

    public static void enhanceHeldItemLore(class_1792 item, List<class_2561> newLore) {
        if (TYPE_GEMS.contains(item)) {
            String type = StringUtil.capitalize((String)item.toString().replace("_gem", ""));
            newLore.add((class_2561)class_2561.method_43470((String)("Increases the power of a " + type + " type move by 30%.")).method_27692(class_124.field_1080));
            newLore.add((class_2561)class_2561.method_43470((String)" "));
            newLore.add((class_2561)class_2561.method_43470((String)"\u21e2 ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"Only activates once per battle.").method_27692(class_124.field_1061)));
        } else if (item instanceof AbilityChangeItem) {
            if (item == CobblemonItems.ABILITY_CAPSULE) {
                newLore.add((class_2561)class_2561.method_43470((String)"Changes the ability of a Pok\u00e9mon to it's alternative standard ability if possible.").method_27692(class_124.field_1080));
            } else if (item == CobblemonItems.ABILITY_PATCH) {
                newLore.add((class_2561)class_2561.method_43470((String)"Changes the ability of a Pok\u00e9mon to it's hidden ability.").method_27692(class_124.field_1080));
            }
        } else {
            String line = null;
            if (item == CobblemonItems.EJECT_BUTTON) {
                line = "Causes the holder to switch out if hit by a damaging move. Activates only once per battle.";
            } else if (item == CobblemonItems.FLOAT_STONE) {
                line = "Halves the holder's weight to a minimum of 0.1kg.";
            } else if (item == CobblemonItems.EVIOLITE) {
                line = "Boosts the holders Defense and Sp. Defense by 50% if they are not fully evolved.";
            } else if (item == CobblemonItems.WEAKNESS_POLICY) {
                line = "Raises the holder's Attack and Sp. Attack by two stages when hit by a super-effective move. Activates only once per battle.";
            }
            List<String> lines = null;
            if (item == CobblemonItems.STICKY_BARB) {
                lines = List.of("Damages the holder by 1/8 of the holder's maximum HP at the end of each turn.", "If a Pok\u00e9mon with no held item hits the holder with a contact move, the Sticky Barb is transferred to the attacker.");
            }
            if (line != null) {
                newLore.add((class_2561)class_2561.method_43470((String)line).method_27692(class_124.field_1080));
            } else if (lines != null) {
                newLore.addAll(lines.stream().map(class_2561::method_43470).map(text -> text.method_27692(class_124.field_1080)).toList());
            }
        }
    }

    private static void evBerry(List<class_2561> lore, String ev) {
        lore.add((class_2561)class_2561.method_43470((String)"Decreases the Pok\u00e9mon's %s EV by 10 (if possible), while raising friendship.".formatted(ev)).method_27692(class_124.field_1080));
    }

    private static void evFeather(List<class_2561> lore, String ev) {
        lore.add((class_2561)class_2561.method_43470((String)"Increases the Pok\u00e9mon's %s by 1 if possible.".formatted(ev)).method_27692(class_124.field_1080));
    }

    private static void expCandy(List<class_2561> lore, String amount) {
        lore.add((class_2561)class_2561.method_43470((String)"Increases a Pok\u00e9mon's experience by %s when used.".formatted(amount)).method_27692(class_124.field_1080));
    }

    private static void evMedicine(List<class_2561> lore, String ev) {
        lore.add((class_2561)class_2561.method_43470((String)"Increases the Pok\u00e9mon's %s EV by 10 if possible.".formatted(ev)).method_27692(class_124.field_1080));
    }
}

