/*
 * Decompiled with CFR 0.152.
 */
package git.dragomordor.simpletms.fabric.item.custom;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.BenchedMoves;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.moves.MoveTemplate;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import git.dragomordor.simpletms.fabric.config.SimpleTMsConfig;
import git.dragomordor.simpletms.fabric.item.custom.PokemonUseItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;

public class MoveTutorItem
extends PokemonUseItem {
    private final String moveName;
    private final String moveType;
    private final boolean SingleUse;
    private final int cooldownTicks = SimpleTMsConfig.getTMCooldownTicks();
    private static final Map<String, Integer> moveTypeColors = new HashMap<String, Integer>();

    public MoveTutorItem(String moveName, String moveType, boolean singleUse) {
        super(new FabricItemSettings().maxCount(1));
        this.moveType = moveType;
        this.moveName = moveName;
        this.SingleUse = singleUse;
    }

    @Override
    public class_1269 processInteraction(class_1799 itemStack, class_1657 player, PokemonEntity target, Pokemon pokemon) {
        MoveSet currentmoves = pokemon.getMoveSet();
        BenchedMoves benchedMoves = pokemon.getBenchedMoves();
        MoveTemplate taughtMove = Moves.INSTANCE.getByName(this.moveName);
        int cooldownTicks = SimpleTMsConfig.getTMCooldownTicks();
        if (player.method_7357().method_7904((class_1792)this)) {
            player.method_7353(class_2561.method_30163((String)"TM is on cooldown."), true);
            return class_1269.field_5814;
        }
        if (taughtMove == null) {
            player.method_7353(class_2561.method_30163((String)"Invalid move!"), true);
            return class_1269.field_5814;
        }
        if (currentmoves.getMoves().stream().anyMatch(move -> move.getTemplate().equals(taughtMove)) || this.benchedMovesContainsMove(benchedMoves, taughtMove)) {
            player.method_7353(class_2561.method_30163((String)(pokemon.getSpecies().getName() + " already knows " + taughtMove.getDisplayName().getString() + "!")), true);
            return class_1269.field_5814;
        }
        boolean canLearnMove = this.canLearnMove(itemStack, player, target, pokemon, taughtMove);
        if (!canLearnMove) {
            player.method_7353(class_2561.method_30163((String)(pokemon.getSpecies().getName() + " cannot be taught " + taughtMove.getDisplayName().getString())), true);
            return class_1269.field_5814;
        }
        if (currentmoves.hasSpace()) {
            currentmoves.add(taughtMove.create());
        } else {
            benchedMoves.add(new BenchedMove(taughtMove, 0));
        }
        player.method_7353(class_2561.method_30163((String)("Taught " + pokemon.getSpecies().getName() + " " + taughtMove.getDisplayName().getString() + "!")), true);
        if (this.SingleUse) {
            itemStack.method_7934(1);
        }
        if (!this.SingleUse && cooldownTicks > 0) {
            player.method_7357().method_7906((class_1792)this, cooldownTicks);
        }
        player.method_37908().method_8396(null, player.method_24515(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.0f);
        return class_1269.field_5812;
    }

    private boolean benchedMovesContainsMove(BenchedMoves benchedMoves, MoveTemplate taughtMove) {
        for (BenchedMove benchedMove : benchedMoves) {
            if (!benchedMove.getMoveTemplate().equals(taughtMove)) continue;
            return true;
        }
        return false;
    }

    private boolean canLearnMove(class_1799 itemStack, class_1657 player, PokemonEntity target, Pokemon pokemon, MoveTemplate taughtMove) {
        boolean canLearnMove = SimpleTMsConfig.getAreAllMovesLearnable();
        if (canLearnMove) {
            return true;
        }
        if (pokemon.getForm().getMoves().getTmMoves().contains(taughtMove)) {
            return true;
        }
        if (pokemon.getForm().getMoves().getTutorMoves().contains(taughtMove) && SimpleTMsConfig.getAreTutorMovesLearnable()) {
            return true;
        }
        return pokemon.getForm().getMoves().getEggMoves().contains(taughtMove) && SimpleTMsConfig.getAreEggMovesLearnable();
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        String moveType;
        super.method_7851(stack, world, tooltip, context);
        class_746 player = class_310.method_1551().field_1724;
        if (player != null && player.method_7357().method_7904((class_1792)this)) {
            int maxCooldownTicks = SimpleTMsConfig.getTMCooldownTicks();
            int ticksLeft = Math.round(player.method_7357().method_7905((class_1792)this, 0.0f) * (float)maxCooldownTicks);
            int hoursLeft = ticksLeft / 72000;
            int minutesLeft = ticksLeft % 72000 / 1200;
            int secondsLeft = ticksLeft % 1200 / 20;
            StringBuilder cooldownText = new StringBuilder("Cooldown: ");
            boolean hasContent = false;
            if (hoursLeft > 0) {
                cooldownText.append(hoursLeft).append(" hour").append(hoursLeft > 1 ? "s" : "");
                hasContent = true;
            }
            if (minutesLeft > 0) {
                if (hasContent) {
                    cooldownText.append(", ");
                }
                cooldownText.append(minutesLeft).append(" minute").append(minutesLeft > 1 ? "s" : "");
                hasContent = true;
            }
            if (secondsLeft > 0 || !hasContent && ticksLeft == 0) {
                if (hasContent) {
                    cooldownText.append(", ");
                }
                cooldownText.append(secondsLeft).append(" second").append(secondsLeft > 1 ? "s" : "");
            }
            String cooldownTextString = cooldownText.toString();
            class_2585 cooldownLiteralTextContent = new class_2585(cooldownTextString);
            class_5250 cooldownDisplayTextContent = class_5250.method_43477((class_7417)cooldownLiteralTextContent).method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
            tooltip.add((class_2561)cooldownDisplayTextContent);
        }
        if (this.SingleUse) {
            String singleUseString = "Consumed after use";
            class_2585 singleUseLiteralTextContent = new class_2585(singleUseString);
            class_5250 singleUseDisplayTextContent = class_5250.method_43477((class_7417)singleUseLiteralTextContent).method_10862(class_2583.field_24360.method_10977(class_124.field_1079));
            tooltip.add((class_2561)singleUseDisplayTextContent);
        }
        if (moveTypeColors.containsKey(moveType = this.moveType)) {
            int color = moveTypeColors.get(moveType);
            class_2585 moveContent = new class_2585(moveType);
            class_5250 moveTypeText = class_5250.method_43477((class_7417)moveContent).method_10862(class_2583.field_24360.method_36139(color));
            tooltip.add((class_2561)moveTypeText);
        }
    }

    public String getMoveType() {
        return this.moveType;
    }

    public String getMoveName() {
        return this.moveName;
    }

    static {
        moveTypeColors.put("Bug", 11987073);
        moveTypeColors.put("Dark", 6856873);
        moveTypeColors.put("Dragon", 11120849);
        moveTypeColors.put("Electric", 15974144);
        moveTypeColors.put("Fairy", 15638422);
        moveTypeColors.put("Fighting", 14184448);
        moveTypeColors.put("Fire", 14098944);
        moveTypeColors.put("Flying", 11458793);
        moveTypeColors.put("Ghost", 11231964);
        moveTypeColors.put("Grass", 4109654);
        moveTypeColors.put("Ground", 15722563);
        moveTypeColors.put("Ice", 9756914);
        moveTypeColors.put("Normal", 0xFFFFFF);
        moveTypeColors.put("Poison", 12810682);
        moveTypeColors.put("Psychic", 15972527);
        moveTypeColors.put("Rock", 13479982);
        moveTypeColors.put("Steel", 0xD0D0D0);
        moveTypeColors.put("Water", 6531307);
    }
}

