/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_339;
import net.minecraft.class_7838;
import net.minecraft.class_8021;

public class DynamicGridWidget
extends class_7838 {
    private final List<GridItem> children = new ArrayList<GridItem>();
    private int padding = 0;

    public DynamicGridWidget(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void addChild(class_339 widget, int cellHeight, int cellWidth) {
        this.children.add(new GridItem(cellHeight, cellWidth, widget));
    }

    public void addChild(class_339 widget) {
        this.children.add(new GridItem(-1, -1, widget));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    private boolean canFit(int gridX, int gridY, int cellWidth, int cellHeight, int optimalCells, boolean[][] grid) {
        if (gridX >= optimalCells || gridY >= optimalCells) {
            return false;
        }
        for (int x = gridX; x < gridX + cellWidth; ++x) {
            for (int y = gridY; y < gridY + cellHeight; ++y) {
                if (x >= grid.length || y >= grid[x].length) {
                    throw new RuntimeException("Impossible to fit widget in grid!");
                }
                if (!grid[x][y]) continue;
                return false;
            }
        }
        return true;
    }

    public void calculateLayout() {
        int totalCells = 0;
        for (GridItem child : this.children) {
            int widgetCells = child.cellWidth() * child.cellHeight();
            totalCells += widgetCells;
        }
        int optimalCells = (int)Math.ceil(Math.sqrt(totalCells));
        int cellWidth = this.field_41813 / optimalCells;
        int cellHeight = this.field_41814 / optimalCells;
        boolean[][] grid = new boolean[optimalCells][optimalCells];
        int currentX = this.method_46426();
        int currentY = this.method_46427();
        for (GridItem child : this.children) {
            boolean isMultiCell;
            int gridX = currentX / cellWidth;
            int gridY = currentY / cellHeight;
            while (!this.canFit(gridX, gridY, Math.abs(child.cellWidth()), Math.abs(child.cellHeight()), optimalCells, grid)) {
                if ((currentX += cellWidth) >= this.field_41813) {
                    currentX = this.method_46426();
                    currentY += cellHeight;
                }
                gridX = currentX / cellWidth;
                gridY = currentY / cellHeight;
            }
            if (gridX > optimalCells || gridY > optimalCells) {
                throw new RuntimeException("Impossible to fit widget in grid!");
            }
            if (grid[gridX][gridY]) {
                if ((currentX += cellWidth) >= this.field_41813) {
                    currentX = this.method_46426();
                    currentY += cellHeight;
                }
                gridX = currentX / cellWidth;
                gridY = currentY / cellHeight;
            }
            int thisCellWidth = cellWidth;
            int thisCellHeight = cellHeight;
            boolean bl = isMultiCell = child.cellHeight() > 1 || child.cellWidth() > 1;
            if (child.cellWidth() != -1) {
                thisCellWidth = child.cellWidth() * cellWidth;
            }
            if (child.cellHeight() != -1) {
                thisCellHeight = child.cellHeight() * cellHeight;
            }
            if (isMultiCell) {
                int minX = gridX;
                int minY = gridY;
                int maxX = gridX + child.cellWidth();
                int maxY = gridY + child.cellHeight();
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        grid[x][y] = true;
                    }
                }
            } else {
                grid[gridX][gridY] = true;
            }
            child.widget().method_46421(currentX);
            child.widget().method_46419(currentY);
            child.widget().method_25358(thisCellWidth - this.padding * 2);
            child.widget().field_22759 = thisCellHeight - this.padding * 2;
            if ((currentX += thisCellWidth) < this.field_41813) continue;
            currentX = this.method_46426();
            currentY += thisCellHeight;
        }
    }

    public void method_48227(Consumer<class_8021> consumer) {
        this.children.stream().map(GridItem::widget).forEach(consumer);
    }

    public record GridItem(int cellHeight, int cellWidth, class_339 widget) {
    }
}

